# /unix/nui/installer/tools/lib/UIF.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1998, Lotus Development Corporation.
## All Rights Reserved.


package UIF; # "user interface framework"


CdPath::Require("PerlUtil.pl");	import PerlUtil;
CdPath::Require("UIF.nls");		import UIF_nls;


sub new {
	local($class, $ctx, $uicfile) = @_;
	local($self) = {
		rows		=> 0,
		cols		=> 0,

		screenObj	=> {},		# hash of screen names to screen objs
		screenIndex	=> {}		# hash of screen names to indices
	};
	bless $self;

	CdPath::Require($uicfile);		import UIC;

	$self->CheckTerminalSize() || return undef;
	$UIS::rows = $self->{rows};
	$UIS::cols = $self->{cols};
	$self->{rev}     = $ctx->{rev};
	$self->{baserev} = $ctx->{baserev};
	$self->{uicfile} = $uicfile;
	local($screen);
	local($i) = 0;
	foreach $screen (@UIC::list_o_screens) {
	    import $screen;
	    $self->{screenObj}->{$screen} = new $screen ($ctx);
	    $self->{screenIndex}->{$screen} = $i++;
	}

	return $self;
}


sub DoIt {
	local($self) = @_;

	local($i, $curScreen, $action, $bChain, $jumpDest);
	local($lastDirection) = "next";
	local(@screenStack) = ();
	local($arch) = $ENV{'NUI_ARCH'};

	$| = 1;

	$curScreen = $UIC::list_o_screens[0];
	while (1) {

		$bChain = 1;
		$jumpDest = "";

		$action = 
			$self->{screenObj}->{$curScreen}->
				DecideWhatToDoAndDoIt(\$bChain, \$jumpDest);

		if ($action eq "noshow") {
			$bChain = 0;
			$action = $lastDirection;
		}

		if ($action eq "exit") {
			$action = "jump";
			$bChain = 1;
			$jumpDest = "UIC_Exit";
		}
		
		if ($action eq "prev") {
			$lastDirection = "prev";
			if ($#screenStack < 0) {
				print "FATAL ERROR: empty screen stack on prev\n";
				exit 1;
			} else {
				$newScreen = pop(@screenStack);
				$curScreen = $newScreen;
			}

		} elsif ($action eq "next") {
			$lastDirection = "next";
			$bChain && push(@screenStack, $curScreen);
			$i = $self->{screenIndex}->{$curScreen} + 1;
			if ($i > $#UIC::list_o_screens) {
				print "FATAL ERROR: last screen index on next\n";
				exit 1;
			}
			$curScreen = $UIC::list_o_screens[$i];
			#handle the incrmental installation from 5080 to 50090
			if(($self->{baserev} eq  "5080") && 
			   ($self->{rev} eq  "50090") &&  
			   ($self->{uicfile} eq "UIC_Incr.pm")) {
			    if( $curScreen  =~ /UIC_IncInstallInotes/) {
				if ( ($arch =~ /^sol$/) || ($arch =~ /^aix/) ){
				} else {
				    $i = $self->{screenIndex}->{$curScreen} + 1;
				    $curScreen = $UIC::list_o_screens[$i];
				}
			    }			    
			} else {
			    if( $curScreen  =~ /UIC_DoInstallInotes/) {
				if ( ($arch =~ /^sol$/) || ($arch =~ /^aix/) ){
				} else {
				    $i = $self->{screenIndex}->{$curScreen} + 1;
				    $curScreen = $UIC::list_o_screens[$i];
				}
			    }
			}
		} elsif ($action eq "jump") {
			$bChain && push(@screenStack, $curScreen);
			$curScreen = $jumpDest;

		} elsif ($action eq "exit_really") {
			system($Sys::clear);
			exit 0;
		}
	}
}


sub CheckTerminalSize {
	local($self) = @_;

	local($MinTermLines)	= 24;
	local($MinTermColumns)	= 80;

	local($arch) = $ENV{'NUI_ARCH'};
	local($rows, $cols, $norowcolcheck);
	local($stty_out, @fields, $item, $last);

	if ( ($arch =~ /^sol/) || ($arch =~ /^hp/) ){
		$stty_out = `$Sys::env LANG=C LC_ALL=C $Sys::stty -a`;
		($rows) = ($stty_out =~ /rows\s*\S+\s*([0-9]+)/);
		($cols) = ($stty_out =~ /columns\s*\S+\s*([0-9]+)/);
	} elsif ($arch =~ /^aix/) {
		$stty_out = `$Sys::env LANG=C LC_ALL=C $Sys::stty -a`;
		@fields = split(/ /, $stty_out);
		foreach $item (@fields) {
			$item =~ tr/A-Z/a-z/;
			if ($item =~ /^rows/) {
				$rows = $last;
			} elsif ($item =~ /^columns/) {
				$cols = $last;
			}
			$last = $item;
		}
	} elsif (($arch =~ /^linux/) || ($arch =~ /^zlinux/)) {
		$stty_out = `$Sys::env LANG=C LC_ALL=C $Sys::stty -a`;
		($rows) = ($stty_out =~ /rows\s+([0-9]+)/);
		($cols) = ($stty_out =~ /columns\s+([0-9]+)/);
        } elsif ($arch =~ /^os390/) {
                $stty_out = `$Sys::env LANG=C LC_ALL=C $Sys::stty -a`;
                @fields = split(/ /, $stty_out);
                foreach $item (@fields) {
                        $item =~ tr/A-Z/a-z/;
                        }
                        $rows = 24;
                        $cols = 80;
                        $last = $item;
	} else {
		$rows = $cols = 0;
	}

	$norowcolcheck = $ENV{LOTUS_NOROWCOLCHECK} || $ENV{lotus_norowcolcheck};
	#print "norowcolcheck = $norowcolcheck\n";

	if ( ($norowcolcheck==0) && $rows && $cols ) {
		if ( ($rows < $MinTermLines) || ($cols <$MinTermColumns) ) {
			print 
				$txt{1.1} .
				${MinTermColumns} .
				$txt{1.2} .
				${MinTermLines} .
				$txt{1.3};
			return 0;
		} else {
			$self->{rows} = $rows;
			$self->{cols} = $cols;
			return 1;
		}
	}

	$rows = $ENV{LINES};
	$cols = $ENV{COLUMNS};

	if ( ($norowcolcheck==0) && (($rows < $MinTermLines) || ($cols <$MinTermColumns)) ) {
		print
			$txt{2.1} .
			${MinTermColumns} .
			$txt{2.2} .
			${MinTermLines} .
			$txt{2.3};
		return 0;
	}
	if ( $rows < 24) {
		$self->{rows} = 24;
	} else {
		$self->{rows} = $rows;
	}
	
	if ($cols < 80 ) {
		$self->{cols} = 80;
	} else {
		$self->{cols} = $cols;
	}
	return 1;
}

1;
