# /unix/nui/installer/tools/lib/UIC_Fix.pm
#
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1998, Lotus Development Corporation.
## All Rights Reserved.


CdPath::Require("UIC_Fix.nls");


package UIC; # "user interface custom"

CdPath::Require("PerlUtil.pl");	import PerlUtil;
CdPath::Require("PathUtil.pl");	import PathUtil;
CdPath::Require("UIS.pm");		import UIS;
CdPath::Require("NIC.pm");		import UIS;
# for UIC_CheckExisting
CdPath::Require("CfgData.pm"); import CfgData;

# the order here is the chain sequence
#
@list_o_screens = qw(
    UIC_Welcome
    UIC_LicenseIntro
    UIC_LicenseText
    UIC_LicenseAccept
    UIC_CheckExisting
    UIC_InstallType
    UIC_DoInstall
    UIC_Exit
);


######################################################################
#

######################################################################
#
package UIC_LicenseIntro;
@ISA = (UIS_Info);
 
sub new {
    local($class, $ctx) = @_;
 
    local($self) = new UIS_Info ();
    bless $self;
    $self->{UIC} = "UIC_LicenseIntro";
	$self->{ctx} = $ctx;
 
	# no help
    $self->{ValidActions} = [qw(exit next prev)];
 
    return $self;
}
 
sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;

	if ($ENV{NUI_NOLIC}) {
		$self->{ctx}->{bLicenseOk} = 1;
	}

	if ($self->{ctx}->{bLicenseOk}) {
		$$bChain = 0;
		return "noshow";
	}

	if ($ENV{'NUI_DEV'}) {
		$UIC_LicenseText::bodytext = "\ndev license text\n\n";
	} elsif ( ! $UIC_LicenseText::bodytext) {
		local(*LICFILE, $licfilename, $licfilepath);
		
		$licfilename = $self->GetString("license_file");
		$licfilepath = CdPath::CdPath($licfilename);
		if ( ! -e $licfilepath) {
			$self->{ctx}->{bLicenseOk} = 1;
			$$bChain = 0;
			return "noshow";
		}

		$UIC_LicenseText::bodytext = "";
		open(LICFILE, "<$licfilepath") || die;
		while (<LICFILE>) {
			$UIC_LicenseText::bodytext .= $_;
		}
		close(LICFILE);
	}

    local($action);
    $action = $self->GetAction();

    return  $action;
}
#
######################################################################


######################################################################
#
package UIC_LicenseText;
@ISA = (UIS_Scrolltext);
 
sub new {
    local($class, $ctx) = @_;
 
    local($self) = new UIS_Scrolltext ();
    bless $self;
    $self->{UIC} = "UIC_LicenseText";
	$self->{ctx} = $ctx;
 
    return $self;
}
 
sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;

	$$bChain = 0;

	if ($self->{ctx}->{bLicenseOk}) {
		return "noshow";
	}
 
    return $self->GetAction();
}
#
######################################################################


######################################################################
#
package UIC_LicenseAccept;
@ISA = (UIS_BoolCycle);
 
sub new {
    local($class, $ctx) = @_;
 
    local($self) = new UIS_BoolCycle ();
    bless $self;
    $self->{UIC} = "UIC_LicenseAccept";
    $self->{ctx} = $ctx;

    # no help
    $self->{ValidActions} = [qw(exit next prev)];
 
    $self->{defaultVal} = $self->GetString("defaultVal");
 
    return $self;
}
 
sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;

	$$bChain = 0;
	
	$self->{ctx}->{bLicenseOk} && return "next";
 
    local($retVal, $action);
 
    $action = $self->GetAction(\$retVal);

	if ($action eq "next") {
		$self->{ctx}->{bLicenseOk} = $retVal;
		if ( ! $self->{ctx}->{bLicenseOk}) {
 			$action = "jump";
			$$jumpDest = "UIC_LicenseIntro";
		}
	}


    return $action;
}
#
######################################################################


package UIC_Exit;
@ISA = (UIS_BoolCycle);

sub new {
    local($class, $ctx) = @_;

    local($self) = new UIS_BoolCycle ();
    bless $self;
    $self->{UIC} = "UIC_Exit";
    $self->{ctx} = $ctx;

    # no help
    $self->{ValidActions} = [qw(next prev)];

    $self->{defaultVal} = $self->GetString("defaultVal");

    return $self;
}

sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;

    $$bChain = 0;

    local($retVal, $action);

    $action = $self->GetAction(\$retVal);

    if ($action eq "next") {
        $action = "prev";
        $retVal && ($action = "exit_really");
    }

    return $action;
}
#
######################################################################



######################################################################
#
package UIC_Welcome;
@ISA = (UIS_Info);

sub new {
    local($class, $ctx) = @_;

    local($self) = new UIS_Info ();
    bless $self;
    $self->{UIC} = "UIC_Welcome";
    $self->{ctx} = $ctx;

    # UIC_Welcome is first, thus no prev
    $self->{ValidActions} = [qw(help exit next)];

    return $self;
}

sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;

    local($action);

    $action = $self->GetAction();

    return  $action;
}
#
######################################################################


######################################################################
#
package UIC_CheckExisting;
@ISA = (UIS_ListCycle);


sub new {
    local($class, $ctx) = @_;
 
    local($self) = new UIS_ListCycle ();
    bless $self;
    $self->{UIC} = "UIC_CheckExisting";
    $self->{ctx} = $ctx;
 
	# e or ESC to exit (only; otherwise "noshow")
#	$self->{ValidActions} = [qw(exit prev)];
	

    return $self;
}
 
sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;
 
    local($action, $listfixrev);
    
    local($ctx) = $self->{ctx};
    local($ok) = 1;
    local ($valid_version) = 0;
    local ($fix_type) = 'upgrade';
    my $strings_file;    
	# check local installation

	if ( ! -f $ENV{NUI_CFGFILE} ) {
	    $bodytext .= "Invalid install file : $ENV{NUI_CFGFILE}\n";
	    $ok = 0;
	}
    #check new config info (rev and checksums)
    $nuicfgfile = CdPath::CdPath("sets/data/nui.cfg");
    $nuicfg = new CfgData ();
    print "\n\n\nVerifying the installation data, this can take several minutes - please, wait...\n";
    if ( ! $nuicfg->InitFromFile($nuicfgfile)) {
	Out($nuicfg->GetErrorMessage());
	$ok = 0;
    }
    $nuicfgdat = $nuicfg->GetData();
    undef $nuicfg;
    $listfixrev = $nuicfgdat->{fix_rev};
    if (defined ($nuicfgdat->{nsdfix}) ) {
	$valid_version = 1;
    }
  if (defined ($nuicfgdat->{customfix}) ) {
	$valid_version = 1;
    }
  if (defined ($nuicfgdat->{saasfix}) ) {
	$valid_version = 1;
    }  
	
    $lastfixrev  = pop(@$listfixrev);
    local($prevctxcfg, $prevctx);
    $prevctxcfg = CfgData->new();
    if (! $prevctxcfg->InitFromFile($ENV{NUI_CFGFILE})) {
	fix_nui_cfg($ENV{NUI_CFGFILE});
	undef $prevctxcfg;
	$prevctxcfg = CfgData->new();
	if ( !$prevctxcfg->InitFromFile($ENV{NUI_CFGFILE})) {   
	    $ok = 0;
	    $bodytext .= $ENV{NUI_CFGFILE}.$bodytext3;
	}	
    }

    
    if ( $ok) {
    	$prevctx = $prevctxcfg->GetData();
	undef $prevctxcfg;
	
	# copy cfg data common to all revs
	#
	foreach (
		 qw( installation_type ptPath program_directory pPath)
		 ) {
	    $ctx->{$_} = $prevctx->{$_};
	}
	# added to handle hot fix info
	#after 602CF2 change! take the rev not from the prevctx, 
        #but from the strings.res itself: more precise	
        $strings_file = NIC::FindStrings($ctx->{pPath});
	if (!defined $strings_file){
	    print "Couldn't find strings.res in $ctx->{ptPath} - will attempt to use default\n" ;
	    $strings_file = $ctx->{pPath} ."/res/C/strings.res";	
	}
	@resInput = ($strings_file,'1','read');
	$prev = "\"".StringsRes::DoStringsRes(@resInput)."\"";
	($previous_rev = StringsRes::GetShortVersion($prev)) or die "Can't GetShortVersion: !?";
	#85 daily clean up
	$previous_rev =~ s/Build//;	    
	$previous_rev =~ s/V//;
	 $previous_rev =~ s/NP//;
	 $previous_rev =~ s/^\s*//;   
	if ($previous_rev eq $nuicfgdat->{rev}){
#	if ($prevctx->{rev} eq $nuicfgdat->{rev}){
	    #check checksums for upgrade
	    $valid_version = 1;	 
	    $fix_type = 'upgrade';
	    $self->{ctx}->{base_version} = $prevctx->{rev};
	    $self->{ctx}->{target_version} =  $lastfixrev;
	}
	else{ #check if it's revert first	    
	 #   if ($prevctx->{rev} eq $lastfixrev) {
	    # daily 85?
	    $previous_rev =~ s/Build//;	    
	    $previous_rev =~ s/V//;
	    $previous_rev =~ s/NP//;
	    $previous_rev =~ s/^\s*//;   
	    if ($previous_rev eq $lastfixrev) {
		# revert
		$valid_version = 1;	
		$fix_type = 'revert';
		
	#	$bodytext = $bodytext1." $prevctx->{rev}\n". $bodytext2;
		$bodytext = $bodytext1." $previous_rev\n". $bodytext2;
		#define @tags and corresponding revisions to revert to:
		local $i = 0;
		$dest = $prevctx->{pPath}."/".$nuicfgdat->{rev};
		if (-d $dest){
		    push (@tags,$i);
		    $tagText{$i++} = $nuicfgdat->{rev};
		}
		while ($currev = pop(@$listfixrev)){
		    $dest = $prevctx->{pPath}."/".$currev;
		    if (-d $dest){
			push (@tags,$i);
			$tagText{$i++} = $currev;
		    }
		}
		$self->{defaultTag} = "0"; #to get prompt in place
		$action = $self->GetAction(\$retTag);
		if ($action eq "next") {
		    $self->{defaultTag} = $retTag;
		    $self->{ctx}->{target_version} = $tagText{$retTag};
		 #   $self->{ctx}->{base_version} = $prevctx->{rev};
		    $self->{ctx}->{base_version} = $previous_rev;
		    $ctx->{fix_type} = $fix_type;
		}
	    
	    }
	    else{
		# this is not the base revision, but also not a last fix revision
		# check if it's some intermediate fix to be upgraded further:
		foreach $currev (@$listfixrev){
		   # if ($currev eq $prevctx->{rev}){
		    if ($currev eq $previous_rev){
			#upgrade  
			$valid_version = 1;	
		#	$self->{ctx}->{base_version} = $prevctx->{rev};
			$self->{ctx}->{base_version} = $previous_rev;
			$self->{ctx}->{target_version} = $lastfixrev;
			$fix_type = 'upgrade';
		    }
		}
	    }

	}
	$ctx->{valid_version} = $valid_version;
	$ctx->{fix_type} = $fix_type;
	#
	# copy rev-specific cfg data
	#

	$ctx->{data_directories} = 
	  PerlUtil::CopyData($prevctx->{data_directories});
	
	
} else {
    $ok = 0;
    $bodytext .= $ENV{NUI_CFGFILE}.$bodytext3;
}
    
    if ( ! $ok || !$valid_version) {
	# no valid version found: exit
#	if (defined ($prevctx->{rev})){
#	    $bodytext .= "              $prevctx->{rev}".$bodytext2;
    if (defined ($previous_rev) ) {
	$bodytext .= "              $previous_rev".$bodytext2;
    }
        $navtext = $navtext1;
	$self->{ValidActions} = [qw(exit)];
	$action = $self->GetAction(\$retTag);
	
	$prompt = '';
	return "exit_really";
    }

    return "noshow";
}



sub fix_nui_cfg{
my $filename = shift;
my $out = "";
my $susp_out = "";
$tempcfg = $filename."_temp";
open (NEW_NUI_CFG,">$tempcfg")  or die "Can't open $tempcfg:$!";
open (NUI_CFG, "<$filename") or die "Can't open $filename:$!";
while (<NUI_CFG>){
    if (/[\(\{][a-zA-Z0-9]+/){
	$suspicious = 0;
	$out .= $susp_out;
	$out.=$_;
	$susp_out = "";
	next;
    }
   # unquoted strings with special chars in R8:
    if  (/(pPath|program_directory|ptPath)\s*=\s*(.+)$/){
	$out .= "$1 = \"".$2."\"\n";
	next;
    }
    if (/cfp_lp_prev = Release/){
	$out.=StringsRes::GetShortVersion($cfp_lp_prev);
	next;
    }
    if (/[\(\{]([^A-Za-z\"][\s\n]*)[\)\}]*/) {
	if (/[\)\}]/){ #closed - empty parenthesis on one line
	   $suspicious = 0;
	   next unless $1 =~ /[A-Za-z]+/;  # skip empty lines
	}
	$suspicious = 1;
	$susp_out .= $_;
	next;
    }
    if ($suspicious){
	if (/^[\s]*$/){
	    $susp_out .= $_;
	    next;
	}
	if (/^[\s\n]*[\)\}]/) {
	    $suspicious = 0;
	    next;
	}
	# non-blank characters
	$suspicious = 0;
	$out .= $susp_out;
	$susp_out = "";
    }
    $out.=$_;
    
}
print NEW_NUI_CFG $out;
close NUI_CFG;
close NEW_NUI_CFG;
rename ($filename,"$filename.old") or die "Can't rename $filename:$!";

rename ($tempcfg, $filename) or die "Can't rename $tempcfg to $filename: $!";
if ( -e $filename ) {
    unlink ("$filename.old") or warn  "Can't unlink $filename.old:$!";
}
else {
    rename("$filename.old", $filename);
}
}
#
######################################################################
######################################################################
#
package UIC_InstallType;
@ISA = (UIS_ListCycle);
 
sub new {
    local($class, $ctx) = @_;
 
    local($self) = new UIS_ListCycle ();
    bless $self;
    $self->{UIC} = "UIC_InstallType";
    $self->{ctx} = $ctx;
    #set default installation type to whatever was read from the .install.dat
    $self->{defaultTag} = $self->{ctx}->{installation_type};
 
    return $self;
}
 
sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;
 
    local($retTag, $action);
    $self->{defaultTag} = $self->{ctx}->{installation_type};
    # check if installation type could be overwritten by
    # QuickPlace i.e. == 1 
    if (($self->{ctx}->{installation_type} !=  1)||
	!(-e "$self->{ctx}->{pPath}"."/libquickplace.so")){
 
	$action = "next";	
	return $action;
    }
    
    $action = $self->GetAction(\$retTag);

    if ($action eq "next") {
        $self->{defaultTag} = $retTag;
        $self->{ctx}->{installation_type} = $retTag;
    }

 
    return $action;
}

######################################################################
#
package UIC_DoInstall;
@ISA = (UIS_Scrolltext);

sub new {
    local($class, $ctx) = @_;

    local($self) = new UIS_Scrolltext ();
    bless $self;
    $self->{UIC} = "UIC_DoInstall";
    $self->{ctx} = $ctx;

    $self->{ValidActions} = [qw(exit prev next)];

    return $self;
}

sub DecideWhatToDoAndDoIt {
    local($self, $bChain, $jumpDest) = @_;

    local($_);
    local($action, $install_type,$base_version, $target_version, $fix_type);


    $bodytext = $self->{ctx}->{nic}->GetCfgSummary($self->{ctx});

	$action = $self->GetAction();
	if ($action ne "next") {
		return "exit_really";
	}


	# do it

	local($scrfile, *SCRFILE, $status, $cmd);
    
	$self->DrawBody();
        $install_type = $self->{ctx}->{installation_type};
    if (!defined $install_type) {
	$install_type = 3;
    }
        $base_version = $self->{ctx}->{base_version};
        $target_version = $self->{ctx}->{target_version};
        $fix_type = $self->{ctx}->{fix_type};
	$scrfile = "/tmp/script.$$";
	open(SCRFILE, ">$scrfile") || die;
        print SCRFILE "ui = 1\n";
        print SCRFILE "installType=$install_type\n";
        print SCRFILE "base_version = \"$base_version\"\n";
        print SCRFILE "target_version = \"$target_version\"\n";
        print SCRFILE "fix_type = \"$fix_type\"\n";
	close(SCRFILE) || die;

	$cmd = CdPath::CdPathShellString("tools/lib/InstBE.pl");
	$cmd = "$ENV{'PERL'}   $cmd $scrfile";
	$status = system($cmd);
	$status /= 256;
	exit $status;
}




1;
