# /unix/nui/installer/tools/lib/SysCmd.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1997, Lotus Development Corporation.
## All Rights Reserved.

package SysCmd;

CdPath::Require("SysCmd.nls");  import SysCmd_nls;


sub InitCmds {
	local(	$arCmds, $arNotFound, $srErrMsg, $arch ) = @_;

	local( @path ) = qw (
		/usr/bin
		/bin
		/usr/ucb/bin
		/usr/ccs/bin
		/usr/ucb
		/usr/sbin
		/sbin
	);

	local($_);
	local($cmd, $archcmd, $dir, %cmdhash, $found);

	push( @path, split(':', $ENV{'PATH'}) );

	foreach $cmd (@{$arCmds}) {

		if (($cmd eq "rsh") && ($ENV{'NUI_RSH'} =~ /^\s*\//)) {
		 	if (-x $ENV{'NUI_RSH'}) {
				$cmdhash{$cmd} = "$ENV{'NUI_RSH'}";
			} else {
				push( @{$arNotFound}, $ENV{'NUI_RSH'});
			}
			next;
		}

		$found = 0;

		# cmds with arch-specific variants
		if ( $cmd eq "rsh" ) {
			if ($ENV{'NUI_RSH'}) {
				$archcmd = $ENV{'NUI_RSH'};
			} elsif ($arch eq "hpux") {
				$archcmd = "remsh";
			} else {
				$archcmd = "rsh";
			}
		} else {
			$archcmd = $cmd;
		}

		foreach $dir (@path) {
			if (-x "$dir/$archcmd") {
				$cmdhash{$cmd} = "$dir/$archcmd";
				$found = 1;
				last;
			}
		}

		if ( ! $found) {
			push( @{$arNotFound}, $archcmd );
		}
	}
	
	foreach $cmd (keys(%cmdhash)) {
		eval( "\$Sys::$cmd = \"$cmdhash{$cmd}\"" );
	}
	if (scalar(@{$arNotFound})) {
		$$srErrMsg = $txt{1};
		foreach (@{$arNotFound}) {
			$$srErrMsg .= "  $_\n";
		}
		return 0;
	} else {
		return 1;
	}
}

1;
