# /unix/nui/installer/tools/lib/StringsRes.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
#--------------------------------------------------------------------------------
#Invocation: DoStringsRes(<filename with path of the stringes.res file>,
#				  <msgID to search for>, 
#				  <command>,
#				  <Text for this msgID if command is 'write'> );
#	where: msgID is "0001" for the Release data . This includes Release name
#		   and Date with a "|" between them.
#	       command is either "read" or "write" (write command always reads 
#		   and then returns  what was there before the write)
#	       Text is only required for write command.		 
#	examples:    
#		$present_version = DoStringsRes('/usr/lpp/lotus/notes/5010/os390/res/C/strings.res', '0001','read');
#		$present_version = DoStringsRes('/usr/lpp/lotus/notes/5010/os390/res/C/strings.res', '1','write', 'Release  5010CF1 | November 5, 2002   ');
#		DoStringsRes('/usr/lpp/lotus/notes/5010/os390/res/C/strings.res', '1','write', 'Release 5010CF1 | November 5, 2002   ');
#--------------------------------------------------------------------------------
require 5.000;

package StringsRes;

CdPath::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(  DoStringsRes
);      

sub DoStringsRes{

local($fname, $ImsgID, $cmd, $newMsg) = @_ ;

my ($rtnMsgText, $cntm, $DBdataLen, $DBheaderLen, $DB_ID, $msgStartingAdd, $msgLenx, $msgLen, $startofmsg, $msgText);
#-----------------------------------
#fname, ImsgID, and cmd cannot be null
if (!defined $fname) { die "strings.res file not named "; } 
if (! -f $fname)  { die "Not a valid strings.res filename (unable to locate the file '$fname') "; } 
if (!defined $ImsgID) { die "string.res MsgID not set "; } 
if (!defined $cmd)  { die "strings.res Command not set"; } 
if (($cmd ne 'write') and ($cmd ne 'read')) { die "strings.res Command is invalid. Must be read or write"; } 
if ((!defined $newMsg) and ($cmd eq 'write')) { die "strings.res write message text not set"; }
#-----------------------------------



if ($cmd eq 'write') {
	if ($ENV{'NUI_ARCH'} eq 'os390')  {   # os390 is EBCDIC platform. Strings.res is Ascii unicode.
		$NewString_A = `echo '$newMsg' | iconv -f IBM-1047 -t ISO8859-1 `;
		chop $NewString_A;  # remove the newline 
		$newMsg = $NewString_A;
	}
	# concatenate a null to the ascii character to represent unicode	
	$knull = (pack "H2","00");   #make a null character
	$NewStringLen = length $newMsg;
	$newMsgText = '';
	for ($i=0; $i< $NewStringLen; $i++) {
	        $newMsgText = $newMsgText . (substr($newMsg,$i,1)) . $knull;
	}
}


#From the requested msg ID, build the search datablock(DB) ID string and Msg Id string 
my $MsgDBIdHeader = pack("H12", "ffff0600ffff");   #first 6 bytes of the DB ID
my $msgDBIdx = (($ImsgID >> 4) + 1);  		   #DB Id drops the right most nibble (that is the msg ID)
my $MsgDBIdy = pack("I1",$msgDBIdx);  		   #convert it to hex (makes it 4 bytes)
my $MsgDBId;
if ( ($ENV{'NUI_ARCH'}  =~ /linux/ )  && ($ENV{'DEVENV'} ne 'zlinux') && ($ENV{'DEVENV'} ne 'zlinux64') )   {
	$MsgDBId = substr($MsgDBIdy,0,2);
}
else{
	$MsgDBId = substr($MsgDBIdy,3,1) . substr($MsgDBIdy,2,1);  #Reverse the order of the bytes
} 
my $Search4DBId = $MsgDBIdHeader . $MsgDBId;       #complete DB Id search string
my $MsgId;
if ($ENV{LP_REPLACE}) {
    $MsgId   = $ImsgID;
}
else {
    $MsgId   = ($ImsgID % 16);
}
#my $MsgId   = ($ImsgID % 16);                      #the msg Id is the right most nibble of requested ID
my $msgLenFldLen = 2;                              #Length of the message Length Field 


open (KINPUT, "<$fname") or die "Can't open $fname:$!";

my $ksignShouldBe; 
#First read 8 bytes of strings.res header which is the signature
 
if ((($ENV{'NUI_ARCH'} eq "linux") || ($ENV{'NUI_ARCH'} eq "linux64")) && (! defined $ENV{'LINUX_PACKH16'} ))  {
#if ($ENV{'NUI_ARCH'} eq 'linux') {
    if ($ENV{LP_REPLACE} == 1) {
	$ksignShouldBe = pack "H16","0000000020000000";
    }
    else {    
	$ksignShouldBe = pack "H16","0000000000200000";
    }
}
else{
     $ksignShouldBe = pack "H16","0000000020000000";
}

my $hmread = read KINPUT, $ksign, 8 ;
if ($hmread < 8) {
	die "Problem reading first 8 bytes from the strings.res file.\n";
}

#Is it a valid strings.res fie ?
if ( $ksign ne $ksignShouldBe) {
	die "$fname is not a strings.res file OR is it corrupted.";
}

#Find the correct datablock
#This code treats the first 16bytes as a DB header
my $cnt = -1;  # cnt is the datablock (DB) counter. -1 So that the first datablock will look like datablock 0 
my $DBStartingAdd = 0;
$msgText = "";
FOUND_LABEL: while (<KINPUT>) {
	$cnt++;  #DB counter
	#Now move to the beginning of the datablock
	seek KINPUT, $DBStartingAdd, 0;

	#Read the datablock header
	$hmread = read KINPUT, $DBheader, 16;   #reads 16 bytes
	if ($hmread < 16) {
		die "Problem reading the datablock header from the strings.res file.\n";
	}
	
	if ((($ENV{'NUI_ARCH'} eq "linux") || ($ENV{'NUI_ARCH'} eq "linux64")) && ($cnt == 0) && (! defined $ENV{'LINUX_PACKH16'} ) ) { 
	    if ($ENV{LP_REPLACE} == 1) {
		$DBdataLen = unpack("v4", substr($DBheader,0,4));   #Reverse byte order (little endian) 
		$DBheaderLen = unpack("v4", substr($DBheader,4,4)); #Reverse byte order (little endian)		
	    }
	    else {
		$DBdataLen = unpack("n4",substr($DBheader,0,4));
		$DBheaderLen = unpack("n4", substr($DBheader,4,4));
	    }
	
	}
	else{
		$DBdataLen = unpack("v4", substr($DBheader,0,4));   #Reverse byte order (little endian) 
		$DBheaderLen = unpack("v4", substr($DBheader,4,4)); #Reverse byte order (little endian)
	}

	$DB_ID = substr($DBheader,8,8);

	#if this is the correct datablock  
	if ($DB_ID eq $Search4DBId) {
		#Found the datablock, now ....
		# Find the msgid in this datablock

		$cntm= -1;  # cntm is the msgID within the data block. -1 so that the first message will be msg "0"
		$msgStartingAdd = $DBStartingAdd + $DBheaderLen;  #start of the message field  

		while (<KINPUT>) {
			$cntm++;

			#Now move to the beginning of the message data in the DB
			seek KINPUT, $msgStartingAdd, 0;  

			#Read the msg length for this message
			$hmread = read KINPUT, $msgLenx, $msgLenFldLen;

			$msgLen = unpack("v2", $msgLenx);  #Reverse byte order (little indian)

			if ($cntm eq $MsgId) {     #is this the correct MsgID we are looking for ?
				#Found the message ID, now ...
				# Get the message

				$startofmsg = $msgStartingAdd + $msgLenFldLen;  #start of message data

			 	# get msg Text 	
				seek KINPUT, $startofmsg, 0;
				$hmread = read KINPUT,$msgText,($msgLen *2 );  # Do not forget unicode is 2x
				#Remove the null character of the unicode (just get the first byte)
				$rtnLen = length $msgText;
				$rtnMsgText = '';
				$i = 0;
				while ($i < $rtnLen) {
        				$rtnMsgText = $rtnMsgText . (substr($msgText,$i,1));
					$i = $i + 2 ;
				}

				if ($ENV{'NUI_ARCH'} eq 'os390')  {   # os390 translate ascii back to EBCDIC 
					$rtnString_E = `echo '$rtnMsgText' | iconv -t IBM-1047 -f ISO8859-1 `;
					chop $rtnString_E;  # remove the newline caused by the echo 
					$rtnMsgText = $rtnString_E;
				}
				#$rtnMsgText is returned to caller of this routine to provide the old text 
    
				
				if ($cmd eq 'write') {
					# Save the original strings.res file 
					$currDir = `dirname $fname`;
					if ($currDir eq "") { $currDir = '.' } ; 
					chomp($currDir);
			#We are not doing this --`cp -p $fname $fname".orig1"`;

					# Build the new strings.res file  
					# - open a temp file to create a new strings.res file 
					$tmpOutFile = $currDir . '/' . tmp_strings.res ;
					open (KTMPOUT, ">$tmpOutFile") or die "Can't open temp file: $tmpOutFile:$!";
					# - grab everything from the beginning of the orig file upto the starting add of the msg
					seek KINPUT, 0, 0 ;  #starting from the beginning of the original file
					seek KTMPOUT, 0, 0 ; #starting the writing at the beginning of the new tmpfile
					$hmread = read KINPUT, $tmpdata, $msgStartingAdd ;
					syswrite KTMPOUT, $tmpdata, $msgStartingAdd; 
									
					# Add the new msg length  
					$newMsgTextLength = ((length $newMsgText) / 2);  #unicodes is 2bytes long
					$newMsgTextLenx = pack("I1",$newMsgTextLength);	 #convert to hex
					if ((($ENV{'NUI_ARCH'} eq "linux")  || ($ENV{'NUI_ARCH'} eq "linux64") )) {# &&  (! defined $ENV{'LINUX_PACKH16'} )  ) {
						$newMsgTextLen = substr($newMsgTextLenx,0,2);
					}
					else {
					$newMsgTextLen = substr($newMsgTextLenx,3,1) . substr($newMsgTextLenx,2,1);
					}
					syswrite KTMPOUT, $newMsgTextLen, $msgLenFldLen;	  
					
					# Update the datablock length to include the change in msg text 
					seek KTMPOUT,$DBStartingAdd,0;           #move to DBStarting Add
					$DBdataLen_not_OldMsgLen = ($DBdataLen - ($msgLen * 2));  #DB size without msg
					$newDBdataLength = ($DBdataLen_not_OldMsgLen + (length $newMsgText)); #new DB size
					$newDBdataLenx = pack("I1",$newDBdataLength);	 #convert to hex
					if (( $ENV{'NUI_ARCH'} eq  "linux") || ($ENV{'NUI_ARCH'} eq "linux64") ) {
				#	    && (! defined $ENV{'LINUX_PACKH16'}) )   {
					    $newDBdataLen =  $newDBdataLenx;
					}
					else{
						$newDBdataLen = substr($newDBdataLenx,3,1) . substr($newDBdataLenx,2,1) . substr($newDBdataLenx,1,1) . substr($newDBdataLenx,0,1);  #Reverse order of the bytes
					}
					syswrite KTMPOUT, $newDBdataLen, 4;	  

					# - insert the new msgText
					seek KTMPOUT, $startofmsg, 0;  
					syswrite KTMPOUT, $newMsgText, (length $newMsgText); 

					# - bring in the remaining msgs of the original datablock 
					$AddBeginNextMsg = $startofmsg + ($msgLen * 2);
					seek KINPUT, $AddBeginNextMsg, 0; 

					$AddEndDB = $DBStartingAdd + $DBheaderLen + $DBdataLen;
					$hmread = read KINPUT, $tmpdata, ($AddEndDB - $AddBeginNextMsg); 
					syswrite KTMPOUT, $tmpdata, (length $tmpdata); 

					# - get the rest of the data. The next DB is on a 4 byte boundary
					$NextRdAddPtr = tell KINPUT;     #where are we read from? 
					if (($NextRdAddPtr % 4) > 0) {    #Next DB is on a 4 byte boundary
						#add 4 then shift off the right 2 bits and shift back in 2 0 bits
						$NextRdAddPtr = ((($NextRdAddPtr +4) >> 2 ) << 2); 
					}
					$NextWrAddPtr = sysseek( KTMPOUT,0,1);    #where are we going to write ?
				#    if ($ENV{'NUI_ARCH'} eq 'linux'){
#					if ((($ENV{'NUI_ARCH'} eq 'linux') 
#					     && (! defined $ENV{''LINUX_PACKH16} ) )
#					     || ($ENV{'NUI_ARCH'} eq 'zlinux')   
#						 || ($ENV{'NUI_ARCH'} eq 'zlinux64')) {
#						 $NextWrAddPtr += (length($tmpdata) + length($newMsgText));
#				    }
					#Put it on a 4 byte boundary if not already there     
					if (($NextWrAddPtr % 4) > 0) {    #Next DB and the rest belongs on 4 byte 
						#add 4 then shift off the right 2 bits and shift back in 2 0 bits
						$NextWrAddPtr = ((($NextWrAddPtr +4) >> 2 ) << 2); 
					}
		
					# - get the size of the original stgrings.res
					$totalSize = (stat KINPUT)[7];
					# - grab everything after the original msgText
					seek KINPUT, $NextRdAddPtr, 0;
					$remainingDataLength = ($totalSize - $NextRdAddPtr);
					$hmread = read KINPUT, $tmpdata, $remainingDataLength;
					seek KTMPOUT, $NextWrAddPtr, 0;
					syswrite KTMPOUT, $tmpdata, (length $tmpdata); 
					if ( ! close(KTMPOUT)) {     
						die "Error closing temp strings.res file\n";
					}
					# - rename the new strings.res file
					`mv $tmpOutFile $fname`;
					`chmod 755 $fname`;
					`chown 0:0 $fname`;

					# That's all folks !
				}
				last FOUND_LABEL;
			}  	
			#go to next message
			$msgStartingAdd += $msgLenFldLen + ($msgLen *2 );     # msglen times 2 for unicode size

			#If we haven't found the message id within this datablock , there is a big problem !
			if ($msgStartingAdd >= ($DBStartingAdd + $DBdataLen)) {
				die "Could not find message id, $MsgId in Datablock, $msgDBIdx, in strings.res \n"; 
			} 
		}
		#We should never get here unless strings.res in built wrong !
		die "Could not find message id, $MsgId in Datablock, $MsgDBId, in strings.res \n"; 
	}		  
	#This is not the DB wer were looking for.
	#The starting address of the next msgdatablock ...
	$DBStartingAdd += $DBheaderLen + $DBdataLen;
	#The address of the next datablock must be on a 4 byte boundary so ..
	# check to see if it needs to be rounded up.
	if (( $DBStartingAdd % 4) > 0) {
		#Must round it up .... 
		#add 4 then shift off the right 2 bits and shift back in 2 0 bits
		$DBStartingAdd = ((($DBStartingAdd +4) >> 2 ) << 2); 
	}
}
if ( ! close(KINPUT)) {     
	die "Error closing strings.res file\n";
}

return $rtnMsgText;
}

sub GetShortVersion {
    #Fixpack - make revision from the version_string
    $rev = shift;

    $rev =~ s/\.//g;                    # remove dots
    $rev =~ s/\|.*$//;                  # strip off the date
    $rev =~ s/Release//;                # strip off Release
    $rev =~ s/Build//;                  # strip off Build
    $rev =~ s/V//;                      # strip off leading V
    $rev =~ s/NP//;                     # strip off trailing NP
    $rev=~ s/_CD\d_\d\d\d\d\d\d\d\d//;  # eliminate Code drop
    $rev =~ s/\s*//g;                   # remove whitespace
    $rev =~ s/\"//g;                    # remove doublequotes
 #   $rev =~ s/\s*$//;                  # remove trailing spaces 

    # get first char to check if this is a pre-V10 hotfix
    $first = (split //, $rev)[0];
    if ($first < 10 && $first> 7) {
		return GetShortVersionLegacy($rev); 
    }

	# exclude hotfixes from this logic
	if ($rev =~ /HF/i) {
		return $rev;
	}
   
	# exclude fixpacks from this logic
	if ($rev =~ /FP/i) {
		return $rev;
	}
   
    if (length($rev) == 3){             # catch for 100 like strings e.g. Release 10.0
        if ( $rev =~ /(\d{2})(\d)/ ){   # parse into aab
            $rev = $1.'0'.$2.'00';       # pad with 0s aa0b00 eg. 10000
        }
    }
    elsif (length($rev) == 4){             # catch for 1001 like strings e.g Release 10.0.1
        if ( $rev =~ /(\d{2})(\d)(\d)/ ){   # parse into aabc
            $rev = $1.'0'.$2.'0'.$3;       # pad with 0s aa0b00
        }    
    }
    elsif (length($rev) == 5){             # catch for 1001 like strings e.g Release 10.0.10
        if ( $rev =~ /(\d{2})(\d)(\d\d)/ ){   # parse into aabcc
            $rev = $1.'0'.$2.$3;       # pad with 0s aa0bcc eg. 100010
        }    
    }
	#pad end with 00 (place holder for dd in aabbccdd) for hotfix number
	# now have enough digits, do not pad further
	if (length($rev) >= 8) {
		return $rev;
	}
	else {
		return $rev.'00';
	}
}

sub GetShortVersionLegacy {
    #Fixpack - make revision from the version_string - this is pre d10, keeping in here "jic"
    $rev = shift;
    $rev =~ s/\.//g;        # remove dots
    $rev =~ s/\|.*$//;      # strip off the date
    $rev =~ s/Release//;
    $rev =~ s/Build//;
    $rev =~ s/V//;
    $rev =~ s/NP//;
    $rev=~ s/_CD\d_\d\d\d\d\d\d\d\d//; #eliminate Code drop
    $rev =~ s/\s*//g;       # remove white
    $rev =~ s/\"//g;
 #   $rev =~ s/\s*$//;
    if (length($rev) == 3){
	if ( $rev =~ /(\d{2})(\d)/ ){
	    $rev = $1.'0'.$2.'0';
	}
    }
    if (length($rev) == 4){
	$rev .= '0';			
    }
    if (length($rev) == 2){
	$rev .= '000';
    }
    if (length($rev) == 1){
	$rev .= '0000';
    }
    return $rev;
}

