# /unix/nui/installer/tools/lib/RmtNIC.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#

# globals to file
local($cmd) = shift(@ARGV);
local($nuiRoot) = "/tmp/lotus_nui";
local($ctxFile) = "$nuiRoot/ctx";
local($cdffile) = "$nuiRoot/sets/data/comp.cfg";
local($cdf);


push(@INC, "$nuiRoot/tools/lib", "$nuiRoot/tools/lib/perl5", "$nuiRoot/tools/nls");

eval 'require "CdPath.pl";';
eval 'require "CDPATH.PL";';
eval 'require "CDPATH.PL;1";';
CdPath::CdPathSetRoot($nuiRoot);

CdPath::Require("CfgData.pm");      import CfgData;
CdPath::Require("CDFFile.pm");      import CDFFile;
CdPath::Require("NIC.pm");          import NIC;
CdPath::Require("SysCmd.pl");


local($stat);

if ($cmd eq "ReceiveContext") {
	$stat = ReceiveContext();

} elsif ($cmd eq "GetContext") {
	$stat = system("cat $ctxFile") ? 0 : 1;

} else {

	$stat = 1;

	local($cfg) = new CfgData ();
	if ( ! $cfg->InitFromFile($ctxFile)) {
		print $cfg->GetErrorMessage();
		exit (1);
	}

	local($ctx) = $cfg->GetData();

	@reqcmds = qw(
	    mv rm mkdir env stty uname date hostname clear touch tar chown
	    chgrp cat chmod sh ln pwd ls find dirname basename cpio cp uname
	);

	if ( ! SysCmd::InitCmds(\@reqcmds, \@cmdsnotfound, \$errmsg, $ctx->{kitArch}))
	{
	    print "SysCmd init failure:\n$errmsg";
	    exit 1;
	}
	if ( $ctx->{kitArch} =~ /linux/ )  {
	    @reqcmds = qw(gunzip);
	    $uncompressCmd = "gunzip";
	} else {
	    @reqcmds = qw(uncompress);
	    $uncompressCmd = "uncompress";
	}
	if ( ! SysCmd::InitCmds(\@reqcmds, \@cmdsnotfound, \$errmsg, $ctx->{kitArch})) {
		print "SysCmd init failure:\n$errmsg";
		exit 1;
	}



	# load cdf component definition file
	$cdf = new CDFFile ();
	if ( ! $cdf->InitFromFile($cdffile)) {
		$tmp = $cdf->GetErrMsg();
		# diagnostic message - should never happen
		print "Fatal Error loading component definition file:\n$tmp\n";
		exit 1;
	}

	local($nic) = new NIC ($cdf);
	local($msg) = "";

	eval "\$stat = \$nic->${cmd}(\$ctx, \\\$msg)";
	print $msg;

	if ( ! WriteCtxFile($cfg->GenCfgFromHashRef($ctx))) {
		$stat = 0;
	}

}


exit ( ! $stat);

######################################################################


sub ReceiveContext {
	
	local($ctxString) = "";

	while (<STDIN>) {
		$ctxString .= $_;
	}

	return WriteCtxFile($ctxString);
}


sub WriteCtxFile {
	local($ctxString) = @_;

	local(*CTXFILE);

    if ( ! open(CTXFILE, ">$ctxFile")) {
		# diagnostic message - should never happen
        print "ReceiveContext failure:\n$!";
        return 0;
    }

	print CTXFILE $ctxString;

    if ( ! close(CTXFILE)) {
		# diagnostic message - should never happen
        print "ReceiveContext failure:\n$!";
        return 0;
    }

    return 1;
}

	
	
