# /unix/nui/installer/tools/lib/pathutil.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


package PathUtil;
require 5.000;
 
CdPath::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(   BaseName
				DirName
				CleanPath
				AppendLotus
);



#use File::Basename;

# DirName( $path )
# BaseName( $path )
# CleanPath( $path )


sub BaseName {
    local( $path ) = @_;
 
    local( @comps ) = split( '/', $path );
 
 
    ( ! $path ) && return('.');
 
    return( pop( @comps ) );
}
 
 
sub DirName {
    local( $path ) = @_;
 
    local( $pfx );
    local( @comps ) = split( '/', $path );
 
 
    pop( @comps );
    ( ! @comps ) && return('.');
 
    $_ = $path;
    /^\/[^\/]*$/ && ($pfx = '/');

	return( $pfx . join( '/', @comps ) );
}


 
sub CleanPath {
        local($_) = @_;
 
        s/^\s+//;                       # get rid of any space at beginning
        s/\s+$//;                       # or end of string
        $_ = "$_/";                     # make sure path ends with "/" (temp)
        s#//+#/#g;                      # get rid of multiple //+
        s#/\./#/#g while (m#/\./#);     # remove /./ paths
        s#^\./(\S+)$#$1#;               # remove an initial ./, unless that's
                                        # all there is
        s#/$## unless (m#^/$#);         # remove ending /, unless root path
 
        # we should also remove /../ paths - leave that for later
 
        return($_);
}



sub AppendLotus {
    local($string) = @_;

    local($dir)  = DirName( $string );
    local($base) = BaseName( $string );

    if ( $base =~ /^lotus$/i ) {
        $string = "$dir/lotus";
    } else {
        $string = "$dir/$base/lotus";
    }

    #!!!
    $string =~ s#//#/#;

    while ( $string =~ /^\.\// ) {
        $string =~ s/^\.\///;
    }
	
	if ( ! ($string =~ /^\//)) {
		$string = "/$string";
	}

    return $string;
}



#sub DirName {
#        local($origpath) = @_;
#        local($path);
# 
#        $path = &CleanPath($origpath);
#        return($path) if ($path =~ m#^/$#);
#        return(".")   if ($path !~ m#/#);
#        if ($path =~ m#^(\S+)/([^/\s]+)$#) {
#                return($1);
#        }
#        &Error_exit(1, "DirName: unrecognized filename: $origpath");
#}
# 
#sub BaseName {
#        local($origname) = @_;
#        local($name);
# 
#        $name = &CleanPath($origname);
#        if ($name =~ m#/([^/\s]+)$#) {
#                return($1);
#        }
#        if ($name !~ m#/#) {
#                return($name);
#        }
#        &Error_exit(1, "BaseName: unrecognized filename: $origname");
#}
#
#sub CleanPath {
#        local($_) = @_;
# 
#        s/^\s+//;                       # get rid of any space at beginning
#        s/\s+$//;                       # or end of string
#        $_ = "$_/";                     # make sure path ends with "/" (temp)
#        s#//+#/#g;                      # get rid of multiple //+
#        s#/\./#/#g while (m#/\./#);     # remove /./ paths
#        s#^\./(\S+)$#$1#;               # remove an initial ./, unless that's
#                                        # all there is
#        s#/$## unless (m#^/$#);         # remove ending /, unless root path
# 
#        # we should also remove /../ paths - leave that for later
# 
#        return($_);
#}


package main;
1;
