# /unix/nui/installer/tools/lib/NICIA.pl
#
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 2023, HCL Development Corporation.
## All Rights Reserved.

package NIC;

#									new ctx
# new								X
# InitContexts						X
# ValidateContext					X
# GetErrMsg							-
# PreInstallProcessing				X
# PostInstallProcessing				X
# Chdir								-			  
# SysCmd							-
# GetTimeStampString				-
# CreateSymLinks					-
# IsBatchMode						-
# GetCfgSummary						X
# GetComponentDestinationData		X



CdPath::Require("NIC.nls");      import NIC_nls;
CdPath::Require("PerlUtil.pl");  import PerlUtil;
CdPath::Require("InvUtil.pl");   import InvUtil; #added for hotfix processing
CdPath::Require("PathUtil.pl");  import PathUtil;
CdPath::Require("MiscUtil.pl");  import MiscUtil;
CdPath::Require("InvFile.pm");
CdPath::Require("StringsRes.pm"); import StringRes;
use File::Find;

sub new {
	local($class, $cdf, $scr) = @_;

	# just create the bare obj (except for cdf)
	# with field placeholders, and constants
	# no script or context data yet


	local($self) = {
		errmsg			=>	"",

		cdf				=>	$cdf,	# Component definitions obj
		scr				=>	$scr,	# script data (hash)

		batchMode		=>	"",		# true if not invoked via UI

		# constants
		archMnemMap		=>	{	sol     => sunspa,
								solx86  => sunx86,
								aix     => ibmpow,
							                   aix64 => ibmpow,
								hpux    => hppa,
								linux	=> linux,
							                   linux64     =>linux,
							        zlinux	=> zlinux,
								os390   => os390
							},
	       rename                  =>       "",
	};
	bless $self;


    $self->{batchMode} = $self->{scr}->{ui} ? 0 : 1;


	return $self;
}


sub InitContexts {
	local($self, $rCtxs, $nuicfgdat) = @_;

	local($_);
	local($ctx, $host, @hosts);
	local($scr) = $self->{scr};


	local(@hosts);
	if (@{$scr->{target_hosts}}) {
		@hosts = @{$scr->{target_hosts}};
	} else {
		@hosts = ("localhost");
	}

	@{$rCtxs} = ();



	foreach $host (@hosts) {
	    $ctx = {};
	    $ctx->{targetHost}	= $host;
	    if (!$ctx->{kitArch}) {
		$ctx->{kitArch} 	= $ENV{NUI_ARCH};
	    }
	    $ctx->{perl}		= $ENV{PERL};
	    $ctx->{nuicfg}		= $nuicfgdat;
	    if ($self->{batchMode}){
		$ctx->{installation_type}   = $scr->{installation_type};
	    }
	    $ctx->{installation_inotes} = $scr->{installation_inotes};
	    push(@{$rCtxs}, $ctx);
	}
	
	return 1;
	
}


sub ValidateContext {
	local($self, $ctx, $rMsg) = @_;

	# gather info about local

	local($_, $out, $stat);
	local($tmp, @tmp);
	local($ddir, @ddirs);
	local($ret) = 1;
	#added to handle hotfixes
	local $valid_version = 1;
	local (%valid_checksums, %base_checksums, %target_checksums);
	local $fname;
	
	local $bckupdir, %backup, @fixlist, %current_fixes;
	#

	$$rMsg = "";

	local($evalstart, $evalline);
	$self->{errmsg} = "";
	$evalstart = __LINE__; ++$evalstart;
	eval <<'EndOfEval';
	
	#changed to handle hotfix install
	    
	if ( ! -f "$ENV{NUI_CFGFILE}" ) {
	    $$rMsg .= $txt{7};
	    $ret = 0;
	    return;
	}
	
	local($prevctxcfg, $prevctx);
	$prevctxcfg = new CfgData ();
	if ( ! $prevctxcfg->InitFromFile("$ENV{NUI_CFGFILE}")) {
	    fix_nui_cfg($ENV{NUI_CFGFILE});
	    undef $prevctxcfg;
	    $prevctxcfg = CfgData->new();
	    if ( !$prevctxcfg->InitFromFile($ENV{NUI_CFGFILE})) {   
		# diagnostic msg; should not happen
		$$rMsg .= "Corrupted installation data in $ENV{NUI_CFGFILE}.\n";
		$$rMsg .= $prevctxcfg->GetErrorMessage();
		$ret = 0;
		return;
	    }
	}
	$prevctx = $prevctxcfg->GetData();
	undef $prevctxcfg;
	
	$ctx->{ptSize} = 0;
	$ctx->{ptSizeReclaim} = 0;		    
	
	
	# copy cfg data common to all revs		
	foreach (
		 qw(installation_type ptPath program_directory template_install_option asp_install_option opt_lotus_softlink add_data_directories_only start_server_setup kitArch)
		 ) {
	    if (defined ($prevctx->{$_})){
		$ctx->{$_} = $prevctx->{$_};
	    }
	}
	foreach $key (keys %{$prevctx->{backup}}) {
	    $backup{$key} = ${$prevctx->{backup}}{$key};	
	}
    $ctx->{add_data_directories_only}=0;

	if (!(defined $strings_file)){
	    $ctx->{pPath} =
		"$ctx->{ptPath}/notes/latest/$self->{archMnemMap}->{$ctx->{kitArch}}";	    
                     #some previous hotfixes left over strings.res in the program directory that could lead to subsequent errors id all resources are moved to $langpath
                      # blow code removed leftover strings.res if it exists
	    $leftover_strings = $ctx->{pPath} ."/strings.res";   
	    if ( -f $leftover_strings ) {
		$self->SysCmd("$Sys::rm -f  $leftover_strings") ;
	    }

	    &FindStrings();
	    if (!defined $strings_file){
		print "Couldn't find strings.res in $ctx->{ptPath} - will attempt to use default\n" ;
		
		$strings_file = $ctx->{pPath} ."/res/C/strings.res";	
		}
	}
	my @revlist = @{$prevctx->{nuicfg}->{fix_rev}};
	push (@revlist, $prevctx->{nuicfg}->{rev});	    
	my $frev; 
	
	foreach $frev (@revlist) {
	    if (defined  $prevctx->{$frev}){
		$ctx->{$frev} = $prevctx->{$frev};
	    }
	    
	}
if (! (defined ($ctx->{nuicfg}->{nsdfix}) )  &&  !(defined ($ctx->{nuicfg}->{saasfix}) ) &&  !(defined ($ctx->{nuicfg}->{customfix}) )  )  {  
        if (!$self->IsBatchMode()) {
	    
	    # read from script written by UI
#	    $ctx->{installation_type} = $self->{scr}->{installType};
	    $ctx->{installation_inotes} = $self->{scr}->{installation_inotes};		
	    # added to handle hotfixes
	    #ctx->{version_string} is the base release version string
	    if (defined($ctx->{nuicfg}->{base_stringsres})  ) {
		$ctx->{version_string} = $ctx->{nuicfg}->{base_stringsres};		
	    }
	    elsif (defined($prevctx->{version_string})){
		#version_string is the "official" version from the strings.res,
		#corresponding to the base release
		$ctx->{version_string} = $prevctx->{version_string};
	    }
	    else{
		
		@resInput = ($strings_file,'1','read');			
		$ctx->{version_string} = StringsRes::DoStringsRes(@resInput);
		
	    }
	    # after 602CF2 change:
	    @resInput = ($strings_file,'1','read');
	    $prev = StringsRes::DoStringsRes(@resInput);
	    $previous_revision = StringsRes::GetShortVersion($prev); 
	    
	    
	    $ctx->{base_version} = $previous_revision; #maybe previous fixpack, do not change its string if already defined
	    if (defined ($ctx->{nuicfg}->{base_stringsres}) ) {
		if (!defined $ctx->{base_version}->{version_string}) {
		    $ctx->{base_version}->{version_string} = $ctx->{nuicfg}->{base_stringsres};
		}
	    }
	    elsif (defined ($prevctx->{version_string}) ){
		if (!defined $ctx->{base_version}->{version_string}) {
		    $ctx->{base_version}->{version_string} = $prevctx->{version_string};
		}
	    }
	    
	    $ctx->{target_version} = $self->{scr}->{target_version};
	    #fix_stringres is the "official" version which will appear in the strings.res
	    if  ($self->{scr}->{fix_type} eq 'upgrade') {
		$ctx->{$ctx->{target_version}}->{version_string}  = $ctx->{nuicfg}->{fix_stringsres};
		my $rt = SaveLPParms();
		if ($rt == 1) {
		    $$rMsg .= "Can't save $ENV{NUI_CFGFILE} to $backupdir";
		}
		UpdateLParameters();
	    }						
	    else{
		local $vs = $prevctx->{$ctx->{base_version}}->{version_string};
		local $bv = $ctx->{base_version};
		# print "revert: base version $bv version string $vs\n";
		if (defined ($ctx->{nuicfg}->{base_stringsres} ) ) {
		    if (!defined $ctx->{base_version}->{version_string}) {
			$ctx->{$ctx->{base_version}}->{version_string} = $ctx->{nuicfg}->{base_stringsres};
		    }
		}
		else {
		    if (!defined $ctx->{base_version}->{version_string}) {
			$ctx->{$ctx->{base_version}}->{version_string} = $prevctx->{$ctx->{base_version}}->{version_string};       
		    }
		}
		if (!defined $vs){
		    if (defined $prevctx->{version_string}){
			if (!defined $prevctx->{$ctx->{target_version}}->{version_string} ) {
			    $prevctx->{$ctx->{target_version}}->{version_string} =$prevctx->{version_string};
			}
		    }
		}
		$vs = $prevctx->{$ctx->{target_version}}->{version_string};
		$ctx->{version_string} = $vs;
		local $tv =  $ctx->{target_version};
		my $rt = RestoreLPParameters();
		if ($rt == 1) {
		    $$rMsg .= "No backup found for .install.dat";
		}
		if ($rt == 2) {
		    $$rMsg .= "The original .install.dat had disappeared.";
		}
		if ($rt == 3) {
		    $$rMsg .= " Can't initialize from $backup_install_dat";
		}
	    }
	    
	    $ctx->{rev} = $ctx->{target_version};
	    $ctx->{fix_type} = $self->{scr}->{fix_type};
	}
        # added to handle hotfixes in the batch mode
        else {
	    @fixlist = @{$ctx->{nuicfg}->{fix_rev}};
	    local $rev;
	    #after 602CF2 change: take base_rev from strings.res
	    @resInput = ($strings_file,'1','read');
	    $prev = StringsRes::DoStringsRes(@resInput);
	    $previous_revision = StringsRes::GetShortVersion($prev);
	     # added to handle hotfixes
	    #ctx->{version_string} is the base release version string
	    if (defined ($ctx->{nuicfg}->{base_stringsres} )) {
		$ctx->{version_string} = $ctx->{nuicfg}->{base_stringsres};
	    }
	    elsif (defined($prevctx->{version_string})){
		#version_string is the "official" version from the strings.res,
		#corresponding to the base release
		$ctx->{version_string} = $prevctx->{version_string};
	    }
	    else{
		
		@resInput = ($strings_file,'1','read');			
		$ctx->{version_string} = StringsRes::DoStringsRes(@resInput);		
	    }
	    
	    $ctx->{base_version} = $previous_revision;
                       if (defined ($ctx->{nuicfg}->{base_stringsres} )) {
		$ctx->{version_string} = $ctx->{nuicfg}->{base_stringsres};
		$ctx->{base_version}->{version_string} = $ctx->{base_stringsres};
	    }
	    elsif (defined ($prevctx->{version_string}) ){
		$ctx->{version_string} = $prevctx->{version_string};
		$ctx->{base_version}->{version_string} = $prevctx->{version_string};
	    }
	    elsif (defined($prevctx->{$ctx->{nuicfg}->{rev}}->{version_string}) ){
		$ctx->{version_string} = $prevctx->{$ctx->{nuicfg}->{rev}}->{version_string};
	    }
	    
	    $ctx->{target_version} = pop(@fixlist);
	 #   if ($previous_revision eq $ctx->{nuicfg}->{rev}){    
	    if ($previous_revision ne  $ctx->{target_version} )  {	
	#	foreach $rev (@fixlist) {
	#	    if ($previous_revision eq $rev){		
			$ctx->{fix_type} = 'upgrade';
			$ctx->{rev} = $ctx->{target_version};
			#fix_stringres is the "official" version which will appear in the strings.res
			$ctx->{$ctx->{target_version}}->{version_string} = $ctx->{nuicfg}->{fix_stringsres};
			my $rt = SaveLPParms();
			if ($rt == 1) {
			    $$rMsg .= "Can't save $ENV{NUI_CFGFILE} to $backupdir";
			}
			UpdateLParameters();
	#	    }
	#	}
	    }
	   else {
		#	foreach $rev (@fixlist){
		#	    if ($previous_revision eq $rev){
		$ctx->{base_version} = $prevctx->{rev};
		$ctx->{target_version} =  $ctx->{nuicfg}->{rev};
		$ctx->{fix_type} = 'revert';
		$ctx->{rev} = $ctx->{nuicfg}->{rev};
		if( !defined($ctx->{nuicfg} ) ) {
		    $ctx->{nuicfg} = $prevctx->{nuicfg};
		}	    				
		    
	#	}
		if (defined ($ctx->{nuicfg}->{base_stringsres}) ) {
		    $ctx->{version_string} = $ctx->{nuicfg}->{base_stringsres};
		}
		elsif (defined($prevctx->{version_string})){
		    $ctx->{version_string} = $prevctx->{version_string};
		}
		elsif (defined($prevctx->{$ctx->{nuicfg}->{rev}}->{version_string}) ){
		    $ctx->{version_string} = $prevctx->{$ctx->{nuicfg}->{rev}}->{version_string};
		}
		else{
		    @resInput = ($strings_file,'1','read');
		    $ctx->{version_string} = StringsRes::DoStringsRes(@resInput);
		}
		# language pack additions
		my $rt = RestoreLPParameters();
		if ($rt == 1) {
		    $$rMsg .= "No backup found for .install.dat";
		}
		if ($rt == 2) {
		    $$rMsg .= "The original .install.dat had disappeared.";
		}
		if ($rt == 3) {
		    $$rMsg .= " Can't initialize from $backup_install_dat";
		}
		RestoreLPParameters();	
	    }	    				
	    # print the corresponding message if revision didn't match
	    if ( (!defined($ctx->{base_version})) || (!defined($ctx->{target_version}))  ){
		$$rMsg .= "$txt{9}". $prevctx->{rev}."\n";
		    die;
	    }
	    $ctx->{rev} = $ctx->{target_version};
	    #$ctx->{fix_type} = $self->{scr}->{fix_type};
	}
		      
    }#end of if !defined nsdfix && customfix && saasfix
    else { 
#define here what needs to be defined in the .install.dat from the previous one
	foreach (keys %prevctx) {
	     if (defined ($prevctx->{$_})){
		$ctx->{$_} = $prevctx->{$_};
	    }
	}
	$ctx->{base_version} = $ctx->{nuicfg}->{rev};
	@fixlist = @{$ctx->{nuicfg}->{fix_rev}};
	$ctx->{target_version} = pop(@fixlist);
	if (!defined $ctx->{rev}) {
	    $ctx->{rev} = $ctx->{base_version};
	}
    }
        #
        # if it's batch mode - check if it's already defined in InitContexts from script.dat
        if (!defined ($ctx->{installation_type})){
	    if ( !defined ($prevctx->{installation_type}) ) {
		$ctx->{installation_type} = 3;
	    }
	    else {
		$ctx->{installation_type} = $prevctx->{installation_type};
	    }
	}
	    
        # check if it's already defined in InitContexts from script.dat
	    
        if (!defined ($ctx->{installation_inotes})){
	    #corrected (was $ctx->{installation_type})
	    if (defined $prevctx->{installation_inotes} ) {
		$ctx->{installation_inotes} = $prevctx->{installation_inotes};
	    }
	}
        # copy rev-specific cfg data
        #
	    
        $ctx->{data_directories} = CopyData($prevctx->{data_directories});
        @ddirs = sort(keys(%{$ctx->{data_directories}}));
        foreach $ddir (@ddirs){
	    $ctx->{ddir_data}->{$ddir}->{sizeReclaim} = 0;	
	}
	    
	    
$ctx->{pPath} =
		"$ctx->{ptPath}/notes/latest/$self->{archMnemMap}->{$ctx->{kitArch}}";

# set components
# !!! custom
#
#local($allSetupTypes) = $self->{cdf}->GetSetupTypeList();
#local($ctxSetupTypeName) = $allSetupTypes->[$ctx->{installation_type}];
#local($tmp) =
#    $self->{cdf}->GetSetupTypeComponentList($ctxSetupTypeName);
#local($tmp2) = $self->{cdf}->GetCustomOnlyComponentList();
#@{$ctx->{components}} = (@{$tmp}, @{$tmp2});	
@{$ctx->{components}} = @{$self->{cdf}->{data}->{_KeyList_}};

#
# cfg summary msg's for batch mode
#
# doing it here cause this is the first place we know,
# at least for incr kitType
#
if ($self->IsBatchMode()) {
    $$rMsg .= $self->GetCfgSummary($ctx);
}

#
# validate data dir names
#
@ddirs = sort(keys(%{$ctx->{data_directories}}));
if ( ! scalar(@ddirs)) {
    $$rMsg .= "$txt{8}";
    $ret = 0;
    return;
}
foreach $ddir (@ddirs) {
    if ( (! $ddir) || ( ! ($ddir =~ /^\//)) ) {
	$$rMsg .= "$txt{8}";
	$ret = 0;
	return;
    }
}


#
# validate and set data_UNIX_uid
#
local($user);
@ddirs = sort(keys(%{$ctx->{data_directories}}));
foreach $ddir (@ddirs) {
    $user = $ctx->{data_directories}->{$ddir}->{data_UNIX_user};
    @tmp = getpwnam($user);
    if (! @tmp) {
	$$rMsg .= "$tst{err}$txt{1.1}${user}$txt{1.2}";
	$ret = 0;
	return;
    }
    $ctx->{data_directories}->{$ddir}->{data_UNIX_uid} = $tmp[2];
}


#
	    # validate and set data_UNIX_gid
#
local($group);
@ddirs = sort(keys(%{$ctx->{data_directories}}));
foreach $ddir (@ddirs) {
    $group = $ctx->{data_directories}->{$ddir}->{data_UNIX_group};
    @tmp = getgrnam($group);
    if (! @tmp) {
	$$rMsg .= "$txt{err}$txt{1.1}${group}$txt{1.3}";
		    $ret = 0;
	return;
    }
		$ctx->{data_directories}->{$ddir}->{data_UNIX_gid} = $tmp[2];
}


            #
	    #
	    # check existing product tree
	    #
	    $_ = $ctx->{ptPath};
	    if (-d $_) {
		$self->Chdir($_) || die;
		$self->SysCmd("$Sys::pwd", \$out) || die;
		chomp($out);
		$ctx->{ptPath} = $out;
		
		# see what's there
		$self->SysCmd("$Sys::ls .notes????.dat", \$out, \$stat);
		if ( ! $stat) {
		    ($ctx->{ptPathExistRev}) = ($out =~ /([\d]*)[^\d]*$/);
		} else {
		    $self->SysCmd("$Sys::ls notes", \$out, \$stat);
		    if ( ! $stat) {
			($ctx->{ptPathExistRev}) = ($out =~ /([\d]*)[^\d]*$/);
		    }
		}
	    }
	    
	    
	    #
	    # check os patches
	    #
	    if ($ctx->{kitArch} eq "linux") {
		$$rMsg .= "Not checking patches for linux.\n\n";
	    }elsif ($ctx->{kitArch} eq "os390") {           
		#$$rMsg .= "Not checking patches for os390.\n\n";
	    } else {
		local($cmd) = 
		    "$ctx->{perl} " .
		      CdPath::CdPathShellString("tools/lib/checkos.pl") .
			  " -q -f " .
			CdPath::CdPathShellString("tools/nls/checkos.dat");
		$$rMsg .= `$cmd 2>&1`;
	    }
	    #   added to handle hotfixes
	    #
	    #   fix information 
	    # 
	   
	    @fixlist = @{$ctx->{nuicfg}->{fix_rev}};	
	    local $target_rev = pop(@fixlist);
	    local $filename;
                      if (defined ($ctx->{nuicfg}->{$ctx->{base_version}} ) )  {
			  foreach $filename (keys %{$ctx->{nuicfg}->{$ctx->{base_version}}}){
			      if (defined $ctx->{nuicfg}->{$ctx->{base_version}}->{$filename}->{checksum} ) {
				  $base_checksums{$filename} = 
				      $ctx->{nuicfg}->{$ctx->{base_version}}->{$filename}->{checksum};
				  $valid_checksums{$filename} = 1;
			      }
			  }
			       
	   }
                    if (defined ($ctx->{nuicfg}->{$ctx->{target_version}} ) ) {	
			foreach $filename (keys %{$ctx->{nuicfg}->{$ctx->{target_version}}}){
			    if (defined $ctx->{nuicfg}->{$ctx->{target_version}}->{$filename}->{checksum} ) {
				$target_checksums{$filename} = 
				    $ctx->{nuicfg}->{$ctx->{target_version}}->{$filename}->{checksum};
			    }
			}			   
		    }
                     if (defined ($ctx->{nuicfg}->{nsdfix}) ||  defined ($ctx->{nuicfg}->{saasfix})  ||  defined ($ctx->{nuicfg}->{customfix}) )   {  
                      # for nsd fix we must figure out if that's upgrade or revert by comparing checksums:
                      # if what's installed has base checksum: it's upgrade, if target - it's revert
			 foreach $fname (keys %base_checksums) {
			      if ($fname =~ /no_file/) {
				 ($fname1 = $fname) =~ s/<NOTESPROGDIR>no_file//;
				 $fname =~ s/no_file//;
			     }
			     else {
				 ($fname1 = $fname) =~ s/<NOTESPROGDIR>//;	  
			     }
			     $nsdpath = $ctx->{pPath}.'/'.$fname1;
			     $curr_nsdchecksum = GetChecksum($err_msg, $nsdpath);
			     if ($curr_nsdchecksum  == $target_checksums{$fname} ) {
				 $ctx->{fix_type} =  'revert';
			     }
			     else {
				 $ctx->{fix_type} = 'upgrade';
			     }
			     last;
			 }
		     }
	    # collect size data
	    #
	    local($comp, $ddir, $dest, $inv, $invfile, $compstring);
	    local($file, $files);
	    local($fgmapfile, $fgmapcfg, $fgmap, $fname1);
	    #
	    # first load the filegroup mnemonics map file
	    #
	    $fgmapfile = CdPath::CdPath("sets/data/fg.dat");
	    $fgmapcfg = new CfgData ();
	    if ( ! $fgmapcfg->InitFromFile($fgmapfile)) {
		$$rMsg .= $fgmapcfg->GetErrorMessage();
		die;
	    }
	    $fgmap = $fgmapcfg->GetData();
	    undef $fgmapcfg;
	    
	    foreach $comp (@{$ctx->{components}}) {
		
		# load the inv file for this component
		#
		# presuming component to filegroup 1:1
		$compstring = $comp;
		$compstring =~ s| ||g;
		$compstring =~ s|\\||g;
		$compstring =~ s|\(||g;
		$compstring =~ s|\)||g;
		
		if ($fgmap->{$compstring} eq "no_files" || $fgmap->{$compstring} eq "") {
		    next;
		}
		
		$invfile = "sets/data/fginv/" . $fgmap->{$compstring};
		$invfile = CdPath::CdPath("$invfile");
		$inv = new InvFile ();
		if ( ! $inv->InitFromFile($invfile)) {
		    $$rMsg .= $inv->GetErrMsg();
		    die;
		}

		if ($self->IsTargetDataDir($comp)) {
		    @ddirs = sort(keys(%{$ctx->{data_directories}}));
			my $dir_num = 0;
			foreach $ddir (@ddirs) {
			    $dir_num += 1;
			    $dest = $self->ExpandTarget($comp, $ddir);
			    $files = $inv->GetFileList();
			    if (-d $dest) {
				chdir($dest) || die;
				foreach $file (@{$files}) {
				    if (-f $file) {						    			
					# added to handle hotfixes
					# check if the checksums of the fix files 
					# correspond to the base revision
					foreach $fname (keys %base_checksums){
					    #skip non-data files
					    next unless $fname =~ /<NOTESDATADIR>/;
					    ($fname1 = $fname) =~ s/<NOTESDATADIR>//;
					    #        $valid_checksums{$fname} = 1;
					    if (($file eq $fname1) || ($fname1 eq "no_file".$file) ) {
						local ($filepath, $fix_version);
						foreach $fix_version (@fixlist, $ctx->{base_version},
								      $ctx->{nuicfg}->{rev},
								      $ctx->{target_version}){
						    my $bck_dest = '';
						    ($bck_dest = $dest) =~ s/[^A-Za-z0-9]//g;
						    
						    $bckupdir{$fix_version} = 
							# $dest ."/".	$fix_version;
							$ctx->{pPath}."/data".$dir_num."_bck/".$fix_version;
						    $filepath = $dest."/".$file;
						    $backup{$filepath}->{$fix_version} = 
							$bckupdir{$fix_version}."/".$bck_dest;
						}
						
						if ($ctx->{fix_type} eq 'upgrade'){
						    $correct_checksum = $base_checksums{$fname};
						}
						else {
					#	    if (! -d $bckupdir{$ctx->{target_version}}){
					#		$$rMsg .= "$txt{7.3} $ctx->{target_version} $txt{7.4}";
					#		$ret = 0;
					#		return;
					#	    }
						    my $hit = 0;
						if (! -d $bckupdir{$ctx->{target_version}}) {
						    $correct_checksum = 0;
						    $hit = 1;
						}						    
						    $filepath = $bckupdir{$ctx->{target_version}}."/".
							$file; 
						    if ($hit == 0)
						    {
							$correct_checksum = $target_checksums{$fname};
						    }
						}
						@sb = stat($filepath);
						$fgroup{$filepath} = $sb[5];
						$fuid{$filepath} = $sb[4];
						$fmode{$filepath} = $sb[2] & 07777;
						$curr_checksum = 
						    GetChecksum ($err_msg,
								 $filepath);
						# print "File $filepath; curr_checksum = $curr_checksum\n correct_checksum = $correct_checksum\n";
						if ($curr_checksum == 
						    $correct_checksum){
						    $valid_checksums{$fname} = 1;
						}
						else{#exception for CF1 needs work!
							 if (($fname !~ /n[ts]f$/) &&
							     ($fname !~ /libndgts/) &&
							     ($fname !~ /nsd.sh/) && 
							    ($fname !~ /libigif/)  )
							 {
							     if ($ctx->{fix_type} eq 'upgrade'){
								 $valid_checksums{$fname} = 0;
								 $valid_version = 0;
								 next;
							     }
							     my $filep = $dest."/".$file;
							     local $retBckup = FindBackup($filep);
							     local ($found_bckup, $fn) = @{$retBckup};
							     if (!$found_bckup){
								 $valid_checksums{$fname} = 0;
								 $valid_version = 0;
								 # print "Revert valid_version = 0\n";
							     }
							 }
						     }
					    }
					}
					
				    }
				    if ($ctx->{fix_type} eq 'upgrade'){
					$ctx->{ddir_data}->{$ddir}->{size} +=
					    ($inv->GetFileSize($file)*2);
					
				    }
				}
			    } else {
				    if ($ctx->{fix_type} eq 'upgrade'){
					foreach $file (@{$files}) {
					    $ctx->{ddir_data}->{$ddir}->{size} +=
						($inv->GetFileSize($file)*2);					    
					}
				    }
				}
			}

		} else {
		    $files = $inv->GetFileList();

		    if ($ctx->{ptPathExistRev}) {
			$dest = $self->ExpandTargetByRev($comp, $ctx->{ptPathExistRev});
			if (-d $dest) {
			    chdir($dest) || die;
			    foreach $file (@{$files}) {
				if (-d $dest) {
					chdir($dest) || die;
				}
				if ($file =~ /\.res$/){
				    local($langpath);
				    if (
					(! $ENV{'LANG'}) ||
					($ENV{'LANG'} =~ /^posix$/i) ||
					($ENV{'LANG'} =~ /^en_us/i) ||
					($ENV{'LANG'} =~ /^en_GB/i)
					) {
					$langpath = "res/C";
				    } else {
					$langpath = "res/$ENV{'LANG'}";
				    }
				    chdir($langpath) || die;						
				}
				else{
#	#		    chdir($dest) || die;
				}
				if ($ctx->{kitArch} eq "os390") {  
# file startup.sh  on os390  is shipped and will be installed and backed up as "startup"
# in the end of the installation it's renamed to startup.sh
# here the reverse operation takes place :1) rename; 2) install 3) rename again
# this will allow for uninstall 
				    if ($file =~ /startup$/)  {			
					if (-f  "$ctx->{pPath}/startup.sh") {
					    if (-f  "$ctx->{pPath}/startup") {
						$self->SysCmd("$Sys::rm -f $ctx->{pPath}/startup")  || die;
					    }
					    $self->SysCmd("$Sys::mv  $ctx->{pPath}/startup.sh $ctx->{pPath}/startup") || die;
					}							    
				    }
				}
# file senddiag_svr  on linux  is shipped and will be installed and backed up as "senddiag_svr"
# in the end of the installation it's renamed to senddiag
# here the reverse operation takes place :1) rename; 2) install 3) rename again
# this will allow for uninstall 
				if ( $file =~  /senddiag_svr/ ){
				    if ($ctx->{kitArch} =~ /inux/) {
					if ( -f "$ctx->{pPath}/senddiag") {
					    if (-f  "$ctx->{pPath}/senddiag_svr") {
						$self->SysCmd("$Sys::rm $ctx->{pPath}/senddiag_svr") || die;	
					    }				    
					   $self->SysCmd("$Sys::mv  $ctx->{pPath}/senddiag $ctx->{pPath}/senddiag_svr");
						
					    }
					}				    
				}
#same operation with timestamped files
				$file_prev ="";
				$filetmp = "";
				if ( $file =~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d(.*)jar/) {
				    $tmstmp = qw(\\d\\d\\d\\d\\d\\d\\d\\d\(-|_\)\\d\\d\\d\\d); 
				    ($filetmp = $file) =~ s/(.*)\d\d\d\d\d\d\d\d(-|_)\d\d\d\d(.*)jar/$1\.jar/;
				    $file_regexp = $1."\\d\\d\\d\\d\\d\\d\\d\\d(-|_)\\d\\d\\d\\d".$3."jar";
				    $file_prev = GetExisting($dest,$file_regexp );
				    if ($file_prev ne $file ) {
				    
					if ( -f $file ) {					
					    $self->SysCmd("$Sys::rm $file") || die;
					}
					$self->SysCmd("$Sys::mv $file_prev  $file"); #renamed old file to a new name
				    }
				    $rename{$file} = $file_prev;
				}
			
				if ( -f $file  ) {				    
				    # added to handle hotfixes
				    # check if the checksums of the fix files 
				    # correspond to the base revision
				    foreach $fname (keys %base_checksums){
					#skip non-programdir files
					next unless $fname =~ /<NOTESPROGDIR>/;
					($fname1 = $fname) =~ s/<NOTESPROGDIR>//;
					#         $valid_checksums{$fname} = 1;
					if (($file eq $fname1) || ($fname1 eq "no_file".$file) ||($file_prev eq $fname1) ||  ($fname1 eq "no_file".$filetmp) ) {
					    local ($filepath, $fix_version);
					    foreach $fix_version (@fixlist, $ctx->{base_version},
								  $ctx->{nuicfg}->{rev},
								  $ctx->{target_version}){
						$bckupdir{$fix_version} = 
						    $dest ."/".	$fix_version;
						
						$filepath = $dest."/".$file;
						
						$backup{$filepath}->{$fix_version} = 
						    $bckupdir{$fix_version}; 
					    }
					    if ($ctx->{fix_type} eq 'upgrade'){
						$correct_checksum = $base_checksums{$fname};
					    }
					    else {
						my $hit = 0;
						if (! -d $bckupdir{$ctx->{target_version}}) {
						    $correct_checksum = 0;
						    $hit = 1;
						}
						#    else {
						#	$$rMsg .= "$txt{7.3} $ctx->{target_version} $txt{7.4}";
						#	$ret = 0;
						#	return;				
						 #   }
						$filepath = 
						    $bckupdir{$ctx->{target_version}}."/".
							$file;
						if ($hit == 0) {
						    $correct_checksum = $target_checksums{$fname};
						}
					    }
					    
					  #  @sb = stat($fname1);
					  #  $fgroup{$fname1} = $sb[5];
					  #  $fuid{$fname1} = $sb[4];
					  #  $fmode{$fname1} = $sb[2] & 07777;
					     
					    @sb = stat($filepath);
					    $fgroup{$filepath} = $sb[5];
					    $fuid{$filepath} = $sb[4];
					    $fmode{$filepath} = $sb[2] & 07777;
					    $curr_checksum = GetChecksum
						($err_msg,
						 $fname1);
					    # print "File $filepath; curr_checksum = $curr_checksum\n correct_checksum = $correct_checksum\n";
					    if ($curr_checksum ==
						$correct_checksum){
						$valid_checksums{$fname} = 1;
					    }
					    else{ # do not check for valid checksum these files
						if (( $fname !~ /strings.res/) && 
						    ($fname !~ /n[ts]f$/) &&
						    ($fname !~ /libndgts/) &&
						    ($fname !~ /nsd.sh/) && 
						    ($fname !~ /libigif/) &&
						    ($fname !~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d/)) {
						    if ($ctx->{fix_type} eq 'upgrade'){
							$valid_checksums{$fname} = 0;
							$valid_version = 0;
							next;
						    }
						    
						    my $filep = $dest."/".$file;
						    local $retBckup = FindBackup($filep);
						    local ($found_bckup, $fn) = @{$retBckup};
						    if (!$found_bckup){
							$valid_checksums{$fname} = 0;	
							$valid_version = 0;
							# print "Revert: invalid version\n";
						    } 
						}
					    }	
					}
				    }
				    
				}
			    }
			}
		    }
		    if ($ctx->{fix_type} eq 'upgrade'){
			foreach $file (@{$files}) {
			    $ctx->{ptSize} += ($inv->GetFileSize($file)*2);			    
			}
		    }
		}
	    }
	
	    # hotfixes:
	    # check if all the present in the base_revision hotfixes 
	    # have valid checksums:
	    if (!$ENV{NUI_NOCHECKSUM}){
		if (!$valid_version){ # this will happen if one of the files existed in the previous inst 
		    # with different checksum
		    foreach $fname (keys %base_checksums){
			next if ($fname =~ /strings\.res/);
			#temporary fix for CF1
			next if ($ENV{NUI_NOCHECKSUM});
			
			if(!$valid_checksums{$fname}){
			    $$rMsg .= $txt{err} .
				"$ctx->{fix_type}: $txt{7.1}$fname $txt{7.2}" ;
			    $valid_version = 0;
			    $ret = 0;		       
			}
		    
		    }
		    $ret = 0;
		    return 0;
		}
	    }
            @keys_backup = (keys %backup);
            foreach $key (keys %backup){
		${$ctx->{backup}}{$key} = $backup{$key};
	    }

	#
	# now check for space availability
	#
	local($availableK, $neededK, $mountPoint);
	local(%spacdat);
	#
	# first, progdir
	#

	GetPathData($ctx->{kitArch}, $ctx->{pPath}, \$availableK, \$mountPoint);
#GetPathData($arg1, $ctx->{pPath}, \$availableK, \$mountPoint);
	if (defined($spacdat{$mountPoint})) {
		$availableK = $spacdat{$mountPoint};
	}
	$neededK = int((($ctx->{ptSize}-$ctx->{ptSizeReclaim}) * 1.1) / 1024) + 1;
	$spacdat{$mountPoint} = $availableK - $neededK;
	if ($spacdat{$mountPoint} < 0) {
		$spacdat{$mountPoint} = 0;
	}
	if ($ENV{'NUI_DBG_SPACE'}) {
		print "progdir:\n";
		print "  ptSize:        $ctx->{ptSize}\n";
		print "  ptSizeReclaim: $ctx->{ptSizeReclaim}\n";
		print "  availableK:    $availableK\n";
		print "  neededK:       $neededK\n";
	}
	if ($availableK < $neededK) {
		$$rMsg .= 
			$txt{err} .
			"$txt{6.1}$ctx->{ptPath}$txt{6.2}" .
			$neededK . 
			"$txt{6.3}" .
			$availableK .
			"$txt{6.4}";
        $ret = 0;
		return 0;
	}

	# now check data dirs
        @ddirs = sort(keys(%{$ctx->{data_directories}}));
        foreach $ddir (@ddirs) {
        GetPathData($ctx->{kitArch}, $ddir, \$availableK, \$mountPoint);
		if (defined($spacdat{$mountPoint})) {
			$availableK = $spacdat{$mountPoint};
		}
		$neededK = 
			int((
				($ctx->{ddir_data}->{$ddir}->{size} -
				$ctx->{ddir_data}->{$ddir}->{sizeReclaim}) 
				* 1.1) / 1024) + 1;
		$spacdat{$mountPoint} = $availableK - $neededK;
		if ($spacdat{$mountPoint} < 0) {
			$spacdat{$mountPoint} = 0;
		}
		if ($ENV{'NUI_DBG_SPACE'}) {
			print "ddir $ddir:\n";
			print "  size:          $ctx->{ddir_data}->{$ddir}->{size}\n";
			print "  sizeReclaim:   $ctx->{ddir_data}->{$ddir}->{sizeReclaim}\n";
			print "  availableK:    $availableK\n";
			print "  neededK:       $neededK\n";
		}
		if ($availableK < $neededK) {
			$$rMsg .= 
				$txt{err} .
				"$txt{6.5}$ddir$txt{6.2}" .
				$neededK . 
				"$txt{6.3}" .
				$availableK .
				"$txt{6.4}";
	        $ret = 0;
			return 0;
		}
	}


EndOfEval
    if ($@) {
        ($evalline) = ($@ =~ /line (\d+)/);
        $$rMsg .= $@;
        $$rMsg .= __FILE__ . " line " . ($evalstart+$evalline) . "\n";
        return 0;
    }
    return $ret;
}


sub GetErrMsg {
	local($self) = @_;
	
	return $self->{errmsg};
}


sub PreInstallProcessing {
	local($self, $ctx, $rMsg) = @_;


	$$rMsg = "";

	local($cmd, $pwdout, @dfout);
	local($bMoveExisting) = 1;
	local($langpath);
	local($evalstart, $evalline);
	local $strings_file;

	$bMoveExisting = 0;
	if (defined $ENV{NUI_STRINGS}){
	    $strings_file = $ctx->{pPath} ."/".$ENV{NUI_STRINGS};
	}
	else{
	    &FindStrings();
	    if (!defined $strings_file){
		print "Couldn't find strings.res in $ctx->{pPath} - will attempt to use default\n" ;
		$strings_file = $ctx->{pPath}."/res/C/strings.res";	
	    }
	}
	    
	$self->{errmsg} = "";
	$evalstart = __LINE__; ++$evalstart;
	eval <<'EndOfEval';
	
	if ($ctx->{kitArch} eq "os390") {
		if (-l "$ctx->{pPath}/nsd.sh") {
			$self->SysCmd("$Sys::rm -f $ctx->{pPath}/nsd.sh") || die;
		}      
	}       	
	
        # added to accomodate hotfixes
        #backup files to be replaced/restored
	local @fix_files = keys %{$ctx->{backup}};
	local %target_files = ();
	if (defined ($ctx->{nuicfg}->{$ctx->{target_version}} ) ) {
	    foreach $item (keys %{$ctx->{nuicfg}->{$ctx->{target_version}}}){
		$target_files{$item} = 1;
	    }
	}
               
	if ($ctx->{fix_type} eq 'upgrade') {

	    foreach $filepath (@fix_files){
		local @fix_versions = keys %{$ctx->{backup}->{$filepath}};
		local ($progname, $dataname); 
		local ($fix_ver, $bckupdir);
		local $filename = `$Sys::basename $filepath`;
		chomp($filename);
		
		local $shortname = $filename;
		next if ($filepath =~ /jvm\/lib\/zi/); #only this fixpack 853FP4
		$progname = "<NOTESPROGDIR>".$shortname;
		$dataname = "<NOTESDATADIR>".$shortname;
		#skip all files that are not current fixes
		next unless ($target_files{$progname} or $target_files{$dataname}); 
		local $backupname;
		foreach $fix_ver (@fix_versions){		    
		    
		    $bckupdir = $ctx->{backup}->{$filepath}->{$fix_ver};
	#	    if  ($shortname =~ /^lwpd/) {
	#		print "Found!\n";
	#	    }
		    next if (!defined $bckupdir);
		    if (! -d $bckupdir){
			#create only backup directory for a base version
			next unless ($fix_ver eq $ctx->{base_version} || ($fix_ver eq $ctx->{nuicfg}->{rev}));
			if (!$self->SysCmd("$Sys::mkdir -p -m 777 $bckupdir")){
			    $$rMsg .= "Can't create backup directory $bckupdir";
			    $ret = 0;
			    return; 
			    }
			
		    }

		    next if ($fix_ver eq $ctx->{target_version});
		    #renamed jar
		    if ( $filename =~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d/)  {					    
			$oldname = $rename{$filename};
			if ($oldname) {
			    # to restore backup correctly
			    $backupname = $bckupdir."/".$oldname;
			    next if (-f $backupname);
			    if (!$self->SysCmd("$Sys::cp -p $filepath $backupname")){
				$$rMsg .= "Can't copy $filepath to the  backup directory $backupname: $?";
				$ret = 0;
				return;
			    }			
			}		
			
		    }
		    else {
			$backupname = $bckupdir."/".$filename;
		    }
		    next if (-f $backupname);
		    #Backup in the fix_rev directory only if file has a right checksum:
		    if (defined ($ctx->{nuicfg}->{$fix_ver}->{$progname}->{checksum}) ) {	
			if (defined ($ctx->{nuicfg}->{$ctx->{base_version}}->{$progname}->{checksum} ) ) {
			    next unless ($ctx->{nuicfg}->{$fix_ver}->{$progname}->{checksum} eq
					 $ctx->{nuicfg}->{$ctx->{base_version}}->{$progname}->{checksum});
			}
		    }
		    else {
			if ( ($filename !~ /n[ts]f$/ ) &&
			    ($filename !~ /libndgts/) &&
			    ($filename !~ /nsd.sh/)  &&
			    ($filename !~ /libigif/) &&
			    ($filename !~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d/)) {
			    if (defined ($ctx->{nuicfg}->{$fix_ver}->{$dataname}->{checksum}) ) {
				next unless ($ctx->{nuicfg}->{$fix_ver}->{$dataname}->{checksum} eq
					     $ctx->{nuicfg}->{$ctx->{base_version}}->{$dataname}->{checksum});
			    }						
			    else{
				next;
			    }
			}
		    } 
		    # No overwriting backup if it exists
		    if (-f $backupname){
			next;
			#if (!$self->SysCmd("$Sys::chmod +w $backupname")){
			#    $$rMsg .= "Can't chmod +w $backupname";
			#    $ret = 0;
			#    return $ret;
			#}
		    }
		    next if (!defined $bckupdir);
		    #else copy it to backup directory
		    
		    if ($filename =~ /\.res$/){			    
			local $fpath = $filepath;
			$fpath =~ s/$filename//;
			$filepath = $fpath."$langpath/$filename";
		    }
		    #    print "Copying $filepath to $bckupdir\n";

		    if ( $filename eq "nsd.sh" ){
			if ($ctx->{kitArch} eq "os390") {
			    #cp nsd.sh.IBM-1047 back to nsd.sh
			    if (!$self->SysCmd("$Sys::cp cp -p $ctx->{pPath}/nsd.sh.IBM-1047 $ctx->{pPath}/nsd.sh")){
				$$rMsg .= "Can't copy nsd.sh.IBM-1047 back to nsd.sh";
			 	$ret = 0;
				return;
			    }
			}
		    }
		    
		    if ( -f $filepath) {
			if (!$self->SysCmd("$Sys::chmod +w $filepath")){
			    $$rMsg .= "Can't chmod +w $filepath\n";
			    $ret = 0;
			    return $ret;
			}	
		    }
		    if (-f $filepath){ 
			if ($ctx->{kitArch} ne "os390") {
			    
			    if (!$self->SysCmd("$Sys::cp -p $filepath $bckupdir")){
				$$rMsg .= "Can't copy $filepath to the  backup directory $bckupdir";
				$ret = 0;
				return;
			    }	
			}
			else {
			    if (!$self->SysCmd("$Sys::cp cp -p $filepath $bckupdir")){
				$$rMsg .= "Can't copy $filepath to the  backup directory $bckupdir";
				$ret = 0;
				return;
			    }
			}
		    }
		}

	    }
	  
	    if (! (defined ($ctx->{nuicfg}->{nsdfix}) )  &&  ! (defined ($ctx->{nuicfg}->{customfix}) ) &&  ! (defined ($ctx->{nuicfg}->{saasfix}) ))  {  

		$ctx->{$ctx->{base_version}}->{version_string} 
		= UpdateVersion( $ctx->{$ctx->{target_version}}->{version_string}, $strings_file,'UseCompleteString');
		if (!defined $ctx->{$ctx->{base_version}}->{version_string} ) {
		    $ctx->{$ctx->{base_version}}->{version_string} = $vs1;
		}
		if (defined ($ctx->{nuicfg}->{base_stringsres})) {
		    if (!defined $ctx->{$ctx->{base_version}}->{version_string} ) {
			$ctx->{$ctx->{base_version}}->{version_string} =$ctx->{nuicfg}->{base_stringsres};
		    }
		}
	    }
	}
	else{
	    #restore files, write config (ctx) info and exit (no other processing is needed)
	    foreach $filepath (@fix_files) {
		my $shortname = `$Sys::basename $filepath`;		   		    
		chomp($shortname);
		$prognofilename = "<NOTESPROGDIR>"."no_file".$shortname;
		$datanofilename = "<NOTESDATADIR>"."no_file".$shortname;
		
		
		if ($ctx->{base_version} =~ /HF[0-9]+$/) {
		    $progname = "<NOTESPROGDIR>".$shortname;
		    $dataname = "<NOTESDATADIR>".$shortname;
		    #skip all files that are not current fixes
		    next unless ($target_files{$progname} or $target_files{$dataname}); 
		}
		if ( $shortname =~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d/)  {
		   # print "Debug!";
		}
		if (( $ctx->{nuicfg}->{$ctx->{target_version}}->{$prognofilename}->{"checksum"} eq 0)  || 
		    ( $ctx->{nuicfg}->{$ctx->{target_version}}->{$datanofilename}->{"checksum"} eq 0) ) {
		    $found_bckup = -1;
		}
		else {
		    # find corresponding file with the correct checksum in some other backup 
		    local $retBckup = FindBackup($filepath);
		    ($found_bckup, $filename) = @{$retBckup};
		}
		if  ($found_bckup == -1)  { #0 checksum
		    if ( -f $filepath) {
			if (!$self->SysCmd("$Sys::chmod +w $filepath")){
			    $$rMsg .= "Can't chmod +w $filepath";
			    $ret = 0;
			    return 0;
			}
			# do not remove if it is partition backup
			$self->SysCmd("$Sys::rm -f $filepath");
			next;
		    }
		}
		if (!$found_bckup){
		    $$rMsg .= "Haven't found backup with correct checksum for $shortname\n";
		    $ret = 0;
		    return 0;
		}
		if ($shortname =~ /\.res$/){
		    $filepath = $ctx->{pPath}."/$langpath/$shortname";
		    # print "restoring strings.res : $filepath\n";
		    if ($shortname =~ /strings.res$/){
			$strings_file = $filepath;
			if ($ENV{LP_REPLACE} == 1) {
			    $filename = $ctx->{pPath}."/".$ctx->{target_version}."/".$shortname;
			}
		    }
		}
		#if $filename was returned from FindBackup (if it is 0 then this file was not present in the nui.cfg)
		if ($filename) {
		    #print "Findbackup returned $filename\n";
		    if (-e $filepath){			
			if (!$self->SysCmd("$Sys::chmod +w $filepath")){
			    $$rMsg .= "Can't chmod +w $filepath";
			    $ret = 0;
			    return 0;
			}
		    }	
		    if ($ctx->{kitArch} eq "os390") {			
			if (!$self->SysCmd("$Sys::cp cp -p $filename $filepath")){
				if ( -f $filepath) {
			    	$$rMsg .= "Can't restore $filename to the dest  directory $filepath\n";
			    	$ret = 0;
			    	return 0;
				}
				else {				   
				    if (-f $filename) {
					$self->SysCmd("$Sys::rm -f $filename");
					next;
				    }
				}
			}
			
			if ($filename =~  /startup$/) {
			    if ( -f "$ctx->{pPath}/startup") {
				if ( -f "$ctx->{pPath}/startup.sh") {
				    $self->SysCmd("$Sys::rm $ctx->{pPath}/startup.sh") || die;
				}
				$self->SysCmd("$Sys::mv $ctx->{pPath}/startup $ctx->{pPath}/startup.sh") || die;
			    }
			}
		    } 
		    else{
		
			if ($ctx->{kitArch}  =~ /^aix/) {
			    if (-x "/usr/sbin/slibclean") {
				$self->SysCmd("/usr/sbin/slibclean");
			    }				
			} 
			$self->SysCmd("$Sys::chmod 0755 $filepath");
		
			if ( $shortname =~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d/)  {
			    $old_name = $rename{$shortname};
			    if (defined $old_name) {
				$self->SysCmd("$Sys::rm -f $filepath");
				$filepath =~ s/$shortname$/$old_name/;
				$self->SysCmd("$Sys::cp -p  $filename $filepath") || die;
				$self->SysCmd("$Sys::chmod 0755 $filepath");
			    }
			}
			elsif (!$self->SysCmd("$Sys::cp  $filename $filepath")){
			    
			    if ( -f $filepath) {				   
				$$rMsg .= "Can't restore $filename to the dest  directory $filepath\n";
				$ret = 0;
				return 0;
			    }
			}
			else {
			    
			    if (-f $filename) {
				$self->SysCmd("$Sys::rm -f $filename");
			    }
			}
		    }
		}
	    }
		
	
	    if  ($ctx->{kitArch}  =~ /inux/) {
		if ( -f  "$ctx->{pPath}/senddiag_svr") {
		    if ( -f "$ctx->{pPath}/senddiag") {
			$self->SysCmd("$Sys::rm $ctx->{pPath}/senddiag") || die;
		    }
		    $self->SysCmd("$Sys::mv $ctx->{pPath}/senddiag_svr $ctx->{pPath}/senddiag") || die;
		    $self->SysCmd("$Sys::chmod 0755 $ctx->{pPath}/senddiag" );
		     $self->SysCmd("$Sys::chown -R 0:0 $ctx->{pPath}/senddiag" );
		}
	    }
	    
	    if (!defined $ctx->{$ctx->{target_version}}->{version_string}){
		#      print " Revert: version string not defined for $ctx->{version_string}\n";
		#      print "         using $ctx->{version_string}\n";
		#      print " strings file: $strings_file\n";
		local $old_vs;
		if ($ctx->{target_version} eq $ctx->{nuicfg}->{rev}){
		    if (!defined( $ENV{LP_REPLACE} ) &&  (! (defined ($ctx->{nuicfg}->{nsdfix}) )  )
			&&  (! (defined ($ctx->{nuicfg}->{saasfix}) )  )
			&& (! (defined ($ctx->{nuicfg}->{customfix}) )  ) )  {
			$old_vs = UpdateVersion($ctx->{version_string}, $strings_file,'UseCompleteString');
		    }
		    #		print "        was : $old_vs\n";
		    if (!defined $ctx->{$ctx->{target_version}}->{version_string} ) {
			$ctx->{$ctx->{target_version}}->{version_string} = $ctx->{version_string};
		    }
		}
	    }
	    
	    else{
		#      local $ts = $ctx->{$ctx->{target_version}}->{version_string};
		local $old_vs;
		#      print "Revert: updating version with $ts\n";
		#       print " strings file: $strings_file\n";
		 if (! (defined ($ctx->{nuicfg}->{nsdfix}) )  && ! (defined ($ctx->{nuicfg}->{customfix}) ) && ! (defined ($ctx->{nuicfg}->{saasfix}) ))  {  
		     $old_vs = UpdateVersion($ctx->{$ctx->{target_version}}->{version_string}, $strings_file,'UseCompleteString');
		 }
		#      print "        was : $old_vs\n";				    
	    }
		
	 if ( defined ($ctx->{nuicfg}->{nsdfix}) || defined ($ctx->{nuicfg}->{saasfix}) || defined ($ctx->{nuicfg}->{customfix}) )  {  		
#	     undef $ctx->{target_version};
#	    undef $ctx->{base_version};
	     $ctx->{target_version} = $ctx->{nuicfg}->{rev};
	     $ctx->{base_version} = $ctx->{nuicfg}->{rev};
	 }
	    else {
		if ( $ctx->{fix_type}  eq "upgrade") {
		    WriteCtxFile($ctx);
		} 
                  #                Don't restore here yet
	#	else { #restore the .install.dat from the backup directory
	#	    $filename = $ctx->{pPath}."/".$ctx->{target_version}."/".".install.dat";
	#	    if ( -f $filename) {
	#		if (!$self->SysCmd("$Sys::cp -p $filename $ENV{NUI_CFGFILE}")){
	#		    if ( -f $filepath) {
	#			$$rMsg .= "Can't restore $filename to the dest  directory $ENV{NUI_CFG} \n";
	#			$ret = 0;
	#			return 0;
	#		    }
	#		}
	#	    }
	#	    else {
	#		WriteCtxFile($ctx);	
	#	    }
	#	}
	    }
	    
	    $ret = 1;
	    return 1;
	}

	$ctx->{add_data_directories_only} && return 1;
	
	# for AIX
	if (-x "/usr/sbin/slibclean") {
		$self->SysCmd("/usr/sbin/slibclean");
	}
        $ret = 1;

EndOfEval
    if ($@) {
        ($evalline) = ($@ =~ /line (\d+)/);
        $$rMsg .= $@;
        $$rMsg .= __FILE__ . " line " . ($evalstart+$evalline) . "\n";
        return 0;
    }
    return $ret;
}
	


sub PostInstallProcessing {
	local($self, $ctx, $rMsg) = @_;


	local($ptPath) = $ctx->{ptPath};

	local($_, $out, $cmd, $stat, $dPath);
	local($fgmapfile, $fgmapcfg, $fgmap);
	local($ddir, @ddirs);
	my $target_backupdir = "$ctx->{pPath}/$ctx->{target_version}";
	my $base_backupdir = "$ctx->{pPath}/$ctx->{base_version}";
	my $compr = "tar cf - . ";
	if ( $ENV{'NUI_ARCH'}  =~  /linux/)  {	   
	    $uncompressCmd = "gunzip";
	    $compr .= "| gzip -c -f ";
	} else {
	    $compr .= "| compress -c -f -b 12 ";
	    $uncompressCmd = "uncompress";
	}
	
	# added to accomodate hotfixes

	if ($ctx->{kitArch} eq "os390") {
	    #prepare to set the ownership and permissions of the fix files
	    local($kcurid)=`id -u`;
	    chomp($kcurid);
	    local($group)=`id -g`;
	    chomp($group);
	}
	local @fix_files = keys %{$ctx->{backup}};
	local %target_files = ();
	@ddirs = sort(keys(%{$ctx->{data_directories}}));
#	foreach $dPath (@ddirs) {
	
#	    $group = $ctx->{data_directories}->{$dPath}->{data_UNIX_group};
#	    $user = $ctx->{data_directories}->{$dPath}->{data_UNIX_user};
#	    system("find $dPath -follow ! \\( -user $user -o -group $group \\) | xargs chown -Rh $user:$group");
#	    system(" find  $dPath  -follow !  -perm 755 |xargs chmod 755");
	  
	    
#	}
	    foreach $item (keys %{$ctx->{nuicfg}->{$ctx->{target_version}}}){
		$target_files{$item} = 1;
		if ($item =~ /<NOTESDATADIR>(.+)$/) {
		    @ddirs = sort(keys(%{$ctx->{data_directories}}));
		    $justname = $1;			    		   		    
			if ($justname =~ /dom-dojo.taz/ )
			{	
			    foreach $dPath (@ddirs) {
					$group = $ctx->{data_directories}->{$dPath}->{data_UNIX_group};
					$user = $ctx->{data_directories}->{$dPath}->{data_UNIX_user};
					$jspath = $dPath."/domino/js/";
					$dominopath = $dPath."/domino/";
					my $DataFilesdojo = $self->{cdf}->{data}->{DataFilesdojo};
					if ( $DataFilesdojo =~ m/(dojo-\d+.\d+.\d+)/ ) {
						$newdojo_dir = $1;
					}
					else {
						$$rMsg .= "Can't get new dojo version from tar file location $DataFilesdojo\n";
						$ret = 0;
						return 0;
					}
					$newjsdojopath = $jspath.$newdojo_dir;					
					$newjsdojotemplatepath = $jspath.$newdojo_dir."/template";					
					$newtemplatedojopath = $dominopath."template/".$newdojo_dir;					
					chomp ($newdojo_dir);					
					$filep = $dPath."/domino/js/$newdojo_dir/dom-dojo.taz";
					if ( $ctx->{fix_type}  eq "revert") {
						#remove dojo and unzip old file
						if ( -f  "$target_backupdir/dom-dojo.taz" ) {
							chdir ("$dominopath") or die "Can't change to $dominopath:$!";
							$self->SysCmd("rm -rf $newjsdojopath");
							$self->SysCmd("rm -rf $newtemplatedojopath");
							$self->SysCmd("cp $target_backupdir/dom-dojo.taz  .") or die "Can't move dom-dojo.taz from $target_backupdir  $!";
							$uncompr = "cat dom-dojo.taz | $uncompressCmd -c | $Sys::tar xvf -";
							$dbg && print "    extract cmd: $uncompr\n";
							$dbg && print "    extracting " . `date`;
							$out = `$Sys::sh -c "$uncompr" 2>&1`;
							$stat = ($? >> 8);
							if ($dbg) {
								print "    stat: $stat\n";
								print "    out: $out";
							}
							if ($stat) {
								$$rMsg .=  "$out\n";
								$ret = 0;
								return 0;
							}
							else { 
								#delete  old zip on upgrade after unzip
								$self->SysCmd("rm dom-dojo.taz");					    
							}
						}
					}
					else {
						if (-f $filep) { #upgrade 
							#chdir ("$jspath/$newdojo_dir") or die "Can't change to $jspath/$dojo_dir:$!";
							#save new dom-dojo.taz				
							$self->SysCmd("mv $newjsdojopath/dom-dojo.taz $jspath") or die "Can't move dom-dojo.taz  to $jspath$!";					
							$self->SysCmd("rm -rf $newjsdojopath");							
							#backup it in base _backup directory
							if (! -d $base_backupdir){	   
								if (!mkdir $base_backupdir, 0755) {
									$$rMsg .= "Can't mkdir $base_backupdir: $!";
									$ret = 0;
									return 0; 
								}
							}
							#first tar/compress existing dojo (we are in domino dir)							
							chdir ("$dominopath") or die "Can't change to $dominopath:$!";														
							# tar cf - js/dojo-* template/dojo-* | gzip -c -f > $base_backupdir/dom-dojo.taz
							my $tazcommand = "tar cf - js/dojo-* template/dojo-*";
							if ( $ENV{'NUI_ARCH'}  =~  /linux/)  {	   
								$tazcommand .= " | gzip -c -f";
							} else {
								$tazcommand .= " | compress -c -f -b 12";
							}
							$tazcommand .= " > $base_backupdir/dom-dojo.taz"; #this is old taz
							my $out = `$tazcommand`;
							$stat = ($? >> 8);
							if ($dbg) {
								print "    stat: $stat\n";
								print "    out: $out";
							}
							if ($stat) {					
								$$rMsg .= "Can't compress existing dojo\n";
								$ret = 0;
								return 0;
							}
					
							chdir ("$jspath") or die "Can't change to $jspath: $!";
							#then remove current dojo directory
							$self->SysCmd("rm -rf dojo-*");
							$self->SysCmd("mkdir $newdojo_dir");				
							#then restore and uncompress the new file
							$self->SysCmd("mv $jspath/dom-dojo.taz $jspath/$newdojo_dir");
							chdir ("$jspath/$newdojo_dir") or die "Can't change to $jspath/$newdojo_dir:$!";
							$uncompr = "cat dom-dojo.taz | $uncompressCmd -c | $Sys::tar xvf -";
							$dbg && print "    extract cmd: $uncompr\n";
							$dbg && print "    extracting " . `date`;
							$out = `$Sys::sh -c "$uncompr" 2>&1`;
							$stat = ($? >> 8);
							if ($dbg) {
								print "    stat: $stat\n";
								print "    out: $out";
							}
							if ($stat) {
								$$rMsg .=  "$out\n";
								$ret = 0;
								return 0;
							}
							#delete/backup current zip on upgrade after unzip
							$self->SysCmd("rm dom-dojo.taz");
							chdir ("$dominopath") or die "Can't change to $dominopath:$!";																					
							$self->SysCmd("rm -rf template/dojo-*");
							$self->SysCmd("mv $newjsdojotemplatepath $newtemplatedojopath");				
							# SPR MLAT9ZD6G5:  iNotes crash on Linux, AIX. SPR#SVRO9YLM35: iNotes crash in MAXSPRINTF
							$self->SysCmd("chown -R $user:$group $newjsdojopath");							
							$self->SysCmd("chmod -R 755 $newjsdojopath");
							$self->SysCmd("chown -R $user:$group $newtemplatedojopath");
							$self->SysCmd("chmod -R 755 $newtemplatedojopath");	
						}
					}
			    }
			}

			if ($justname =~ /ckeditor.taz/)
			{	
			    foreach $dPath (@ddirs) {
					$group = $ctx->{data_directories}->{$dPath}->{data_UNIX_group};
					$user = $ctx->{data_directories}->{$dPath}->{data_UNIX_user};
					$domino_html_dir = "$dPath/domino/html";
					$ckeditor_dir = "ckeditor";
					chomp ($ckeditor_dir);
					$filep = $dPath."/domino/html/$ckeditor_dir/ckeditor.taz";
					if ( $ctx->{fix_type}  eq "revert") {
						#remove ckeditor and unzip old file
						if ( -f  "$target_backupdir/ckeditor.taz" ) {
							chdir ("$domino_html_dir") or die "Can't change to $domino_html_dir:$!";
							$self->SysCmd("rm -rf  $ckeditor_dir");
							$self->SysCmd("mkdir   $ckeditor_dir");
							chdir ("$domino_html_dir/$ckeditor_dir") or die "Can't change to $domino_html_dir/$ckeditor_dir:$!";
							$self->SysCmd("cp $target_backupdir/ckeditor.taz  .") or die "Can't copy ckeditor.taz from $target_backupdir  $!";
							$uncompr = "cat ckeditor.taz | $uncompressCmd -c | $Sys::tar xvf -";
							$dbg && print "    extract cmd: $uncompr\n";
							$dbg && print "    extracting " . `date`;
							$out = `$Sys::sh -c "$uncompr" 2>&1`;
							$stat = ($? >> 8);
							if ($dbg) {
								print "    stat: $stat\n";
								print "    out: $out";
							}
							if ($stat) {
								$$rMsg .=  "$out\n";
								$ret = 0;
								return 0;
							}
							else { 
								#delete  old zip on upgrade after unzip
								$self->SysCmd("rm ckeditor.taz");					    
							}
						}
					}
					else {
						if (-f $filep) { #upgrade 
							chdir ("$domino_html_dir/$ckeditor_dir") or die "Can't change to $domino_html_dir/$ckeditor_dir:$!";
							#save new ckeditor.taz				
							$self->SysCmd("mv ckeditor.taz $domino_html_dir") or die "Can't move ckeditor.taz  to $domino_html_dir$!";					
							#backup it in base _backup directory
							if (! -d $base_backupdir){	   
								if (!mkdir $base_backupdir, 0755) {
									$$rMsg .= "Can't mkdir $base_backupdir: $!";
									$ret = 0;
									return 0; 
								}
							}
							#first tar/compress existing ckeditor (we are in ckeditor_dir)
							$compr .= " > $base_backupdir/ckeditor.taz"; #this is old taz
							my $out = `$compr`;
							$stat = ($? >> 8);
							if ($dbg) {
								print "    stat: $stat\n";
								print "    out: $out";
							}
							if ($stat) {					
								$$rMsg .= "Can't compress existing ckeditor\n";
								$ret = 0;
								return 0;
							}
					
							chdir ("$domino_html_dir") or die "Can't change to $domino_html_dir: $!";
							#then remove current ckeditor directory
							$self->SysCmd("rm -rf  $ckeditor_dir");
							$self->SysCmd("mkdir   $ckeditor_dir");				
							#then restore and uncompress the new file
							$self->SysCmd("mv $domino_html_dir/ckeditor.taz $domino_html_dir/$ckeditor_dir");
							chdir ("$domino_html_dir/$ckeditor_dir") or die "Can't change to $domino_html_dir/$ckeditor_dir:$!";
							$uncompr = "cat ckeditor.taz | $uncompressCmd -c | $Sys::tar xvf -";
							$dbg && print "    extract cmd: $uncompr\n";
							$dbg && print "    extracting " . `date`;
							$out = `$Sys::sh -c "$uncompr" 2>&1`;
							$stat = ($? >> 8);
							if ($dbg) {
								print "    stat: $stat\n";
								print "    out: $out";
							}
							if ($stat) {
								$$rMsg .=  "$out\n";
								$ret = 0;
								return 0;
							}
					
							#delete/backup current zip on upgrade after unzip
							$self->SysCmd("rm ckeditor.taz");
							# SPR LHEY9YGLUU:  CKEditor not rendering on 901FP4 on RHEL 32-bit
							$self->SysCmd("chown -R $user:$group $domino_html_dir/$ckeditor_dir");														
							$self->SysCmd("chmod -R 755 $domino_html_dir/$ckeditor_dir");
						}
					}
			    }
			}
			
		}
		elsif ($item =~ /<NOTESPROGDIR>(.+)$/)  {		     
		  

		    $justname = $1;
		    $dPath =  "$ctx->{ptPath}/notes/latest/$self->{archMnemMap}->{$ctx->{kitArch}}";
		    if ($justname =~  /osgi_plugins.taz/) {	
			if ( $ctx->{fix_type}  eq "upgrade") {
			    next if ($justname =~ /no_file/);
			}
			else {
			    next if ($justname !~ /no_file/);
			}
		    			
			$eclipse_path = $dPath."/osgi/shared/eclipse";			    			    			 
			GetTaz($eclipse_path, "plugins","osgi_plugins.taz",1); #last argument value : 1 - program permissions/ownership or 2 - data permissions ownership
			 next;
		    }
		    elsif ($justname =~  /jvm_patch.diff/) {
			if ( $ctx->{fix_type}  eq "upgrade") {
			    next if ($justname =~ /no_file/);
			}
			else {
			    next if ($justname !~ /no_file/);
			}
			my $rt = GetTaz($dPath, "jvm","jvm_patch.diff",1);
			if ( $ctx->{fix_type} ne "revert") { 		
				if ($ctx->{kitArch} =~ /aix/) {
			    		local ($links) = [];
			    		push(@{$links}, "jcontrol",
				 		"notes/latest/<ARCH>/jvm/bin/ControlPanel",
				 		"libjvm.so",
				 		"notes/latest/<ARCH>/jvm/bin/classic/libjvm.a",
				 		"libjvm.so",
				 		"notes/latest/<ARCH>/jvm/bin/j9vm/libjvm.a");
			    
			    		$self->CreateSymLinks($ctx->{ptPath}, $links) || die;
				}
				if ($ctx->{kitArch} =~ /linux/) {
				    local ($links) = [];
				    push(@{$links},
					 (					 
					  "../bin/javaws",
					  "notes/latest/<ARCH>/jvm/javaws/javaws"
					  ));
				    $self->CreateSymLinks($ctx->{ptPath}, $links) || die;
				}

			}
			next;
		    }
		    

	#	    if ($ctx->{ptPath}) {			
		    $filep = "$ctx->{ptPath}/notes/latest/$self->{archMnemMap}->{$ctx->{kitArch}}/$justname";
		    if ( -e $filep) {
			$self->SysCmd("$Sys::chmod 755 $filep") || die " Can' chmod on $filep\n";
			if ( ! defined $ENV{NUI_NOTROOT} ) {
			    chown(0, 0, $filep) || die " Can' chown on $filep:$!";
			}
		    }
		#    }
		}
	
	}
	
	# XXLI9UP94V,  the mode of these files should be set when FP reversion
	if  (($ctx->{kitArch}  =~ /inux/) || ($ctx->{kitArch}  =~ /aix/)) {
	    if ( -f  "$ctx->{pPath}/senddiag_svr") {
		if ( -f "$ctx->{pPath}/senddiag") {
		    $self->SysCmd("$Sys::rm $ctx->{pPath}/senddiag") || die;
		}
		$self->SysCmd("$Sys::mv $ctx->{pPath}/senddiag_svr $ctx->{pPath}/senddiag") || die;
		$self->SysCmd("$Sys::chmod 0755 $ctx->{pPath}/senddiag") ;
		$self->SysCmd("$Sys::chown -R 0:0 $ctx->{pPath}/senddiag") ;
	    }
	    if (-f "$ctx->{pPath}/tunekrnl") {
		chown(0,1,"$ctx->{pPath}/tunekrnl");
		$self->SysCmd("$Sys::chmod 4555 $ctx->{pPath}/tunekrnl") || die;
	    }
	    if (-f "$ctx->{pPath}/bindsock") {
		chown(0,1,"$ctx->{pPath}/bindsock");
		$self->SysCmd("$Sys::chmod 4555 $ctx->{pPath}/bindsock") || die;
	    }
	}
	
	#nothing more needed in case of revert
	if ( $ctx->{fix_type}  eq "revert") {
	    return 1;
	}
				
if ($ctx->{kitArch} =~ /aix/) {
    local ($links) = [];
push(@{$links}, "jcontrol",
     "notes/latest/<ARCH>/jvm/bin/ControlPanel",
     "libjvm.so",
     "notes/latest/<ARCH>/jvm/bin/classic/libjvm.a",
     "libjvm.so",
     "notes/latest/<ARCH>/jvm/bin/j9vm/libjvm.a");

$self->CreateSymLinks($ctx->{ptPath}, $links) || die;
}
if ($ctx->{kitArch} =~ /linux/) {
    local ($links) = [];
push(@{$links},
     (					 
      "../bin/javaws",
      "notes/latest/<ARCH>/jvm/javaws/javaws"
      ));
$self->CreateSymLinks($ctx->{ptPath}, $links) || die;
				}
	foreach $filepath (@fix_files){
	    if ($ctx->{kitArch} eq "os390") {
		system("chown $kcurid:$group $filepath");
		$self->SysCmd("$Sys::chmod 755 $filepath");
	    }
	    #back up the current fix in the backup directory corresp to target version
	    
	    if ((defined ( $fuid{$filepath})) && (defined ( $fuid{$filepath}) ) ) {
		chown(
		      $fuid{$filepath},
		      $fgroup{$filepath},
		      $filepath);
	    }

	    if (defined ($fmode{$filepath})){
		chmod($fmode{$filepath}, $filepath);
	    }
	    
	    local $bckupdir;
	    if ($ENV{LP_REPLACE} == 1) {		    
		
		if ($filepath =~ /\.res/){
		    $bckupdir = $ctx->{pPath}."/".$ctx->{target_version};
		}
		else {
		    $bckupdir = $ctx->{backup}->{$filepath}->{$ctx->{target_version}};
		}
		}
	    else {
		
		$bckupdir = $ctx->{backup}->{$filepath}->{$ctx->{target_version}};
	    }	    #	print "Backing up current fix $filepath in $bckupdir\n";
	    next unless defined($bckupdir);
	    if (! -d $bckupdir){
		if (-f $bckupdir){
			$self->SysCmd("$Sys::rm $bckupdir")  || die "can't remove $bckupdir: $?";
		    }
		$self->SysCmd("$Sys::mkdir -p -m 755 $bckupdir") || die "can't mkdir $bckupdir: $?";
	    }
	    if ($ctx->{kitArch} eq "os390") {
		$self->SysCmd("$Sys::cp cp -p $filepath $bckupdir");
	    }
	    else{
		$self->SysCmd("$Sys::cp -p $filepath $bckupdir");
	    }
	}       
	
	# XXLI9UP94V,  the mode of these files should be set when FP installation
	if  (($ctx->{kitArch}  =~ /inux/) || ($ctx->{kitArch}  =~ /aix/)) {	
	    if ( -f  "$ctx->{pPath}/senddiag_svr") {
		if ( -f "$ctx->{pPath}/senddiag") {
		    $self->SysCmd("$Sys::rm $ctx->{pPath}/senddiag") || die;
		}
		$self->SysCmd("$Sys::mv $ctx->{pPath}/senddiag_svr $ctx->{pPath}/senddiag") || die;
		$self->SysCmd("$Sys::chmod 0755 $ctx->{pPath}/senddiag") ;
		$self->SysCmd("$Sys::chown -R 0:0 $ctx->{pPath}/senddiag") ;
	    }
	    if (-f "$ctx->{pPath}/tunekrnl") {
		chown(0,1,"$ctx->{pPath}/tunekrnl");
		$self->SysCmd("$Sys::chmod 4555 $ctx->{pPath}/tunekrnl") || die;
	    }
	    if (-f "$ctx->{pPath}/bindsock") {
		chown(0,1,"$ctx->{pPath}/bindsock");
		$self->SysCmd("$Sys::chmod 4555 $ctx->{pPath}/bindsock") || die;
	    }
	}
	
	local($langpath);
	 if ( defined ($ctx->{nuicfg}->{nsdfix})  || defined ($ctx->{nuicfg}->{saasfix}) || defined ($ctx->{nuicfg}->{customfix}) )  {  		
	#     undef $ctx->{target_version};
	#    undef $ctx->{base_version};
	     $ctx->{target_version} = $ctx->{nuicfg}->{rev};
	     $ctx->{base_version} = $ctx->{nuicfg}->{rev};	     
	 }
	else {
	             if ( $ctx->{fix_type}  eq "upgrade") {
			 WriteCtxFile($ctx);
	    	}
		else { #restore the .install.dat from the backup directory
		    $filename = $ctx->{pPath}."/".$ctx->{target_version}."/".".install.dat";
		    if ( -f $filename) {
			if (!$self->SysCmd("$Sys::cp -p $filename $ENV{NUI_CFGFILE}")){
			    if ( -f $filepath) {
				$$rMsg .= "Can't restore $filename to the dest  directory $ENV{NUI_CFG} \n";
				$ret = 0;
				return 0;
			    }
			}
		    }
		    else {
			WriteCtxFile($ctx);	
		    }
		}
	}
	if ( $ENV{LP_JP} == 1) {
	    if ( $ctx->{kitArch}  =~ /^aix/ ) {
		$langpath = "res/Ja_JP";
		} elsif ( $ctx->{kitArch} eq "sol" ) { 
		    $langpath = "res/ja";
		} elsif ( $ctx->{kitArch} =~  /linux/) {
		    $langpath = "res/ja_JP.ujis";
		} else {
		    $langpath = "res/C";
		}
	}
	else {
	    if (
		(! $ENV{'LANG'}) ||
		($ENV{'LANG'} =~ /^posix$/i) ||
		($ENV{'LANG'} =~ /^en_us/i) ||
		($ENV{'LANG'} =~ /^en_GB/i)
		) {
		$langpath = "res/C";
		} else {
		    $langpath = "res/$ENV{'LANG'}";
		}
	}
	$self->Chdir($ctx->{pPath}) || die;
#                if ($ENV{RESOURCES})
#	{
	     $self->SysCmd("$Sys::cp  *.res $langpath");
	     $self->SysCmd("$Sys::rm *.res"); 
	     # 2016/03/18 RMASA7NMGK Brazil DST boundary is incorrect for the end of DST in 2016
	     $self->SysCmd("$Sys::mv TimeZones*.txt $langpath"); 
#	}
	 if ($ctx->{kitArch} eq "os390") {
	     if (-f "startup") {
		 if (-f "startup.sh"){
		     $self->SysCmd("$Sys::rm startup.sh") || die;
		 }
		 $self->SysCmd("$Sys::mv startup startup.sh") || die;
	     }
	    $self->SysCmd("$Sys::cp cp  -p $langpath/cvs*.res .");   
	 }
	if ($ctx->{kitArch} ne "os390") {
	    $self->SysCmd("$Sys::cp -p $langpath/cvs*.res .");  
	}
	$self->SysCmd("$Sys::chmod 444 $langpath/*.*");
	$self->SysCmd("$Sys::chown 0:2 $langpath/*.*");
	if ( -f "$langpath/dsfvote.res" ) {
	    $self->SysCmd("$Sys::mv  $langpath/dsfvote.res .") || die;
	}	
	if (($ctx->{kitArch} eq "os390") || ($ctx->{kitArch} eq "zlinux")) {
	   $self->zSeriesPostProcessing($ctx, \$msg);	    	
	}	
	if ( -f "$ENV{NUI_DISTROOT}/deleted_prog.dat"){
		    if (!open(DEL_PROG, "< $ENV{NUI_DISTROOT}/deleted_prog.dat")) {
			$$rMsg = "$txt{2.1}$ENV{NUI_DISTROOT}/deleted_prog.dat$txt{2.2}";
		    }
		    while (<DEL_PROG>){
			$delfile = $ctx->{pPath}."/".$_;
			$self->SysCmd("$Sys::rm -f $delfile");	
		    }
		    if ( !close(DEL_PROG)) {
			$$rMsg = "$txt{2.1}$ENV{NUI_DISTROOT}/deleted_prog.dat$txt{2.2}";
			
		    }
		}	
	return 1;		
}


sub Chdir {	
	local($self, $dir) = @_;

	if ( ! chdir($dir)) {
		$self->{errmsg} = "$txt{5.1}$dir$txt{5.2}";
		return 0;
	}

	return 1;
}


sub SysCmd {
	local($self, $cmd, $srOut, $srStat) = @_;

	local($out, $stat);

    $out = `$Sys::sh -c "$cmd" 2>&1`;
	$stat = ($? >> 8);
	defined($srOut) && ($$srOut = $out);
	defined($srStat) && ($$srStat = $stat);
	if ($stat) {
		chomp($out);
		# diagnostic message; customer should not see this
		$self->{errmsg} = 
			"Error executing system command.\n" .
			"Command:>$cmd<\n" .
			"Output:>$out<\n" . 
			"Return Value: $stat\n" .
			"System error string:>$!<\n";
		return 0;
	}
	return 1;
}




######################################################################
# internal funcs

sub GetTimeStampString {
	local($self) = @_;
 
    local(@lt) = localtime(time());
 
    return(
        sprintf(
            "%02d%02d%02d.%02d%02d%02d",
            $lt[5],
            $lt[4]+1,
            $lt[3],
            $lt[2],
            $lt[1],
            $lt[0]
        )
    );
}


sub CreateSymLinks {
	local($self, $path, $links) = @_;

	local($targ, $link, $linkdir, $targchk);

	local($dbg) = $ENV{'NUI_DBGSYMLINKS'};


    local($evalstart, $evalline);
    $self->{errmsg} = "";
    $evalstart = __LINE__; ++$evalstart;
    eval <<'EndOfEval';

        $self->Chdir("$path") || die;
		while ($targ = shift(@{$links})) {
			$link = shift(@{$links});
			$targ =~ s/<ARCH>/$self->{archMnemMap}->{$ctx->{kitArch}}/g;
			$link =~ s/<ARCH>/$self->{archMnemMap}->{$ctx->{kitArch}}/g;
			$dbg && print "targ $targ\n";
			$dbg && print "link $link\n";

			($linkdir) = ($link =~ /^(.*)\//);
			(-d $linkdir) || $self->SysCmd("$Sys::mkdir -p $linkdir") || die;
			
			if (-e $link || -l $link) {
				$self->SysCmd("$Sys::rm -f $link") || die;
			}
			$self->SysCmd("$Sys::ln -s $targ $link") || die;
			$dbg && print "\n";
		}

EndOfEval
    if ($@) {
        ($evalline) = ($@ =~ /line (\d+)/);
        $self->{errmsg} .= $@;
        $self->{errmsg} .= __FILE__ . " line " . ($evalstart+$evalline) . "\n";
        return 0;
    }
    return 1;
}


sub IsBatchMode {
	local($self) = @_;

	return $self->{batchMode};
}
sub GetTaz{
    my ($eclipse_path, $sDir, $tazName, $perm) = @_;
  
    my $filep = "$eclipse_path/$sDir/$tazName";
    my $target_backupdir = "$ctx->{pPath}/$ctx->{target_version}";
    my $base_backupdir = "$ctx->{pPath}/$ctx->{base_version}";
    my $gold_base_backupdir = "$ctx->{pPath}/$ctx->{ptPathExistRev}";
    my $compr = "tar cf - . ";
    my $uncompressCmd = '';
	my $ext = '';
    if ( $ENV{'NUI_ARCH'} =~ /linux/ )  {	   
	$uncompressCmd = "gunzip";
	$compr .= "| gzip -c -f ";
	$ext = '.gz';
    } else {
	$compr .= "| compress -c -f -b 12 ";
	$uncompressCmd = "uncompress";
	$ext = '.Z';
    }
    if   ($tazName eq "jvm_patch.diff") {
	$filep = "$eclipse_path/$tazName";
    }
  if ( $ctx->{fix_type}  eq "revert") {
	#remove plugins and unzip old file
	if ( -f  "$target_backupdir/$tazName" ) {
	    chdir ("$eclipse_path") or warn "Can't change to $eclipse_path:$!";
	    $self->SysCmd("rm -rf  $sDir");  #OK  on revert
	    $self->SysCmd("mkdir   $sDir");
	    chdir ("$eclipse_path/$sDir") or warn "Can't change to $eclipse_path/$sDir:$!";
	    $self->SysCmd("mv $target_backupdir/$tazName  .") or warn "Can't move $tazName from $target_backupdir  $!";
	    $uncompr = "cat $tazName | $uncompressCmd -c | $Sys::tar xvf -";
	    $dbg && print "    extract cmd: $uncompr\n";
	    $dbg && print "    extracting " . `date`;
	    $out = `$Sys::sh -c "$uncompr" 2>&1`;
	    $stat = ($? >> 8);
	    if ($dbg) {
		print "    stat: $stat\n";
		print "    out: $out";
	    }
	  
	   
	    if ($stat) {
		$$rMsg .=  "$out\n";
		$ret = 0;
		return 0;
				    }
	    else { 
		if ($perm eq 1) {
		    $self->SysCmd("chmod -R 755 .");
		    $self->SysCmd("chown -R 0:2 .");
		}
		else {
		    $group = $ctx->{data_directories}->{$dPath}->{data_UNIX_group};
		    $user = $ctx->{data_directories}->{$dPath}->{data_UNIX_user};
		    system("find $eclipse_path -follow ! \\( -user $user -o -group $group \\) | xargs chown -Rh $user:$group");
		    system(" find  $eclipse_path  -follow !  -perm 755 |xargs chmod 755");
		}
		#delete  old zip on upgrade after unzip
		$self->SysCmd("$Sys::rm -f  $tazName");					    
		return 1;
	    }
	}
	
    }
    else {
  	if (-f $filep) { #upgrade 
	    #create base_backup directory
	    if ($tazName ne "jvm_patch.diff") {
		 #save new osgi or other taz				
		$self->SysCmd("mv $filep $eclipse_path") or warn "Can't move $filep to $eclipse_path$!";
	    }
	    if (! -d $base_backupdir){	   
		if (!mkdir $base_backupdir, 0755) {
		    $$rMsg .= "Can't mkdir $base_backupdir: $!";
		    $ret = 0;
		    return 0; 
		}
	    }

		if ( ! ( ($tazName eq "jvm_patch.diff") && ($base_backupdir eq $gold_base_backupdir) && (-f "$gold_base_backupdir/$tazName") ) ) {		
			chdir ("$eclipse_path/$sDir") or die "Can't change to $eclipse_path/$sDir :$!";
			#first tar/compress existing plugins (we are in eclipse/plugins or  jvm)
			if ( $tazName eq "jvm_patch.diff" ) {
				# Notes.jar already been new version, we should compress base version
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/Notes.jar $eclipse_path/Notes.jar.tmp");
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/$ctx->{base_version}/Notes.jar $eclipse_path/jvm/lib/ext/Notes.jar");
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/njempcl.jar $eclipse_path/njempcl.jar.tmp");
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/$ctx->{base_version}/njempcl.jar $eclipse_path/jvm/lib/ext/njempcl.jar");
			}
			$compr .= " > $base_backupdir/$tazName"; #this is gold backup taz
			my $out = `$compr`;
			$stat = ($? >> 8);
			if ($dbg) {
				print "    stat: $stat\n";
				print "    out: $out";
			}
			if ($stat) {					
				$$rMsg .= "Can't compress existing $sDir\n";
				$ret = 0;
				return 0;
			}
			if ( $tazName eq "jvm_patch.diff" ) {
				$self->SysCmd("mv $eclipse_path/Notes.jar.tmp $eclipse_path/jvm/lib/ext/Notes.jar");
				$self->SysCmd("mv $eclipse_path/njempcl.jar.tmp $eclipse_path/jvm/lib/ext/njempcl.jar");
			}
		}
		
	    chdir ("$eclipse_path") or warn "Can't change to $eclipse_path:$!";
	    if ($tazName eq "jvm_patch.diff") { #apply patch
		
			# first backup these files since they may be overwritten 
			if ( -f "$eclipse_path/jvm/lib/security/java.pol" ) {
				$self->SysCmd("cp $eclipse_path/jvm/lib/security/java.pol $eclipse_path/java.pol.tmp");
			}
			if ( -f "$eclipse_path/jvm/lib/ext/Notes.jar" ) {
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/Notes.jar $eclipse_path/Notes.jar.tmp");
			}
			if ( -f "$eclipse_path/jvm/lib/ext/websvc.jar" ) {
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/websvc.jar $eclipse_path/websvc.jar.tmp");
			}
			if ( -f "$eclipse_path/jvm/lib/ext/njempcl.jar" ) {
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/njempcl.jar $eclipse_path/njempcl.jar.tmp");
			}
			if ( -f "$eclipse_path/jvm/lib/ext/xsp.http.bootstrap.jar" ) {
				$self->SysCmd("cp $eclipse_path/jvm/lib/ext/xsp.http.bootstrap.jar $eclipse_path/xsp.http.bootstrap.jar.tmp");
			}
			

		# before apply JVM first revert to gold JVM
		if ( -f  "$gold_base_backupdir/$tazName" ) {
			chdir ("$eclipse_path") or warn "Can't change to $eclipse_path:$!";
			$self->SysCmd("rm -rf  $sDir");  #OK  on revert
			$self->SysCmd("mkdir   $sDir");
			chdir ("$eclipse_path/$sDir") or warn "Can't change to $eclipse_path/$sDir:$!";
			$self->SysCmd("cp $gold_base_backupdir/$tazName  .") or warn "Can't move $tazName from $gold_base_backupdir  $!";
			$uncompr = "cat $tazName | $uncompressCmd -c | $Sys::tar xvf -";
			$dbg && print "    extract cmd: $uncompr\n";
			$dbg && print "    extracting " . `date`;
			$out = `$Sys::sh -c "$uncompr" 2>&1`;
			$stat = ($? >> 8);
			if ($dbg) {
			print "    stat: $stat\n";
			print "    out: $out";
			}
			if ($stat) {
				$$rMsg .=  "$out\n";
				$ret = 0;
				return 0;
			}
			else { 
				#delete  old zip on upgrade after unzip
				$self->SysCmd("$Sys::rm -f  $tazName");					    
			}
		}
		# revert to gold jvm if current jvm is udpated by JVM patcher
		$jvmpatcher_jvm_backup = "jvm_bck.tar".$ext;
		if ( -f  "$eclipse_path/$sDir/$jvmpatcher_jvm_backup" ) {
			$self->SysCmd("mv $eclipse_path/$sDir/$jvmpatcher_jvm_backup $eclipse_path");		
			chdir ("$eclipse_path") or warn "Can't change to $eclipse_path:$!";
			$self->SysCmd("rm -rf  $sDir");  #OK  on revert
			$self->SysCmd("mkdir   $sDir");
			chdir ("$eclipse_path/$sDir") or warn "Can't change to $eclipse_path/$sDir:$!";
			$self->SysCmd("mv $eclipse_path/$jvmpatcher_jvm_backup .") or warn "Can't move $jvmpatcher_jvm_backup from $eclipse_path  $!";
			$uncompr = "cat $jvmpatcher_jvm_backup | $uncompressCmd -c | $Sys::tar xvf -";
			$dbg && print "    extract cmd: $uncompr\n";
			$dbg && print "    extracting " . `date`;
			$out = `$Sys::sh -c "$uncompr" 2>&1`;
			$stat = ($? >> 8);
			if ($dbg) {
			print "    stat: $stat\n";
			print "    out: $out";
			}
			if ($stat) {
				$$rMsg .=  "$out\n";
				$ret = 0;
				return 0;
			}
			else { 
				#delete  old zip on upgrade after unzip
				$self->SysCmd("$Sys::rm -f  $jvmpatcher_jvm_backup");					    
			}
		}
		
			if ( -f "$eclipse_path/Notes.jar.tmp" ) {
				$self->SysCmd("mv $eclipse_path/Notes.jar.tmp $eclipse_path/jvm/lib/ext/Notes.jar");
			}
			if ( -f "$eclipse_path/websvc.jar.tmp" ) {
				$self->SysCmd("mv $eclipse_path/websvc.jar.tmp $eclipse_path/jvm/lib/ext/websvc.jar");
			}
			if ( -f "$eclipse_path/njempcl.jar.tmp" ) {
				$self->SysCmd("mv $eclipse_path/njempcl.jar.tmp $eclipse_path/jvm/lib/ext/njempcl.jar");
			}
			if ( -f "$eclipse_path/xsp.http.bootstrap.jar.tmp" ) {
				$self->SysCmd("mv $eclipse_path/xsp.http.bootstrap.jar.tmp $eclipse_path/jvm/lib/ext/xsp.http.bootstrap.jar");
			}
		
	    chdir ("$eclipse_path") or die "Can't change to $eclipse_path:$!";		
		# apply the patch
		$jvmtool = CdPath::CdPath("tools/lib/JVMTool.jar");
		if($dbg){
		    system("\"jvm/bin/java\" -jar $jvmtool src=jvm dst=jvm_dst diff=jvm_patch.diff -v -show=patchlist") &&
			warn "patching failed: $!";
		}
		else{
		    system("\"jvm/bin/java\" -jar $jvmtool src=jvm dst=jvm_dst diff=jvm_patch.diff -v out=jvmpatcher.log -show=patchlist") && warn "patching failed: $!";	    
		}
		# presumably success
		open(JVMPATCHLOG,"<jvmpatcher.log" ) or warn "Can't open jvmpatch.log:$!";
		my @patchloglines = <JVMPATCHLOG>;
		close JVMPATCHLOG;
		$patch_success = grep (/patch successful/, @patchloglines);
		if ($patch_success ) {
		    
#		if ( -d "jvm_dst") {
		    $self->SysCmd("chmod -R 777 $sDir");
		    $self->SysCmd("$Sys::rm -rf jvm") || warn "Can't remove jvm directory";
		    $self->SysCmd("mv jvm_dst jvm") || warn "Can't move jvm_dst to jvm";
			
			if ( -f "$eclipse_path/java.pol.tmp" ) {
				$self->SysCmd("mv $eclipse_path/java.pol.tmp $eclipse_path/jvm/lib/security/java.pol");
			}
			
		}
		else {
		    warn("jvm patch was not applied, please check jvmpatcher.log for details");
		    if ( -d "jvm_dst") {				
			$self->SysCmd("$Sys::rm -rf jvm_dst") || warn "Can't remove jvm_dst directory";	
		    }
		}
	    }
	    else {			    		
		#then remove current plugins directory
		#$self->SysCmd("rm -rf  $sDir"); # need to leave nl* files in place

		%HasNLFiles = ();
		find(\&purge_notNLfiles,"$eclipse_path/$sDir"); #only remove files first
		find(\&purge_emptydirs,"$eclipse_path/$sDir"); #remove empty directories first
		$self->SysCmd("mkdir   $sDir");				
		#then restore and uncompress the new file
		$self->SysCmd("mv $eclipse_path/$tazName $eclipse_path/$sDir");
		chdir ("$eclipse_path/$sDir") or warn "Can't change to $eclipse_path/$sDir:$!";
		$uncompr = "cat $tazName | $uncompressCmd -c | $Sys::tar xvf -";
		$dbg && print "    extract cmd: $uncompr\n";
		$dbg && print "    extracting " . `date`;
		$out = `$Sys::sh -c "$uncompr" 2>&1`;
		$stat = ($? >> 8);
		if ($dbg) {
		    print "    stat: $stat\n";
		    print "    out: $out";
		}
		if ($stat) {
		    $$rMsg .=  "$out\n";
		    $ret = 0;
		    return 0;
		}
	    }

 	    if ($perm eq 1) {
		chdir ("$eclipse_path") or warn "Can't change to $eclipse_path :$!";
		$self->SysCmd("chmod -R 755 $sDir");
		$self->SysCmd("chown -R 0:2 $sDir");
	    }
	    else {
		$group = $ctx->{data_directories}->{$dPath}->{data_UNIX_group};
		$user = $ctx->{data_directories}->{$dPath}->{data_UNIX_user};
		system("find $eclipse_path -follow ! \\( -user $user -o -group $group \\) | xargs chown -Rh $user:$group");
		system(" find  $eclipse_path  -follow !  -perm 755 |xargs chmod 755");
	    }
	    #delete/backup current zip on upgrade after unzip
	  #  $self->SysCmd("$Sys::rm -f  $tazName");
	    $self->SysCmd("$Sys::rm -f  $filep");
	    return 1;
	}  
    }
    return 1;
}
sub purge_notNLfiles {
    my $fname = $File::Find::name;
    my $fdir = $File::Find::dir;
    return if (($fname eq'.') || ($fhame eq '..'));
    return if ($fname eq $fdir);
    return unless ( ! -l);
#    print "fdir = $fdir\n";
#    return if ($HasNLFiles{$fdir} eq 1);
    if ($fname =~ /jvm\/lib\/ext/) {
	$HasNLFiles{$fdir} = 1;
	return; # nothing removed from jvm/lib/ext
    }
    if ($fname =~ /\.nl\d/) {
	$HasNLFiles{$fdir} = 1;
#	print "$fdir has NL files\n";
	return;
    }
    if  ( -d $fname) {
	return;
    }
    else {
	$self->SysCmd("rm $fname");
    }
#    if ( (-d $fname)  && ($fname =~  /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d$/) ) { #problem with duplicate directory
#	$self->SysCmd("$Sys::rm -rf  $fname");	
#    }
#    else {
#	$self->SysCmd("rm $fname");
#    }
}
sub purge_emptydirs {
    my $fname = $File::Find::name;
    my $fdir = $File::Find::dir;
    my $found_file = 0;
    return if (($fname eq'.') || ($fhame eq '..'));
    return if ($fname eq $fdir);
    return unless ( ! -l);
     
    if  ( ! -d $fname) {
	return;
    }
    if ($HasNLFiles{$fname} eq 1) {
#	print " Not purging $fname:  has NL files\n";
	return; #not empty
    }
    foreach $mk (keys %HasNLFiles) {
	# our subdirectory contains nl file
	if (($HasNLFiles{$mk} eq 1) && ($mk =~ /^$fname/)){
#		print " Not purging $fname:  has NL files\n";
	    return; #not empty
	}
    }
    	
    $self->SysCmd("$Sys::rm -rf  $fname");	
#		print " Removed  $fname\n";

 
}
sub GetCfgSummary {
    local($self, $ctx) = @_;

	local($out) = "";
	local($_, $ddir, @ddirs);
#	local($setupTypes) = $self->{cdf}->GetSetupTypeList();

	local($host) = $ctx->{targetHost};
	if ($host eq "localhost") {
		$host = `$Sys::hostname`;
		chomp($host);
	}

	if ($host) {
		# Installation settings for host ...
	#        $nicctx->{installation_inotes} = $ctx->{installation_inotes};
		$out = "$txt{3.1}$host$txt{3.2}";
	} else {
		# Installation settings:
		$out = "$txt{3.3}";
	}

	if ($ctx->{add_data_directories_only}) {
		$out .= "$txt{10.1}";
	}

#	$out .= 
#	    "$txt{4.1}$setupTypes->[$ctx->{installation_type}]$txt{4.2}";

    if ( !$ctx->{kitArch}  ) {
        $ctx->{kitArch} = GetOSNameFromTargetMachine();
    }
    if(!$ctx->{kitArch} && $ENV{NUI_ARCH} ) {
	$ctx->{kitArch} = $ENV{NUI_ARCH};
    }

#        if($ctx->{kitArch} eq "solx86" ) {
#	    $out .= "$txt{4.17}$txt{5.3}: $ctx->{kitArch}$txt{4.2}";
#        } elsif ($ctx->{kitArch} eq "sol" || $ctx->{kitArch} eq "aix" ) {
#	    if( $ctx->{installation_inotes} ) {
#		$out .= "$txt{4.17}$txt{4.18}$txt{4.2}";
#	    } else {
#		$out .= "$txt{4.17}$txt{4.19}$txt{4.2}";
#	    }
#	} else {
#	    $out .= "$txt{4.17}$txt{5.3}: $ctx->{kitArch}$txt{4.2}";
#	}

	$out .= "$txt{4.3}$ctx->{program_directory}$txt{4.4}";

	if (scalar(keys(%{$ctx->{data_directories}})) == 1) {
		$ddir = (keys(%{$ctx->{data_directories}}))[0];
		$out .= 
			$txt{'4.5'} .
			$ddir .
			$txt{'4.6'} .
			$txt{'4.11'} .
			$ctx->{data_directories}->{$ddir}->{data_UNIX_user} .
			$txt{'4.12'} .
			$txt{'4.13'} .
			$ctx->{data_directories}->{$ddir}->{data_UNIX_group} .
			$txt{'4.14'};
	} else {
		@ddirs = sort(keys(%{$ctx->{data_directories}}));
		$ddir = shift(@ddirs);

		$out .= 
			$txt{'4.7'} .
			$ddir .
			$txt{'4.8'} .
			$txt{'4.11'} .
			$ctx->{data_directories}->{$ddir}->{data_UNIX_user} .
			$txt{'4.12'} .
			$txt{'4.13'} .
			$ctx->{data_directories}->{$ddir}->{data_UNIX_group} .
			$txt{'4.16'};

		foreach $ddir (@ddirs) {
			$out .=
				$txt{'4.9'} .
				$ddir .
				$txt{'4.10'} .
				$txt{'4.15'} .
				$ctx->{data_directories}->{$ddir}->{data_UNIX_user} .
				$txt{'4.16'} .
				$txt{'4.15'} .
				$ctx->{data_directories}->{$ddir}->{data_UNIX_group} .
				$txt{'4.16'};
		}
		$out .= $txt{'4.16'};

    }
    if (! (defined ($ctx->{nuicfg}->{nsdfix}) )  &&  ! (defined ($ctx->{nuicfg}->{customfix}) ) &&  ! (defined ($ctx->{nuicfg}->{saasfix}) )   ) {
	if (defined ($ctx->{fix_type})   ) {
	    $out .= $ctx->{base_version}." ". $ctx->{fix_type}.
		$txt{'4.20'}.$ctx->{target_version}."\n";
	}
    }
    else { #NSD upgrade or revert
	foreach $filename (keys %{$ctx->{nuicfg}->{$ctx->{rev}}}){
	    $base_checksums{$filename} = 
		$ctx->{nuicfg}->{$ctx->{rev}}->{$filename}->{checksum};
	}

	# for nsd fix we must figure out if that's upgrade or revert by comparing checksums:
	# if what's installed has base checksum: it's upgrade, if target - it's revert
	foreach $fname (keys %base_checksums) {
	    ($fname1 = $fname) =~ s/<NOTESPROGDIR>//;	  
	    $nsdpath = $ctx->{pPath}.'/'.$fname1;
	    $curr_nsdchecksum = GetChecksum($err_msg, $nsdpath);
	    if ($curr_nsdchecksum  == $base_checksums{$fname} ) {
		$ctx->{fix_type} =  'upgrade';
	    }
	    else {
		$ctx->{fix_type} = 'revert';
	    }
	    last;
	}
	if ($ctx->{fix_type} eq "upgrade") {
	    $target_rev = StringsRes::GetShortVersion($ctx->{nuicfg}->{fix_stringsres});
	    if (defined ($ctx->{nuicfg}->{nsdfix})  ) {
		$out .= "NSD $ctx->{fix_type} to NSD $target_rev";
	    }
	    else {
		$out .= "Custom fix  $ctx->{fix_type} to Custom fix  $target_rev";
	    }
	}
	else {
	    if (defined ($ctx->{nuicfg}->{nsdfix})  ) {
		$out .= "NSD $ctx->{fix_type} to NSD $ctx->{rev}";
	    }
	    else {
		$out .= "Custom fix  $ctx->{fix_type} to Custom fix $ctx->{rev}";	
	    }
	 }
    }
    return $out;
}


sub GetComponentDestinationData {
	local($self, $ctx, $outList, $outHash) = @_;

	# in:			(self)
	# out:		\@outlist: ref to unique list of destination paths for 
 	#				all comps to be installed
	#			\%outHash: ref to hash of comp lists by dest paths
	# returns:	nothing


	local($comps, $comp);
	local($destPath, $ddir);
	local(@dataComps) = ();
	local(%outListAlreadyHash) = ();

	@{$outList} = ();
	%{$outHash} = ();

 
	$comps = $ctx->{components};

	foreach $comp (@{$comps}) {
		if ($self->IsTargetDataDir($comp)) {
			push(@dataComps, $comp);

		} elsif (! $ctx->{add_data_directories_only}) {
			$destPath = $self->ExpandTarget($comp);

			$outListAlreadyHash{$destPath} || push(@{$outList}, $destPath);
			$outListAlreadyHash{$destPath} = 1;
			if (!defined($outHash->{$destPath})) {
				$outHash->{$destPath} = [];
			}
			push(@{$outHash->{$destPath}}, $comp);
		}
	}

	@ddirs = sort(keys(%{$ctx->{data_directories}}));
	foreach $ddir (@ddirs) {
		foreach $comp (@dataComps) {
			$destPath = $self->ExpandTarget($comp, $ddir);
			
			$outListAlreadyHash{$destPath} || push(@{$outList}, $destPath);
			$outListAlreadyHash{$destPath} = 1;
			if (!defined($outHash->{$destPath})) {
				$outHash->{$destPath} = [];
			}
			push(@{$outHash->{$destPath}}, $comp);
		}
	}
}


sub IsTargetDataDir {
	local($self, $comp) = @_;
	
	$target_dir = $self->{cdf}->{data}->{$comp};
	return ($target_dir =~ /^\s*<NOTESDATADIR>/);

	#	($self->{cdf}->GetSection($comp)->GetValue("TARGET") =~ 
#	    ($self->{cdf}->{$comp} =~
#			/^\s*<NOTESDATADIR>/);
}


sub ExpandTarget {
	local($self, $comp, $basepath) = @_;

	# $basepath required only for data dir

	# this is the one and only place where targets are expanded 
	# to the actual destination path
	# ExpandTargetByRev() below is similar, but used only for 
	# the progdir of an existing install.

	local($target, $dest);

#	$target = $self->{cdf}->GetSection($comp)->GetValue("TARGET");
	$target = $self->{cdf}->{data}->{$comp};
	if ($self->IsTargetDataDir($comp)) {
            $dest = $target;
            $dest =~ s|\s*<NOTESDATADIR>|$basepath|;
            $dest =~ s|\\|/|g;
	} else {
            $dest = $target;
            $dest =~ s|\s*<NOTESPROGDIR>|$ctx->{pPath}|;
            $dest =~ s|\\|/|g;
	}

	return $dest;
}


sub ExpandTargetByRev {
	local($self, $comp, $rev) = @_;

	# used only for existng install

	local($target, $dest, $path);

	$pPath = 
		"$ctx->{ptPath}/notes/$rev/$self->{archMnemMap}->{$ctx->{kitArch}}";
#	$target = $self->{cdf}->GetSection($comp)->GetValue("TARGET");
	$target = $self->{cdf}->{data}->{$comp};
	$dest = $target;
	$dest =~ s|\s*<NOTESPROGDIR>|$pPath|;
	$dest =~ s|\\|/|g;

	return $dest;
}


sub GetDataDirSubDirs {
	local($self) = @_;

	local($comp, $subdirs, $subdir, %outhash);

	foreach $comp (@{$ctx->{components}}) {
		if ($self->IsTargetDataDir($comp)) {
			$subdir = $self->{cdf}->GetSection($comp)->GetValue("TARGET");
			$subdir =~ s|\\|/|g;
			$subdir =~ s/^<NOTESDATADIR>//;
			$subdir =~ s/^\///;
			$subdir =~ s/^\s*//;
			$subdir =~ s/\s*$//;
			if ($subdir) {
				foreach $subdir ($self->GetParentDirs($subdir)) {
					$outhash{$subdir} = 1;
				}
			}
		}
	}

	return keys(%outhash);
}


sub GetParentDirs {
        local($self, $path) = @_;
	local($c, @c, $outpath, @outdirs);

	@c = split(/\//, $path);
	foreach $c (@c) {
		$outpath .= "/$c";
		$outpath =~ s/^\///;
		push(@outdirs, $outpath);
	}
	
	return @outdirs;
}
sub WriteCtxFile {
    local $ctx = shift;    
    local(*CTXFILE);
    
    if ( ! open(CTXFILE, ">$ENV{NUI_CFGFILE}")) {
	# diagnostic message - should never happen
        print "WriteContext failure:\n$!";
        return 0;
    }
    if (defined ($ctx->{nuicfg} ) ) {
	foreach $key (keys %{$ctx->{nuicfg} } )  {
	    if ((!defined $key )  || $key eq '') {
		undef $ctx->{nuicfg}->{$key};
	    }
	}	
    }
    local($cfgData) = new CfgData ();
    local($ctxString) = $cfgData->GenCfgFromHashRef($ctx);   
    if ($ctxString =~ /cfp_lp_/) {
	if ($ctxString  !~ /\"Release/) {	    
	    $ctx_String =~ s/\"//g;
	}
    }
    print CTXFILE $ctxString;
    
    if ( ! close(CTXFILE)) {
	# diagnostic message - should never happen
	print "WriteContext failure:\n$!";
        return 0;
    }
    return 1;
}

sub UpdateVersion {

    local($newVersion,$fname,$koption) = @_;
    if ((!defined $newVersion) or ((length $newVersion) < 0)) {	
	die "NIC.pm Attempting to write strings.res but new Version has not been supplied";
    }
    if (!defined $fname) {
	die "NIC.pm Attempting to write strings.res but stringsres filename has not been supplied";
    }
    
    if ((!defined $koption) or ($koption ne 'UseCompleteString')){
	$kdate = 'November 5, 2002 '; 
	$newMsg = "Release ".$newVersion." \|".$kdate;
    } else {
		$newMsg = $newVersion;
	    }
    
    @resInput = ($fname,'1','write',$newMsg);
    $rtnMsg = StringsRes::DoStringsRes(@resInput);
    return $rtnMsg;
}




sub GetOSNameFromTargetMachine {
    local ($self) = @_;    
    local $NUI_ARCH="";
    local $osname;

    $osname = `$Sys::uname`;
    $osname =~ s/\n//;
    $NUI_ARCH = $osname;

    if ( $osname eq "AIX" ) {
	$NUI_ARCH = "aix";
    } 
    elsif ($osname eq "Linux") { 
 	$osname = `$Sys::uname -m`;
	$osname =~ s/\n//;
	$NUI_ARCH="linux";
	} 

#    setenv NUI_ARCH
    `$Sys::export $NUI_ARCH`;
    

#    print "GetOSNameFromTargetMachine:   $NUI_ARCH";
    return $NUI_ARCH;
}

sub zap_empty_dir{

    if (!defined($seen{$File::Find::dir})){
#	print "Searching $File::Find::dir\n";
	$seen{$File::Find::dir} = 1;
    }
    
    if ( -f || -l)  {
	$dir_hash{$File::Find::dir} = 1;
    }
    elsif ( -d ) {
	#we already saw this directory 
	# (since we started from the bottom up)
        # and it was empty
	if ($dir_hash{$name} == 0){
	    local($dodir) = $_ ;

	    if ( ! IsThisMountPoint($dodir)){
		$_ = $dodir ;
	 #   print "Removing $name\n";
	    rmdir($_) or print ("couldn't rmdir $_: $!\n");
	    }
	}
	elsif ($dir_hash{$name} == 1){
	    # child directory has some files
	    $dir_hash{$File::Find::dir} = 1;
	}
    }
    else{
	$dir_hash{$File::Find::dir} = 0;
	print "$File::Find::dir empty\n";
    }
    
	
}

sub IsThisMountPoint {

    local ($whdir) = @_;
    local ($pwdout,@dfout);

    local($currdir) = `$Sys::pwd`;
    chomp($currdir);

    if ( $ENV{'NUI_ARCH'} eq "os390") {
	chdir($whdir) || die;
	$pwdout = `$Sys::pwd`;
	chomp($pwdout);
	local($_);
	$_ = `df -k . 2>&1`;
	@dfout = split(/\n/);
	@dfout = split(/[ \t]+/, $dfout[1]);

	chdir($currdir) || die;  #return current dir to where it was.

	if ($pwdout eq @dfout[0]) {
		# YES this is a mount point
		return 1;
	}
    }

}
sub FindStrings {
    my $pPath = shift;
    if (defined ($ctx->{pPath})) {
	$pPath = $ctx->{pPath};
    }
   if (
        (! $ENV{'LANG'}) ||
        ($ENV{'LANG'} =~ /^posix$/i) ||
        ($ENV{'LANG'} =~ /^en_us/i) ||
        ($ENV{'LANG'} =~ /^en_GB/i)
  			            ) {
        $langpath = "res/C";
    } else {
             $langpath = "res/$ENV{'LANG'}";
    }
#    $strings_file = $ctx->{pPath}."/".$langpath."/strings.res";
     $strings_file = $pPath."/".$langpath."/strings.res";
    if (-f $strings_file){
  #    print "FindStrings: returning $strings_file\n";
      return $strings_file;
    }
    else{
	undef $strings_file;
    }  
  #  return unless ($File::Find::name =~ /strings\.res$/); 
  #  $strings_file = $File::Find::name;
   
} 

sub FindBackup {
   
    my $filepath = shift;
    my($dest, $filename, $shortname);
    my ($bckup, $progname, $dataname, $found_bckup, $err_msg);
    my %target_files = ();
    my @other_backups =  ();
    my $file_defined = 0;
 if (!defined ($ctx->{nuicfg}->{nsdfix})  &&  !defined ($ctx->{nuicfg}->{customfix} ) &&  !defined ($ctx->{nuicfg}->{saasfix} ) )   {  
     if (defined ($ctx->{backup}) ){
	 $dest = $ctx->{backup}->{$filepath}->{$ctx->{target_version}};
	 @other_backups = keys %{$ctx->{backup}->{$filepath}};
     }
     else {
	 $dest = $backup{$filepath}->{$ctx->{target_version}};
	 @other_backups =  keys %{$backup{$filepath}};
     }
 }
    else { # for nsd/custom fixes backup is always for the  base release
	$dest = $backup{$filepath}->{$ctx->{base_version}};
	 @other_backups =  keys %{$backup{$filepath}};
    }
#    $dest = $ctx->{backup}->{$filepath}->{$ctx->{base_version}};
    $filename = `$Sys::basename $filepath`;		   
    chomp($filename);
    $shortname = $filename;
    
    # print "FindBackup :other_backups for $filepath : @other_backups\n";
    $progname = "<NOTESPROGDIR>".$shortname;
    $dataname = "<NOTESDATADIR>".$shortname;
    $file_prev = "";
    $filename = $dest ."/".$filename;
    # print "Findbackup filename: $filename\n";

    if ( $shortname =~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d(.*)jar/) {
		# jchfeng:  For OSGI jar files, it will be reverted in PostInstallProcessing   2014/07/17
		return [1,0];
		
	$file_prev = "";
	$tmstmp = qw(\\d\\d\\d\\d\\d\\d\\d\\d\(-|_\)\\d\\d\\d\\d); 
	($filetmp = $shortname) =~ s/(.*)\d\d\d\d\d\d\d\d(-|_)\d\d\d\d(.*)jar/$1\.jar/;
	$file_regexp = $1."\\d\\d\\d\\d\\d\\d\\d\\d(-|_)\\d\\d\\d\\d".$3."jar";
	$file_prev = GetExisting($dest,$file_regexp );
	$rename{$shortname} = $file_prev;
	$filename = $dest ."/".$file_prev;
    }
    if (!(-e $filename)){

	#first check program or data directory - in case it was restored already
        if ( -e $filepath){
	    if (defined ($ctx->{nuicfg}->{$ctx->{target_version}} ) ) {
		foreach $item (keys %{$ctx->{nuicfg}->{$ctx->{target_version}}}){
		    $target_files{$item} = 1;
		}
	    }
	    if (defined $target_files{$progname}){
		if (defined ($ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum} ) ) {
		    if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum} eq 0) {
			return [-1,$filepath];
		    }
		}
	    }
	    if (defined $target_files{$dataname}) {
		if (defined ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum} ) ) {
		    if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum} eq 0) {
			return [-1,$filepath];
		    }
		}
	    }
        	local $chks =  GetChecksum ($err_msg, $filepath);
        	#check the checksum of the file in the original directory
        	# print " Searching for filename  =  $filename  checksum = $chks in program dir\n";
		$file_defined = 0;
	    if (defined $target_files{$progname}){
		if (defined ( $ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum} ) )  {		    
		    if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum}
			== GetChecksum ($err_msg, $filepath)){
			
			#	print "Found $filepath in program directory\n";
			if (defined ($ctx->{nuicfg}->{customfix} ) ) { # there was no_file and we need to delete the one that exists
			    if ($ctx->{fix_type} eq "revert") {
				return [-1,0];
			    }
			}
			$found_bckup = 1;
			return [$found_bckup, 0]; # no need to restore, already restored
		    }                	
		    else {
			#	print "$filepath has wrong checksum \n";
			if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum} eq 0) {
			    return [-1,0];
			}			    
			$file_defined = 1; 
			#    return [0,0];
		    }
		}
		else {
		    $file_defined = 1; 
		}
	    }
        	# print " Searching for filename  =  $filename  checksum = $chks in data directory\n";
        	if (defined $target_files{$dataname}) {
		    if (defined ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum} ) ) {
			if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum} == GetChecksum ($err_msg, $filepath)) {
			    #  	print "Found $filepath in data directory\n";
			    $found_bckup = 1;
			    return  [$found_bckup, 0]; # no need to restore, already restored
			}
			else {
			    if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum} eq 0) {
				return [-1,0];
			    }
			    $file_defined = 1;
			    #	return [0,0];
			}
		    }
		    else {
			$file_defined = 1;	
		    }
	}
	if ($file_defined != 1){
#		print "File exists in the program or data directory but checksum not defined in nui.cfg\n";
	    return [1,0];
	}		
	else {
	    $file_defined = 0;
	}
	    }
        # finished checking current program and data directories - file not defined in the current nui.cfg
        # Now check backups - first valid - first restored 
	foreach $bckup (@other_backups){
	     %target_files = ();
	    #  print "Looking in $bckup for file $filepath\n";
	     if (defined $ctx->{nuicfg}->{$bckup}){
		 foreach $item (keys %{$ctx->{nuicfg}->{$bckup}}){
		     $target_files{$item} = 1;
		 }
	     }
	     if (defined ($ctx->{backup}) ){
		 $filename = $ctx->{backup}->{$filepath}->{$bckup} ."/".$shortname;
	     }
	     else {
		 $filename = $backup{$filepath}->{$bckup}."/".$shortname;
	     }
	    next unless (-e $filename); #we found backup now check checksum
	     # if target data or program checksums were not defined - file was not replaced

	     if ( defined $target_files{$progname} ) {
		 if (defined ($ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum} ) ) {
		     if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum}
			 == GetChecksum ($err_msg, $filename)) {
			 $found_bckup = 1;
			 #    print "$filename progname checksum for $bckup is correct\n";
			 return  [$found_bckup, $filename];
		     }
		 }
	     }
	   if ( defined $target_files{$dataname} ) {
	       if (defined ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum} ) ) {
		   if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum}
		       == GetChecksum ($err_msg, $filename)){
		       $found_bckup = 1;
		       #     print "$filename dataname checksum for $bckup is correct\n";
		       return  [$found_bckup, $filename];
		   }
	       }
	   }
	}
	
    }
    else { #if this file exists in the right backup directory - restore it
#       print "Found backup: $filename for target version $ctx->{target_version}\n";
	if (($filename =~ /n[ts]f$/) ||	    
	    ($filename =~ /libndgts/) ||
	    ($filename =~ /nsd.sh/) ||
	    ($filename =~ /libigif/) ||
	    ($filename =~ /\d\d\d\d\d\d\d\d(-|_)\d\d\d\d/) ) {
	    $found_bckup = 1;
	    return [$found_bckup, $filename];	    
	}
	undef $cks;
	 if (!defined ($ctx->{nuicfg}->{nsdfix})  && !defined ($ctx->{nuicfg}->{customfix}) && !defined ($ctx->{nuicfg}->{saasfix}) )   {  
	     if (defined $ctx->{nuicfg}->{$ctx->{target_version}}->{$progname} ) {
		 $cks = $ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum};
	     }
	 }
	else { # for nsd fix backup is in the base directory always
	    if (defined $ctx->{nuicfg}->{$ctx->{base_version}}->{$progname} ) {
		$cks = $ctx->{nuicfg}->{$ctx->{base_version}}->{$progname}->{checksum};
	    }
	}
        if ( defined $cks) { 
	#	if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$progname}->{checksum}
	    if ($cks   == GetChecksum ($err_msg, $filename)){
		#	print "Checksum is correct\n";
		$found_bckup = 1;
		return [$found_bckup, $filename];
		}
		else {
                #      print "Checksum is wrong\n";
		    if ($ENV{NUI_NOCHECKSUM}){
			$found_bckup = 1;
        		return [$found_bckup, $filename];
		    }
		    else{
			return [0,0];
		    }
                }

	}
	else {
	    undef $cks;
	    if (defined $ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname} ){
		$cks = $ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum};
	    }
	    if ( defined $cks) {
		if ($ctx->{nuicfg}->{$ctx->{target_version}}->{$dataname}->{checksum}
		    == GetChecksum ($err_msg, $filename)){
		    # 		print "Checksum is correct\n";
                		$found_bckup = 1;
                		return [$found_bckup, $filename];
			    }
                	else {
			    #      		print "Checksum is wrong\n";
			    if ($ENV{NUI_NOCHECKSUM}){
				$found_bckup = 1;
				return [$found_bckup, $filename];
			    }
			    else{
				return [0,0];
			    }			    
                        } 
	    }
	    #not defined in the current nui.cfg - assumed correct
	    #      print "File exists in the backup directory -  checksum not defined in current nui.cfg - restored\n";    
	    return [1,$filename];
	}	
    }
   if (!$found_bckup) {
        #it's not defined in the nuicfg (and not present in any of the backup directories)
        #  print "$filepath not defined in the current nui.cfg and not present in the backup dir - assumed correct\n";
	return [1,0];
    }
}
sub SetOwnershipPermissions{ 
    #
    # set ownership and (generic) permissions for each file installed
    #
    local($comp, $ddir, $dest, $inv, $invfile, $compstring);


    #
    # set ownership and permissions of data dir subdirs
    # and ntf's & nsf's
    #
    local($path, $subdirs, $subdir);
    @ddirs = sort(keys(%{$ctx->{data_directories}}));
    foreach $ddir (@ddirs) {
	foreach $subdir ("", "domino/adm-bin", $self->GetDataDirSubDirs()) {
	    $path = "$ddir/$subdir";
	    chown(
		  $ctx->{data_directories}->{$ddir}->{data_UNIX_uid},
		  $ctx->{data_directories}->{$ddir}->{data_UNIX_gid},
		  $path);
	    chmod(0755, $path);
	    
	    chdir($path);
	    $self->SysCmd("$Sys::chown $ctx->{data_directories}->{$ddir}->{data_UNIX_uid} *");
	    $self->SysCmd("$Sys::chgrp $ctx->{data_directories}->{$ddir}->{data_UNIX_gid} *");
	    $self->SysCmd("$Sys::chmod 755 *");
	    $self->SysCmd("chmod 644 *ntf *nsf");
	}
    }
    $self->Chdir($ctx->{pPath}) || die;
    $self->SysCmd("$Sys::chmod a+x *") || die;
    $self->SysCmd("$Sys::chmod a-w *") || die;    $self->SysCmd("$Sys::chown -R 0 *")|| die;
    $self->SysCmd("$Sys::chgrp -R 2 *")|| die;
    if (-f "bindsock") {
	chown(0,2,"bindsock");
	$self->SysCmd("$Sys::chmod 4555 bindsock") || die;
    }
}

sub zSeriesPostProcessing{ 
    local($self, $ctx, $rMsg) = @_;
    
    local($ddir,$dPath,$cmd);

    if ($ctx->{kitArch} eq "os390") {
	$self->Chdir($ctx->{pPath})  or die "Can't change to $ctx->{pPath}";
        if (-f  "nsd.sh.IBM-1047") {
	    if (-f  "nsd.sh") {
		$self->SysCmd("$Sys::rm nsd.sh.IBM-1047") || die "Can't remove nsd.sh.IBM-.1047"; 
	    }
	}	
    	if (-f  "nsd.sh") {     #must be new to this installation
		#$self->SysCmd("$Sys::mv $ctx->{pPath}/nsd.sh $ctx->{pPath}/nsd.sh.IBM-1047") || die "Can't move nsd.sh to nsd.sh.IBM-1047"; 
		$self->SysCmd("$Sys::mv nsd.sh nsd.sh.IBM-1047") || die "Can't move nsd.sh to nsd.sh.IBM-1047";
	}
    	if ( ! -l  "nsd.sh") {     #must be new to this installation
		#$self->SysCmd("$Sys::ln -s $ctx->{pPath}/nsd.sh $ctx->{pPath}/locale_wrapper.sh") || die;
		$self->SysCmd("$Sys::ln -s locale_wrapper.sh nsd.sh") || die;
	}
	
	#handle data directory things
	@ddirs = sort(keys(%{$ctx->{data_directories}}));
	foreach $dPath (@ddirs) {

		$self->Chdir($dPath) || die;
		#os390 only,  note -- a few htm files have been have been converted to ascii
		#   in the kitting process(gendist.pl). 

		#os390 only, to assist NLS
		$cmd = "$Sys::cp cp -p browser.cnf browser.cnf.1047";
		$self->SysCmd($cmd) || die;
		chown(
			$ctx->{data_directories}->{$dPath}->{data_UNIX_uid},
			$ctx->{data_directories}->{$dPath}->{data_UNIX_gid},
			"browser.cnf.1047");

		$cmd = "$Sys::cp cp -p httpd.cnf httpd.cnf.1047";
		$self->SysCmd($cmd) || die;
		chown(
			$ctx->{data_directories}->{$dPath}->{data_UNIX_uid},
			$ctx->{data_directories}->{$dPath}->{data_UNIX_gid},
			"httpd.cnf.1047");

		# os390 only to support multi-language
		$self->Chdir("$dPath") || die;
		if ( -f ".DomLANG.last.run" ) {
			$self->SysCmd("$Sys::rm -f .DomLANG.last.run") || die;
		}
		if ( -f ".DomLANG.server.libascii.codepages" ) {
			$self->SysCmd("$Sys::rm -f .DomLANG.server.libascii.codepages") || die;
		}
	}
	
	#Back to program directory stuff
	$self->Chdir($ctx->{pPath}) || die;

	#set the owner and group of the program directory
	local($kcurid)=`id -u`;
	chomp($kcurid);
	local($group)=`id -g`;
	chomp($group);
	system("chown -Rh $kcurid:$group $ctx->{pPath}");		
		
	if (-f "createresdir") {
		$self->SysCmd("$Sys::chmod 6755 createresdir") || die;
	}
	if (-f "libnotes") {
		#os390 needs extattr for libnotes
		`/bin/extattr +l $ctx->{pPath}/libnotes` ;
		if ( $? ne 0 ) {
			print("\nERROR: install could not turn on the shared library extended attribute for $ctx->{pPath}/libnotes. \nYou may NOT have read access to BPX.FILEATTR.SHARELIB.\n\n");
			system("cat /tmp/nuish.err");
			die;
		}    
	}
	if (-f "bindsock") {
		$self->SysCmd("$Sys::chmod 4555 bindsock") || die;
	}

    }	
		
    if ($ctx->{kitArch} eq "zlinux") {
	local @fix_files = keys %{$ctx->{backup}};
	if (-f "tunekrnl") {
		chown(0,2,"tunekrnl");
		$self->SysCmd("$Sys::chmod 4555 tunekrnl") || die;
	}
	if ( ! -l "../linux") {
 		$self->SysCmd("$Sys::ln -s zlinux ../linux") || die;
	}
	if (-f "bindsock") {
		chown(0,2,"bindsock");
		$self->SysCmd("$Sys::chmod 4555 bindsock") || die;
	}
	foreach $filepath (@fix_files){	   	    
	    if ((defined ( $fuid{$filepath})) && (defined ( $fuid{$filepath}) ) ) {
		chown(
		      $fuid{$filepath},
		      $fgroup{$filepath},
		      $filepath);
	    }

	    if (defined ($fmode{$filepath})){
		chmod($fmode{$filepath}, $filepath);
	    }
	}
    }		

}
sub SaveLPParms {
    
    my $backupdir = "$ctx->{pPath}/$ctx->{base_version}";
    my $backup_install_dat = "$backupdir/\.install\.dat";
    
    if ( ! -f $backup_install_dat) {
	if (! -d $backupdir){	   
	     if (!mkdir $backupdir, 0755) {
		return 1; 
	    }
	    
	}
	if ($ctx->{kitArch} ne "os390") {
	    if (!$self->SysCmd("$Sys::cp -p $ENV{NUI_CFGFILE} $backupdir")){	   	    
		return 1;
	    }
	}
	else {
		if (!$self->SysCmd("$Sys::cp cp -p  $ENV{NUI_CFGFILE} $backupdir")){
		    return 1;
		}
        }
    }
    else {
	return 0;
    }
}
sub RestoreLPParameters {
    my $backupdir = "$ctx->{pPath}/$ctx->{target_version}";
    my $backup_install_dat = "$backupdir/\.install\.dat"; 
    my $new_cfg  =   "$backupdir/newcfg";	   
    my ($bck_ctxcfg, $bck_ctx);
    # if there is no backup we can't restore anything
    if ( ! -f $backup_install_dat) {
	#can't restore .install.dat
	return 1;
    }
  if ( -f $backup_install_dat ) {
      open (BCK, "<$backup_install_dat") or die "Can't open $backup_install_dat:$!";
      open( NEW, ">$new_cfg") or die "Can't open $new_cfg:$!";
      while (<BCK>) {
	  if (/kitArch/) {
	      print NEW "kitArch = $ctx->{kitArch}\n";
	  }
	  else {
	      print NEW $_;
	  }
      }
      close (BCK);
      close (NEW);
      unlink ($ENV{NUI_CFGFILE}) or die "Can't unlink $ENV{NUI_CFGFILE}):$!";
      rename ($new_cfg , $ENV{NUI_CFGFILE}) or die "Can't rename $new_cfg to $ENV{NUI_CFGFILE}):$!";
  }
    return 0;
    #if the original .install.dat had disappeared: restore the whole file from the backup
#    if ( ! -f "$ENV{NUI_CFGFILE}" ) {
#	if ($ctx->{kitArch} ne "os390") {
#	    if (!$self->SysCmd("$Sys::cp -p $ENV{NUI_CFGFILE} $backupdir")){	   	   
#		return 2;
#	    }
#	}
#	else {
#	    if (!$self->SysCmd("$Sys::cp cp -p $ENV{NUI_CFGFILE} $backupdir")){
#		return 2;	
#	    }	
#	}	
#    }
    
    #both files exist: restore just LP keys
    $bck_ctxcfg = new CfgData ();
    if ( ! $bck_ctxcfg->InitFromFile("$backup_install_dat")) {
	$$rMsg .= $prevctxcfg->GetErrorMessage();
	return 3;
    }
    $bck_ctx = $bck_ctxcfg->GetData();
    undef $bck_ctxcfg;

    if (defined ($bck_ctx->{'cfp_lp_current'} ) ) {
	$ctx->{'cfp_lp_current'} =  StringsRes::GetShortVersion($bck_ctx->{'cfp_lp_current'});
    }
    else {
	undef $ctx->{'cfp_lp_current'};
    }
    
    if (defined ($bck_ctx->{'cfp_lp_base_version'} ) ) {
	$ctx->{'cfp_lp_base_version'} =  StringsRes::GetShortVersion($bck_ctx->{'cfp_lp_base_version'});
    }
    else {
	undef $ctx->{'cfp_lp_base_version'};
    }
    if (defined ($bck_ctx->{'cfp_lp_prev'} ) ) {
	$ctx->{'cfp_lp_prev'} =  StringsRes::GetShortVersion($bck_ctx->{'cfp_lp_prev'});
    }
    else {
	undef $ctx->{'cfp_lp_prev'};
    }
}
sub UpdateLParameters {
    
    #############################################################################
    #
    #     cfp_lp_prev
    #
    # set cfp_lp_prev to the old value of cfp_lp_current if it wasn't "skip"
    # if it was "skip" set cfp_lp_prev to cfp_lp_base_version
    # if there wasn't value for cfp_lp_current set cfp_lp_prev to the old version
    #############################################################################
    if (defined ($prevctx->{'cfp_lp_current'}) ){
	if ( $prevctx->{'cfp_lp_current'} ne 'skip') {
	    $ctx->{'cfp_lp_prev'} = StringsRes::GetShortVersion($prevctx->{'cfp_lp_current'});	    
	}
	else {
	    if (defined ($prevctx->{'cfp_lp_base_version'}) ){
		$ctx->{'cfp_lp_prev'} = StringsRes::GetShortVersion($prevctx->{'cfp_lp_base_version'});
	    }
	    else {
		if (defined ($ctx->{nuicfg}->{base_stringsres}) ) {
		    $ctx->{'cfp_lp_prev'} = StringsRes::GetShortVersion($ctx->{nuicfg}->{base_stringsres});
		}
		elsif (defined ($prevctx->{$ctx->{base_version}}->{version_string}) ) {
		    $ctx->{'cfp_lp_prev'} = StringsRes::GetShortVersion($prevctx->{$ctx->{base_version}}->{version_string});	
		}
		else {
		    undef $ctx->{'cfp_lp_prev'} ;
		}
	    }
	}
    }    
    else {
	if (defined ($ctx->{nuicfg}->{base_stringsres}) ) {
	    $ctx->{'cfp_lp_prev'} = StringsRes::GetShortVersion($ctx->{nuicfg}->{base_stringsres});
	}
	elsif (defined($prevctx->{$ctx->{base_version}}->{version_string}  ) ) {
	    $ctx->{'cfp_lp_prev'} = StringsRes::GetShortVersion($prevctx->{$ctx->{base_version}}->{version_string});
	}
	else {
	    if (defined ($ctx->{version_string}) ){
		$ctx->{'cfp_lp_prev'} = StringsRes::GetShortVersion($ctx->{version_string});	
	    }
	    else {
		if (defined ($ctx->{nuicfg}->{fix_stringsres}) )  {
		    $ctx->{'cfp_lp_prev'}  = StringsRes::GetShortVersion($ctx->{nuicfg}->{rev});
		}
		else {
		    undef $ctx->{'cfp_lp_prev'} ;
		}
	    }
	}
    }
    #############################################################################
    #
    #  cfp_lp_base_version
    #
    # cfp_lp_base_version = fix version if fixpack is live 
    # if fixpack/hotfix is dead 
    # keep the old value of cfp_lp_base_version if it was present in .install.dat
    # assign the old version to it if it didn't exist in the .install.dat
    #############################################################################

    if ($ctx->{nuicfg}->{cfp_lp_current} eq 'skip'){ #live
	$ctx->{'cfp_lp_base_version'} = StringsRes::GetShortVersion($ctx->{nuicfg}->{fix_stringsres});
    }
    else { #dead 
	if (defined ($prevctx->{'cfp_lp_base_version'}) ) {
	    $ctx->{'cfp_lp_base_version'} =  StringsRes::GetShortVersion($prevctx->{'cfp_lp_base_version'});
	}
	else {
	    if (defined ($ctx->{nuicfg}->{base_stringsres}) ) {
		$ctx->{'cfp_lp_base_version'} = StringsRes::GetShortVersion($ctx->{nuicfg}->{base_stringsres});
	    }
	    elsif (defined($prevctx->{$ctx->{base_version}}->{version_string})  ) {
		$ctx->{'cfp_lp_base_version'} = StringsRes::GetShortVersion($prevctx->{$ctx->{base_version}}->{version_string});
	    }
	    else {
		if (defined ($ctx->{version_string}) ) {
		    $ctx->{'cfp_lp_base_version'} = StringsRes::GetShortVersion($ctx->{version_string});
		}
		else {
		    if (defined ($ctx->{nuicfg}->{fix_stringsres}) )  {
			$ctx->{'cfp_lp_base_version'}  = StringsRes::GetShortVersion($ctx->{nuicfg}->{rev});
		    }
		    else {
			undef $ctx->{'cfp_lp_base_version'} ;
		    }
		}
	    }
	}
    }
    
    ###############################################################################
    #
    #   cfp_lp_current is either "skip" if fixpack is dead
    #                 or equal to new version string if it's alive
    ###############################################################################
    if ($ctx->{nuicfg}->{cfp_lp_current} eq 'skip'){
	$ctx->{'cfp_lp_current'} = 'skip';	
    }
    else {
	($ctx->{'cfp_lp_current'} = StringsRes::GetShortVersion($ctx->{nuicfg}->{fix_stringsres})) =~
	   s/\"//g;
    }


}
sub GetExisting {
my $dir = shift;
my $ftml = shift;
opendir(DEST,$dir) or die "Can't open $dir:$!";
@files = grep { /$ftml$/} readdir(DEST);
closedir(DEST);
return pop(@files);
}
sub fix_nui_cfg{
my $filename = shift;
my $out = "";
my $susp_out = "";
$tempcfg = $filename."_temp";
open (NEW_NUI_CFG,">$tempcfg")  or die "Can't open $tempcfg:$!";
open (NUI_CFG, "<$filename") or die "Can't open $filename:$!";
while (<NUI_CFG>){
    if (/[\(\{][a-zA-Z0-9]+/){
	$suspicious = 0;
	$out .= $susp_out;
	$out.=$_;
	$susp_out = "";
	next;
    }
   # unquoted strings with special chars in R8:
    if  (/(pPath|program_directory|ptPath)\s*=\s*(.+)$/){
	$out .= "$1 = \"".$2."\"\n";
	next;
    }
    if (/cfp_lp_prev = Release/){
	$out.=StringsRes::GetShortVersion($cfp_lp_prev);
	next;
    }
    if (/[\(\{]([^A-Za-z\"][\s\n]*)[\)\}]*/) {
	if (/[\)\}]/){ #closed - empty parenthesis on one line
	   $suspicious = 0;
	   next unless $1 =~ /[A-Za-z]+/;  # skip empty lines
	}
	$suspicious = 1;
	$susp_out .= $_;
	next;
    }
    if ($suspicious){
	if (/^[\s]*$/){
	    $susp_out .= $_;
	    next;
	}
	if (/^[\s\n]*[\)\}]/) {
	    $suspicious = 0;
	    next;
	}
	# non-blank characters
	$suspicious = 0;
	$out .= $susp_out;
	$susp_out = "";
    }
    $out.=$_;
    
}
print NEW_NUI_CFG $out;
close NUI_CFG;
close NEW_NUI_CFG;
rename ($filename,"$filename.old") or die "Can't rename $filename:$!";

rename ($tempcfg, $filename) or die "Can't rename $tempcfg to $filename: $!";
if ( -e $filename ) {
    unlink ("$filename.old") or warn  "Can't unlink $filename.old:$!";
}
else {
    rename("$filename.old", $filename);
}
}







1;







