# /unix/nui/installer/tools/lib/InvFile.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#

require 5.000;

package InvFile;

CdPath::Require("PerlUtil.pl"); import PerlUtil;


sub new {
	local($class) = shift(@_);
 
    my $self = {};
    bless $self;
 
    %$self = (
		errmsg		=> "",
		file		=> "",

		$files		=> [],
		$sumByFile	=> {},
		$modeByFile	=> {},
		$sizeByFile => {}

	);

	return $self;
}


sub GetErrMsg {
	local($self) = @_;

	return $self->{errmsg};
}


sub InitFromFile {
	local($self, $file) = @_;
 
    local(*FILE, $_, $fname, $sum, $mode, $size);


	$self->{file} = $file;

	if ( (! -f $file) || (! open(FILE, "<$file"))) {
		# diagnostic msg; customer should never see this
		$self->{errmsg} = "InvFile: Unable to open $file\n$!\n";
		return 0;
	}


	while (<FILE>) {

		($fname, $sum, $mode, $size) = split(/ /, $_);

		push(@{$self->{files}}, $fname);
		$self->{sizeByFile}->{$fname} = $size;

	}

	return 1;
}


sub GetFileList {
	local($self) = @_;

	return $self->{files};
}


sub GetFileSize {
	local($self, $fname) = @_;

	return $self->{sizeByFile}->{$fname};
}

1;
