# /unix/nui/installer/tools/lib/InstBEIA.pl
#
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 2023, HCL Development Corporation.
## All Rights Reserved.
 
 
require 5.000;
 
$SIG{'INT'} = $SIG{'QUIT'} = $SIG{'TERM'} = 'IGNORE';
 
# Load the CdPath package, used for Require-ing other perl files,
# and to translate misc filenames to a form accesible on the cd.
# @INC is already set appropriately here.
# So that this multiple eval junk here does not need to be repeated in# every perl file that requires another, member functions are to be
# explicity called via CdPath::
#
eval 'require "CdPath.pl";';
eval 'require "CDPATH.PL";';
eval 'require "CDPATH.PL;1";';
eval 'require "cdpath.pl";';
CdPath::CdPathSetRoot($ENV{NUI_DISTROOT});

 
CdPath::Require("CfgData.pm");		import CfgData;
CdPath::Require("CDFFile.pm");		import CDFFile;
CdPath::Require("PerlUtil.pl");		import PerlUtil;
CdPath::Require("InstBE.nls");		import InstBE_nls;
CdPath::Require("NIC.pm");			import NIC;
CdPath::Require("ShScript.pm");		import ShScript;
CdPath::Require("SysCmd.pl");

$dbg = $ENV{'NUI_DBG_BE'};


# setup & check system commands before anything else
#
@reqcmds = qw(
	mv rm mkdir env stty uname date touch tar chown
	chgrp cat chmod sh ln pwd ls find dirname basename cpio uname
);
if ( $ENV{'NUI_ARCH'} ne "os390") {
    push @reqcmds, qw( cp hostname clear );
}
if ( ! SysCmd::InitCmds(\@reqcmds, \@cmdsnotfound, \$errmsg, $ENV{'NUI_ARCH'})) {
	Out($txt{1} . $errmsg);
	Exit(1);
}
if ( $ENV{'NUI_ARCH'} =~ /linux/ ) {
	@reqcmds = qw(gunzip);
	$uncompressCmd = "gunzip";
} else {
	@reqcmds = qw(uncompress);
	$uncompressCmd = "uncompress";
}
if ( ! SysCmd::InitCmds(\@reqcmds, \@cmdsnotfound, \$errmsg, $ENV{'NUI_ARCH'})) {
	Out($txt{1} . $errmsg);
	Exit(1);
}
if ( $ENV{'NUI_ARCH'} ne "os390") {
	@optcmds = qw( rsh );
	if ( ! SysCmd::InitCmds(\@optcmds, \@cmdsnotfound, \$errmsg, $ENV{'NUI_ARCH'})) {
		Out($txt{8.1} . $errmsg . $txt{8.2});
	}
}


# constants
#
local($cdffile) = CdPath::CdPath("sets/data/comp.cfg");
local($fgmapfile) = CdPath::CdPath("sets/data/fg.dat");
local($fgsetdir) = "sets/fgroups/";
local($fgsetext) = ".taz";

# vars
#
local(
	$scrfile, $scrcfg, $scrdat,
	$cdf, 
	$fgmapcfg, $fgmap,
	$errmsg
);


# parse args :-)
#
$scrfile = $ARGV[0];


# load the filegroup map data
#
$fgmapcfg = new CfgData ();
if ( ! $fgmapcfg->InitFromFile($fgmapfile)) {
	Out($txt{5} . $fgmapcfg->GetErrorMessage());
	Exit(1);
}
$fgmap = $fgmapcfg->GetData();
undef $fgmapcfg;

#
# load the nui cfg file
#
local($nuicfgfile,$nuicfg,$nuicfgdat);
$nuicfgfile = CdPath::CdPath("sets/data/nui.cfg");
$nuicfg = new CfgData ();
if ( ! $nuicfg->InitFromFile($nuicfgfile)) {
    Out("$txt{21} " . $nuicfg->GetErrorMessage());
    Exit(1);
}
$nuicfgdat = $nuicfg->GetData();
undef $nuicfg;


# load script
#
local($d) = `$Sys::dirname $scrfile`; chomp($d);
if ( ! -d $d) {
	# Unable to load script file...
	Out("$txt{18.1}$scrfile$txt{18.2}");
	Exit(1);
}
chdir($d);
$d = `$Sys::pwd`; chomp($d);
$scrfile = "${d}/" . `$Sys::basename $scrfile`;
chomp($scrfile);
$scrcfg = new CfgData ();
if ( ! $scrcfg->InitFromFile($scrfile)) {
	Out($txt{2} . $scrfile . "\n" . $scrcfg->GetErrorMessage());
	Exit(1);
}
$scrdat = $scrcfg->GetData();
undef($scrcfg);


#
# check script rev
#
if ($scrdat->{script_rev} != $nuicfgdat->{script_rev}) {
	Out("$txt{22.1}${scrfile}$txt{22.2}$txt{22.3}");
	Exit(1);
}

#
# load the component def file
#
#$cdf = new CDFFile ();
$cdf = new CfgData();
if ( ! $cdf->InitFromFile($cdffile)) {
	Out($txt{3} . $cdf->GetErrorMessage());
	Exit(1);
}

#
# create the NIC obj
#
$nic = new NIC ($cdf, $scrdat);


#
# ask NIC to create the context's
#
local(@ctxs) = ();
if ( ! $nic->InitContexts(\@ctxs, $nuicfgdat)) {
	Out($nic->GetErrMsg());
	Exit(1);
}


#
# go thought ctx's and set isLocal
#
local($ctx, $ip);
local($localip) = GetLocalIp();
foreach $ctx (@ctxs) {
	if ($ctx->{targetHost} eq "localhost") {
		$ctx->{isLocal} = 1;
		next;
	}

	$ip = GetIP($ctx->{targetHost});
	$ctx->{isLocal} = ($ip eq $localip) ? 1 : 0;
}


if ($nic->IsBatchMode()) {
	Out(`$Sys::date` . "\n");
	# Batch mode script file is...
	Out("$txt{19.1}$scrfile$txt{19.2}");
}

local($stat);

$| = 1;
foreach $ctx (@ctxs) {

    if ($ENV{NUI_DBG_INCR}) {
        print "local ctx prior to Do-ing>\n";
        DumpData($ctx);
        print "<\n";
    }
	
	if ($ctx->{isLocal}) {
		$ret = DoLocal($ctx);
	} else {
		$ret = DoRemote($ctx);
	}

	if ($ret) {
		Out($txt{14}); # success...
		if (defined ($ctx->{nuicfg}->{nsdfix}) )  {
		    if (defined ($ctx->{fix_type})   ) {
			if ($ctx->{fix_type} eq "upgrade") {
			    Out("NSD successfully installed\n");
			}
			else {
			    Out("NSD successfully reverted\n");
			}
		    }
		}
		if (defined ($ctx->{nuicfg}->{customfix}) )  {
		    if (defined ($ctx->{fix_type})   ) {
			if ($ctx->{fix_type} eq "upgrade") {
			    Out("Custom fix successfully installed\n");
			}
			else {
			    Out("Custom fix  successfully reverted\n");
			}
		    }
		}
	}
    else {
	Exit(1);
    }
}

exit 0;

#
######################################################################


######################################################################
#
sub DoRemote {
    local($ctx) = @_;
    
    local($_);
    local($msg);
    local($localCmd, $rmtCmd, $localCmdRet, $rmtCmdRet, $rmtCmdOut);
    local($rmtSh) = new ShScript ();
    local($ret) = 1;

    local($evalstart, $evalline);
    $self->{errmsg} = "";
    $evalstart = __LINE__; ++$evalstart;
    eval <<'EndOfEval';


    Out($txt{9});	# remote Validating...

    #
    # validate remote shell
    #
    $rmtCmd = "echo hello"; # don't localiza
    $localCmdRet = $rmtSh->RunScript(
        $ctx->{targetHost},
        $rmtCmd,
        \$rmtCmdRet,
        \$rmtCmdOut );
	if ( ! $localCmdRet || $rmtCmdRet ) {
		Out($txt{10}); # Validation Failed
		$tmp = $rmtSh->GetError();
		Out($tmp);
		Out($txt{13}); # Please check...
		# the installation cannot proceed for host...
		Out("$txt{11.1}$ctx->{targetHost}$txt{11.2}");
		$ret = 0;
		return;
	}


	#
	# validate remote platform
	#
	local($localuname) = `$Sys::uname`;
	if ($localuname eq "SunOS") {
		$localuname = `$Sys::uname -p`;
	}
	$localCmdRet = $rmtSh->RunScript(
					 $ctx->{targetHost},
					 "uname",
					 \$rmtCmdRet,
					 \$rmtCmdOut );

        if ( ! $localCmdRet || $rmtCmdRet ) {
		$tmp = $rmtSh->GetError();
		Out($tmp);
		die;
	}

	if ($rmtCmdOut eq "SunOS") {
	    $localCmdRet = $rmtSh->RunScript(
					     $ctx->{targetHost},
					     "uname -p",
					     \$rmtCmdRet,
					     \$rmtCmdOut );
	    if ( ! $localCmdRet || $rmtCmdRet ) {
	        $tmp = $rmtSh->GetError();
	        Out($tmp);
	        die;
	    }
	}
	if ($localuname ne $rmtCmdOut) {
	    Out($txt{10}); # Validation Failed
	    Out($txt{15}); # platform not supported
	    # the installation cannot proceed for host...
	    Out("$txt{11.1}$ctx->{targetHost}$txt{11.2}");
	    
	    $ret = 0;
	    return;
	}

	#
	# set $rmtPerl appropriately
	#
        #
	local($rmtPerl);
	if ($ENV{'NUI_ARCH'} =~ /linux/ )  {
	    $rmtCmd = "which perl";
	    $localCmdRet = $rmtSh->RunScript(
	        $ctx->{targetHost},
	        $rmtCmd,
	        \$rmtCmdRet,
	        \$rmtCmdOut );
	    if ( $rmtCmdRet ) {
			$rmtCmd = "which Perl";
		    $localCmdRet = $rmtSh->RunScript(
		        $ctx->{targetHost},
		        $rmtCmd,
		        \$rmtCmdRet,
		        \$rmtCmdOut );
		    if ( $rmtCmdRet ) {
		        Out($txt{10}); # Validation Failed
		        $tmp = $rmtSh->GetError();
		        Out($tmp);
		        Out($txt{23}); # Perl
		        # the installation cannot proceed for host...
		        Out("$txt{11.1}$ctx->{targetHost}$txt{11.2}");
		        $ret = 0;
		        return;
		    }
		}
		chomp($rmtCmdOut);
		$rmtPerl = $rmtCmdOut;
	} else {
		$rmtPerl = "/tmp/lotus_nui/tools/bin/$ENV{'NUI_ARCH'}/Perl";
	}


	#
	# copy tools tree to remote
	#
	$localCmd = 
	        "cd $ENV{'NUI_DISTROOT'}; " .
		"$Sys::find tools sets/data -print | $Sys::cpio -o";
	if ($ENV{'NUI_SOLRMTDEV'}) {
		$localCmd = 
			"cd $ENV{'NUI_DISTROOT'}; " .
			"$Sys::find tools sets/data -print | $Sys::cpio -oL";
	}
	$rmtCmd = 
		"rm -rf /tmp/lotus_nui;" .
		"mkdir /tmp/lotus_nui;" .
		"cd /tmp/lotus_nui;" .
		"cpio -idmu";

	$localCmdRet = $rmtSh->RunScriptPipeToRemote(
		$ctx->{targetHost},
		$localCmd,
		$rmtCmd,
		\$rmtCmdRet,
		\$rmtCmdOut );
	if (( ! $localCmdRet) || $rmtCmdRet) {
	    print "localCmd:    $localCmd\n";
	    print "rmtCmd:   	$rmtCmd\n";
	    print "localCmdRet: $localCmdRet\n";
	    print "rmtCmdRet:   $rmtCmdRet\n";
	    print "rmtCmdOut:   $rmtCmdOut\n";
	    local($tmp) = $rmtSh->GetError();
	    if ($tmp) {
		print "$tmp\n";
	    }
	    die;
	}

	local($rmtLibDir) = "/tmp/lotus_nui/tools/lib";


	#
	# send the ctx to remote
	#
	
	# copy the context and override 'perl' for remote use
	local(%ctx) = %{$ctx};
	$ctx{perl} = $rmtPerl;

	# generate text form of hash
	local($cfgData) = new CfgData ();
	local($ctxString) = $cfgData->GenCfgFromHashRef(\%ctx);
	$rmtCmd = "$rmtPerl $rmtLibDir/RmtNIC.pl ReceiveContext";
	$localCmdRet = $rmtSh->RunScriptPipeDataToRemote(
        $ctx->{targetHost},
		$ctxString,
        $rmtCmd,
        \$rmtCmdRet,
        \$rmtCmdOut );
	if (( ! $localCmdRet) || $rmtCmdRet) {
		print "rmtCmd:   $rmtCmd\n";
        print "localCmdRet: $localCmdRet\n";
        print "rmtCmdRet:   $rmtCmdRet\n";
        print "rmtCmdOut:   $rmtCmdOut\n";
		local($tmp) = $rmtSh->GetError();
		if ($tmp) {
			print "$tmp\n";
		}
	die;
    }


    #
    # Validate Context
    #
    $rmtCmd = "$rmtPerl $rmtLibDir/RmtNIC.pl ValidateContext";
    $localCmdRet = $rmtSh->RunScript(
        $ctx->{targetHost},
        $rmtCmd,
        \$rmtCmdRet,
        \$rmtCmdOut );

    if ( ! $localCmdRet) {
        print "rmtCmd:   $rmtCmd\n";
        print "localCmdRet: $localCmdRet\n";
        print "rmtCmdRet:   $rmtCmdRet\n";
        print "rmtCmdOut:   $rmtCmdOut\n";
        local($tmp) = $rmtSh->GetError();
        if ($tmp) {
            print "$tmp\n";
        }
        die;
    }

    if ($rmtCmdRet) {
        Out($rmtCmdOut);
        Out("$txt{11.1}$ctx->{targetHost}$txt{11.2}"); # cannot proceed...
		$ret = 0;
        return;
    } else {
	Out($rmtCmdOut);
    }
	
        #changed to accomodate hotfixes
	if (($nuicfgdat->{kitType} eq "incr") ||
	    ($nuicfgdat->{kitType} eq "fix")){
		#
		# get context back from remote and replace for current
		#
		$rmtCmd = "$rmtPerl $rmtLibDir/RmtNIC.pl GetContext";
		$localCmdRet = $rmtSh->RunScriptPipeDataToRemote(
	        $ctx->{targetHost},
			$ctxString,
	        $rmtCmd,
	        \$rmtCmdRet,
	        \$rmtCmdOut );
		if (( ! $localCmdRet) || $rmtCmdRet) {
			print "rmtCmd:   $rmtCmd\n";
	        print "localCmdRet: $localCmdRet\n";
	        print "rmtCmdRet:   $rmtCmdRet\n";
	        print "rmtCmdOut:   $rmtCmdOut\n";
			local($tmp) = $rmtSh->GetError();
			if ($tmp) {
				print "$tmp\n";
			}
	        die;
	    }
	
		if ($ENV{NUI_DBG_INCR}) {
			print "context text from remote >\n";
			print "$rmtCmdOut\n";
			print "<\n";
		}
	
		local($ctxcfg) = new CfgData ();
		if ( ! $ctxcfg->InitFromScalar($rmtCmdOut)) {
			Out("Error receiving remote context.\n");
			Out($ctxcfg->GetErrorMessage());
			$ret = 0; return;
		}
		$ctx = $ctxcfg->GetData();
	
		if ($ENV{NUI_DBG_INCR}) {
			print "newly local ctx:\n";
			DumpData($ctx);	
		}
	}

	#
	# setup component destination data
	#
	local(@destPathList, %destPathCompHash);
    $nic->GetComponentDestinationData($ctx, \@destPathList, \%destPathCompHash);


    if ($ENV{'NUI_NOINSTALL'}) {
        Out("NUI_NOINSTALL: done.\n");
        $ret = 0; return;
    }


    # "Remote installing..."
    if( $ctx->{installation_inotes} ) {
	Out($txt{7});
    } else {
	Out($txt{7.1});
    }

    #print "from remote \n";
    #exit;

    #
    # PreInstallProcessing
    #
    $rmtCmd = "$rmtPerl $rmtLibDir/RmtNIC.pl PreInstallProcessing";
    $localCmdRet = $rmtSh->RunScript(
        $ctx->{targetHost},
        $rmtCmd,
        \$rmtCmdRet,
        \$rmtCmdOut );
    if ( ! $localCmdRet) {
        print "rmtCmd:   $rmtCmd\n";
        print "localCmdRet: $localCmdRet\n";
        print "rmtCmdRet:   $rmtCmdRet\n";
        print "rmtCmdOut:   $rmtCmdOut\n";
        local($tmp) = $rmtSh->GetError();
        if ($tmp) {
            print "$tmp\n";
        }
        die;
    }


    if ($rmtCmdRet) {
		# Unexpected PreInstallProcessing failure...
		Out("$txt{20}$rmtCmdOut\n");
        Out("$txt{17.3}$ctx->{targetHost}$txt{17.4}");
        $ret = 1; return;
    } else {
		Out($rmtCmdOut);
	}
	#added for hotfixes
	if (($nuicfgdat->{kitType} eq 'fix') && ($ctx->{fix_type} eq 'revert')){
	    $ret = 1;
	    return;
	}
	
	#
	
	#
	# remote install the stuff
	#
	local($destPath, $comp, $fglist, $fg, $fgset, $fg, $cmd, $out);

	foreach $destPath (@destPathList) {
		$dbg && print "Processing destPath $destPath\n";

		foreach $comp (@{$destPathCompHash{$destPath}}) {
			$dbg && print "  Processing comp $comp\n";

		#	$fglist = $cdf->GetFilegroupList($comp);
			$fglist = $destPathCompHash{$destPath};
			if ($dbg) {
				print "  filegroups:";
				DumpData($fglist, 2);
			}

#			if( !$ctx->{installation_inotes} && $comp =~ "iNotes Web Access" ) {
#				$dbg && print "Not install >>>  $comp\n";
#				next;
#			} elsif ( $ctx->{installation_inotes} && $comp =~ "iNotes Web Access" ) {
#			       $dbg &&  print "Installing  >>> $comp\n";
#			}


			foreach $fg (@{$fglist}) {

				if ($fgmap->{$fg} eq "no_files") {
					if ($dbg) {
						print "  NOT doing fg $fg: no files\n";
					}
					next;
				}

				$dbg && print "  doing fg $fg\n";
		
				$fgset = 
					CdPath::CdPathShellString(
						$fgsetdir . $fgmap->{$fg} . $fgsetext);
				$dbg && print "    fgset: $fgset\n";

				if ( ! $ENV{'NUI_NOUNTAR'}) {
			    $localCmd = "dd if=$fgset";
			    $rmtCmd =
					"mkdir -p $destPath;" .
					"cd $destPath;" .
					"cat - | $uncompressCmd -c | tar xvf -";

			    $localCmdRet = $rmtSh->RunScriptPipeToRemote(
			        $ctx->{targetHost},
			        $localCmd,
			        $rmtCmd,
			        \$rmtCmdRet,
			        \$rmtCmdOut );

			    if (( ! $localCmdRet) || $rmtCmdRet) {
			        print "localCmd:    $localCmd\n";
			        print "rmtCmd:      $rmtCmd\n";
			        print "localCmdRet: $localCmdRet\n";
			        print "rmtCmdRet:   $rmtCmdRet\n";
			        print "rmtCmdOut:   $rmtCmdOut\n";
			        local($tmp) = $rmtSh->GetError();
			        if ($tmp) {
			            print "$tmp\n";
			        }
			        die;
			    }
				}
			}
		}
	}


    #
    # PostInstallProcessing
    #
    $rmtCmd = "$rmtPerl $rmtLibDir/RmtNIC.pl PostInstallProcessing";
    $localCmdRet = $rmtSh->RunScript(
        $ctx->{targetHost},
        $rmtCmd,
        \$rmtCmdRet,
        \$rmtCmdOut );
    if ( ! $localCmdRet) {
        print "rmtCmd:   $rmtCmd\n";
        print "localCmdRet: $localCmdRet\n";
        print "rmtCmdRet:   $rmtCmdRet\n";
        print "rmtCmdOut:   $rmtCmdOut\n";
        local($tmp) = $rmtSh->GetError();
        if ($tmp) {
            print "$tmp\n";
        }
        die;
    }
    if ($rmtCmdRet) {
		# unexpected failure...
		Out("$txt{17.1}$rmtCmdOut$txt{17.3}$ctx->{targetHost}$txt{17.4}");
        $ret = 0; return;
    } else {
		Out($rmtCmdOut);
	}


	#
	# remove the tools
	#
    $rmtCmd = "rm -rf /tmp/lotus_nui";
    $localCmdRet = $rmtSh->RunScript(
        $ctx->{targetHost},
        $rmtCmd,
        \$rmtCmdRet,
        \$rmtCmdOut );

	
	$ret = 1; return;


EndOfEval
    if ($@) {
        ($evalline) = ($@ =~ /line (\d+)/);
		Out($@);
        local($tmp) = __FILE__ . " line " . ($evalstart+$evalline) . "\n";
		Out($tmp);
        return 0;
    }

	return $ret;
}
#
######################################################################


######################################################################
#
sub DoLocal {
	local($ctx) = @_;

	local($msg) = "";

	# "Validating..."
	Out($txt{9});
	if ( ! $nic->ValidateContext($ctx, \$msg)) {
		Out($msg);
		Out($txt{16.2}); # cannot proceed...
		return 0;
	}
	Out($msg);


    #
    # setup component destination data
    #
    local(@destPathList, %destPathCompHash);
    $nic->GetComponentDestinationData($ctx, \@destPathList, \%destPathCompHash);


	if ($ENV{'NUI_NOINSTALL'}) {
		Out("NUI_NOINSTALL: done.\n");
		return 0;
	}


	# "Local installing..."
	if ($ctx->{kitArch} eq "sol" || $ctx->{kitArch}  =~ /^aix/ ) {
	    if( $ctx->{installation_inotes} ) {
		Out($txt{7});
	    } else {
		Out($txt{7.1});
	    }
	} else {
	    Out($txt{7});
	}

       
	if ($ctx->{nuicfg}->{kitType} eq 'fix'){
	    local (%base_checksums, %target_checksums, $filename, %checked);
	    foreach $filename (keys %{$ctx->{nuicfg}->{$ctx->{base_version}}}){
		$base_checksums{$filename} = 
		$ctx->{nuicfg}->{$ctx->{base_version}}->{$filename}->{checksum};
	    }

	    foreach $filename (keys %{$ctx->{nuicfg}->{$ctx->{target_version}}}){
		$target_checksums{$filename} = 
		    $ctx->{nuicfg}->{$ctx->{target_version}}->{$filename}->{checksum};
	    }
	    local @fixes = keys %base_checksums;
	    foreach $fname (@fixes){
		if (!defined $target_checksums{$fname}){
		    # deleting file
		 #   Out($txt{7.3}.$fname.$txt{4.1});
		    next;
		}
		else{
		    if (($base_checksums{$fname} > 0) && ($target_checksums{$fname} > 0) &&
			($base_checksums{$fname} != $target_checksums{$fname})){ 
			Out($txt{7.2}.$fname.$txt{4.1});
			$checked{$fname} = 1;
			
		    }
		    elsif (($base_checksums{$fname} == 0)  && ($target_checksums{$fname} > 0)){
			Out($txt{7.2}.$fname.$txt{4.1});
			$checked{$fname} = 1;
		    }
		    elsif (($target_checksums{$fname} == 0) && ($base_checksums{$fname} > 0)){
			Out($txt{7.2}.$fname.$txt{4.1});
			$checked{$fname} = 1;
		    }
		}
	    }
	    @fixes = keys %target_checksums; 
	    foreach $fname (@fixes){
		next unless (!$checked{$fname});
		if (!defined $base_checksums{$fname}){
		  #  Out($txt{7.3}.$fname.$txt{4.1});
		    next;
		}
		else{
		    if (($target_checksums{$fname} > 0) && ($base_checksums{$fname} > 0) &&
			($base_checksums{$fname} != $target_checksums{$fname})){ 
			Out($txt{7.2}.$fname.$txt{4.1});
		    }
		    if (($base_checksums{$fname} == 0)  && ($target_checksums{$fname} >  0)){
			# Out($txt{7.3}.$fname.$txt{4.1});
			next;
		    }
		    if (($target_checksums{$fname} == 0) && ($base_checksums{$fname} > 0)){
			# Out($txt{7.4}.$fname.$txt{4.1});
			next;
		    }
		}
	    }	    
	    
	}
	#
	# pre-install processing
	#
	if ( ! $nic->PreInstallProcessing($ctx, \$msg)) {
        # Unexpected PreInstallProcessing failure...
        Out("$txt{20}$msg$txt{17.2}");
		return 0;
	} else {
		Out($msg);
	}

	#added for hotfixes
	if (($ctx->{nuicfg}->{kitType} eq 'fix') && ($ctx->{fix_type} eq 'revert')){
		if ( ! $nic->PostInstallProcessing($ctx, \$msg)) {
			Out($msg);
			return 0;
		}

		return 1;
	}
	
	#
        #print "from local \n";
        #exit;

	#
	# local install stuff
	#
	local($destPath, $comp, $fglist, $fg, $fgset, $fg, $cmd, $out);

	foreach $destPath (@destPathList) {
		$dbg && print "Processing destPath $destPath\n";

		if ( ! -d $destPath ) {
			if (system("$Sys::mkdir -p $destPath")) {
				Out($txt{4} . $destPath . $txt{4.1} . $! . $txt{4.2});
				return 0;
			}
		}
	#
	#	$comp<=>file group
	#
		foreach $comp (@{$destPathCompHash{$destPath}}) { # components are file groups for R8
#			$dbg && print "  Processing comp $comp\n";

		#	if( !$ctx->{installation_inotes} && $comp =~ "iNotes Web Access" ) {
		#		$dbg && print "Not install >>>  $comp\n";
		#		next;
		#	} elsif ( $ctx->{installation_inotes} && $comp =~ "iNotes Web Access" ) {
		#	       $dbg &&  print "Installing  >>> $comp\n";
		#	}


		#	$fglist = $cdf->GetFilegroupList($comp);
			$fglist = $cdf->{data}->{_KeyList_};
			if ($dbg) {
				print "  filegroups:";
				DumpData($fglist, 2);
			}

		#	foreach $fg (@{$fglist}) {
			$fg = $comp;
				if ($fgmap->{$fg} eq "no_files") {
					if ($dbg) {
						print "  NOT doing fg $fg: no files\n";
					}
					next;
				}

				$dbg && print "  doing fg $fg\n";
		
				$fgset = 
					CdPath::CdPathShellString($fgsetdir . $fgmap->{$fg} . $fgsetext);
				$dbg && print "    fgset: $fgset\n";

				if (! $ENV{'NUI_NOUNTAR'}) {
				    @sb = stat($destPath);
				    $fgroup{$destPath} = $sb[5];
				    $fuid{$destPath} = $sb[4];
				    $fmode{$destPath} = $sb[2] & 07777;
				$cmd = 
					"cd $destPath; " .
					"$Sys::cat $fgset | " .
					"$uncompressCmd -c | $Sys::tar xvf -";
				$dbg && print "    extract cmd: $cmd\n";
				$dbg && print "    extracting " . `date`;
				$out = `$Sys::sh -c "$cmd" 2>&1`;
				$stat = ($? >> 8);
				if ($dbg) {
					print "    stat: $stat\n";
					print "    out: $out";
				}
				if ($stat) {
					Out($txt{6} . $cmd . "\n" . $out);
					return 0;
				}
				    chown($fuid{$destPath}, $fgroup{$destPath}, $destPath) or 
					die "can't change owner back on $destPath:$!";
				    system("$Sys::chown -R $fuid{$destPath}:$fgroup{$destPath}  $destPath") ;
				    
				$dbg && print "    done " . `date`;
				}
		#	}
		}

	
		$dbg && print "\n";
	}


	#
	# post-install processing
	#
	if ( ! $nic->PostInstallProcessing($ctx, \$msg)) {
        # unexpected failure...
        Out("$txt{17.1}$msg$txt{17.2}");
		return 0;
    } else {
        Out($msg);
    }


	return 1;
}
#
######################################################################


######################################################################

sub Out {
	print @_;
}


sub Exit {
	local($stat) = @_;

	exit $stat;
}



sub GetIP {
	local($host) = @_;

    local(@tmp, $a, $b, $c, $d, $localip);

    @tmp = gethostbyname($host);
    ($a,$b,$c,$d) = unpack('C4', ($tmp[4])[0]);
    $localip = "$a.$b.$c.$d";

	return $localip;
}

sub GetLocalIp {

	local($localHostname) = `$Sys::hostname`;
    chomp($localHostname);

	return GetIP($localHostname);
}

sub GetOSNameFromLocalMachine {
    local ($self) = @_;    
    local $NUI_ARCH="";
    local $osname;

    if ($ENV{'NUI_ARCH'} eq "os400")  {
	    return $ENV{'NUI_ARCH'};
    }

    $osname = `$Sys::uname`;
    $osname =~ s/\n//;
    $NUI_ARCH = $osname;

    if ( $osname eq "AIX" ) {
	$NUI_ARCH = "aix";
    } 
    elsif ($osname eq "Linux") {  
	$osname = `$Sys::uname -m`;
	$osname =~ s/\n//;
	    $NUI_ARCH="linux";
    }

#    setenv NUI_ARCH
    `$Sys::export $NUI_ARCH`;
    

#    print "GetOSNameFromTargetMachine:   $NUI_ARCH";
    return $NUI_ARCH;
}
