# /unix/nui/installer/tools/lib/IniFile.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1998, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;


######################################################################
#
package IniFile;

CdPath::Require("IniFile.nls");      import IniFile_nls;

sub new {
	local($class) = @_;

	local($self) = {
		list			=> [],
		errmsg			=> "",
		fname			=> ""
	};

	bless $self;
}


sub InitFromFile {
	local($self, $fname) = @_;

	local($_, *INIFILE, $l);
	local($status) = 1;
	local($curSection) = "";
	local(@iniLineWhiteLineTmpList) = ();

	$self->{fname} = $fname;

	if ( ! open(INIFILE, "<$fname")) {
		$self->{'errmsg'} = "$txt{'1.1'}$fname$txt{'1.2'}$!$txt{'1.3'}";
		return 0;
	}

	while (<INIFILE>) {
		chomp;
		$l = IniLine->new($_);

		if ($l->GetType() eq "IniLineSyntaxError") {
			$self->{'errmsg'} = 
				"$txt{'2.1'}$fname$txt{'2.2'}$.$txt{'2.3'}$_$txt{'2.4'}";
			$status = 0;
			last;

		} elsif ($l->GetType() eq "IniLineSectionHeader") {
			if ($curSection && @iniLineWhiteLineTmpList) {
				local($_);
				foreach (@iniLineWhiteLineTmpList) {
					$curSection->Add($_);
				}
				@iniLineWhiteLineTmpList = ();
			}

			$curSection = IniSection->new($l);
			push(@{$self->{list}}, $curSection);

		} elsif ($l->GetType() eq "IniLineKeyValue") {
			if ( ! $curSection) {
				$self->{'errmsg'} =
					"$txt{'2.1'}$fname$txt{'2.2'}$.$txt{'2.3'}$_$txt{'2.4'}" .
					"$txt{3.1}";
				$status = 0;
				last;
			}
			if (@iniLineWhiteLineTmpList) {
				local($_);
				foreach (@iniLineWhiteLineTmpList) {
					$curSection->Add($_);
				}
				@iniLineWhiteLineTmpList = ();
			}

			$curSection->Add($l);

		} elsif ($l->GetType() eq "IniLineWhiteLine") {
			if ( $curSection) {
				push(@iniLineWhiteLineTmpList, $l);
			} else {
				push(@{$self->{list}}, $l);
			}
		}
	}
	if (@iniLineWhiteLineTmpList) {
		local($_);
		foreach (@iniLineWhiteLineTmpList) {
			push(@{$self->{list}}, $_);
		}
		@iniLineWhiteLineTmpList = ();
	}
		

	close(INIFILE);
	return $status;
}


sub GetErrMsg {
	local($self) = @_;

	return $self->{'errmsg'};
}


sub Print {
    local($self) = @_;
 
    local($_);
 
    foreach (@{$self->{list}}) {
        $_->Print();
    }
}


sub GetSectionNames {
	local($self) = @_;

	local($_);
	local(@list) = ();

	foreach (@{$self->{list}}) {
		if ($_->IsIniSection()) {
			push(@list, $_->GetSectionName());
		}
	}

	return @list;
}


sub GetSection {
	local($self, $sectionName) = @_;

	local($_, $name);

	local($canonSectionName) = $sectionName;
	$canonSectionName =~ tr/a-z/A-Z/;

	foreach (reverse(@{$self->{list}})) {
		$_->IsIniSection() || next;
		$name = $_->GetSectionName();
		$name =~ tr/a-z/A-Z/;
		if ($name eq $canonSectionName) {
			return $_;
		}
	}
	
	$self->{errmsg} = "$txt{4.1}$sectionName$txt{4.2}";
	return undef;
}
		

#
# package IniFile
######################################################################


######################################################################
#
package IniSection;

sub new {
	local($class, $iniLineSectionHeader) = @_;

	local($self) = {
		sectionName				=> "",
		iniLineSectionHeader	=> "",
		list					=> [],
	};

	$self->{sectionName} = $iniLineSectionHeader->GetSectionName();
	$self->{iniLineSectionHeader} = $iniLineSectionHeader;

	bless $self;
}


sub Add {
	local($self, $iniLine) = @_;

	# simply adds the iniLine; no replacement of keys

	push(@{$self->{list}}, $iniLine);

	return 1;
}


sub Print {
	local($self) = @_;

	local($_);
	
	$self->{iniLineSectionHeader}->Print();
	foreach (@{$self->{list}}) {
		$_->Print();
	}
}


sub IsIniSection {
	return 1;
}


sub GetSectionName {
	local($self) = @_;

	return $self->{sectionName};
}


sub GetValue {
	local($self, $key) = @_;

	local($_, $name);

	$key =~ tr/a-z/A-Z/;

	foreach (reverse(@{$self->{list}})) {
		$name = $_->GetKey();
		$name =~ tr/a-z/A-Z/;
		if ($name eq $key) {
#		if ($_->GetKey() =~ /^$key$/i) {
			return $_->GetValue();
		}
	}

	return undef;
}


sub GetEnumeratedKeysValueList {
	local($self, $keyBase) = @_;

	local(@list) = ();
    local($i) = 0;
    local($val);
 
    while (1) {
        $val = $self->GetValue($keyBase . $i);
        defined($val) || last;
        push(@list, $val);
        ++$i;
    }
 
   	return \@list;
}

#
# package IniSection
######################################################################


######################################################################
#
package IniLine;

sub new {
	local($class, $rawline) = @_;

	local($_, $tmp1, $tmp2);

	local($self) = {
		rawline			=> "",
		
		#
		# types:
		#	IniLineWhiteLine (blank or comment)
		#	IniLineSectionHeader
		#	IniLineKeyValue
		#	IniLineSyntaxError
		#
		type			=> "",

		#
		# type "IniLineSectionHeader"
		#
		sectionName		=> "",

		#
		# type "IniLineKeyValue"
		#
		key				=> "",
		value			=> ""
	};


	$_ = $self->{'rawline'} = $rawline;


	if (/^\s*$/) {
		#
		# blank line
		#
		$self->{'type'} = "IniLineWhiteLine";

	} elsif (/^\s*;/) {
		#
		# comment line
		#
		$self->{'type'} = "IniLineWhiteLine";

	} elsif (($tmp1) = /^\s*\[\s*([^\[\]]+?)\s*\]\s*$/) {
		#
		# section header
		#
		$self->{'type'} = "IniLineSectionHeader";
		$self->{'sectionName'} = $tmp1;

	} elsif (($tmp1,$tmp2) = /^\s*([^=\s]+)\s*=\s*"([^"]*)"(\s*|\s*;.*)$/) {
		#
		# key = " value [morevalue ..] " [;comment]
		#
		$self->{'type'} = "IniLineKeyValue";
		$self->{'key'} = $tmp1;
		($self->{'value'}) = ($tmp2 =~ /^\s*(\S*.*\S*)/);
		$self->{'value'} =~ s/^(.*?)\s*$/$1/;

	} elsif (($tmp1,$tmp2) = /^\s*([^=\s]+)\s*=\s*([^;]*?)(\s*|\s*;.*)$/) {
		#
		# key = value [morevalue ..] [;comment]
		#
		$self->{'type'} = "IniLineKeyValue";
		$self->{'key'} = $tmp1;
		$self->{'value'} = $tmp2;

	} else {
		#
		# syntax error
		#
		$self->{'type'} = "IniLineSyntaxError";
	}
		

	bless $self;
}


sub GetType {
	local($self) = @_;
	return $self->{'type'};
}


sub GetKey {
	local($self) = @_;
	return $self->{key};
}


sub GetValue {
	local($self) = @_;
	return $self->{value};
}


sub Dump {
	local($self) = @_;


	# diagnostic, non-customer text...
	print("IniLine type  : $self->{'type'}\n");

	print("  rawline     : >$self->{'rawline'}<\n");

	if ($self->{'type'} eq "IniLineSectionHeader") {
		print("  section name: >$self->{'sectionName'}<\n");
	} elsif ($self->{'type'} eq "IniLineKeyValue") {
		print("  key         : >$self->{'key'}<\n");
		print("  value       : >$self->{'value'}<\n");
	}
}


sub Print {
	local($self) = @_;

	print($self->{'rawline'} . "\n");
}


sub GetSectionName {
	local($self) = @_;

	return $self->{sectionName};
}


sub IsIniSection {
	return 0;
}
			

#
# package IniLine;
######################################################################

1;
