# /unix/nui/installer/tools/lib/CdPath.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
require 5.000;

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


package CdPath;
 

$CdPathRoot = "";


sub CdPathSetRoot {
	local($_) = @_;

	$CdPathRoot = $_;
}


sub CdPath {
	local($targpath) = @_;

	local($testpath);

	# try as-is
	$testpath="${CdPathRoot}/${targpath}";
	if (-e $testpath) {
		return $testpath;
	}

	# try upper-case
	$testpath = $targpath;
	$testpath =~ tr/[a-z]/[A-Z]/;
	$testpath =  "${CdPathRoot}/${testpath}";
	if (-e $testpath) {
		return $testpath;
	}

	# try upper-case with version ";1" appended
	$testpath .= ";1";
	if (-e $testpath) {
		return $testpath;
	}

	# try lower-case
	$testpath = $targpath;
	$testpath =~ tr/[A-Z]/[a-z]/;
	$testpath =  "${CdPathRoot}/${testpath}";
	if (-e $testpath) {
		return $testpath;
	}

	# didn't find it
	return "${CdPathRoot}/${targpath}";

}


sub CdPathShellString {
	local($targpath) = @_;

	local($path) = CdPath($targpath);
	$path =~ s/;1/\\;1/;
	
	return $path;
}
 

sub Require { 
	local($reqfile)=@_;

	local($_, $path);
	local($origroot) = $CdPathRoot;
	
	foreach (@INC) {
		CdPathSetRoot($_);
		$path = CdPath($reqfile);
		if (-e $path) {
			$CdPathRoot = $origroot;
			require $path;
			return;
		}
	}
	$CdPathRoot = $origroot;
}


1;
