/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal.ioutils;

import com.ibm.rcp.diff.internal.ioutils.RandomAccessOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileOutputStream
extends RandomAccessOutputStream {
    protected RandomAccessFile file;
    private boolean flushFromSeek = false;

    public RandomAccessFileOutputStream(RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
    }

    public RandomAccessFileOutputStream(File file, String string) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, string);
    }

    public RandomAccessFileOutputStream(String string, String string2) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, string2);
    }

    @Override
    public void write(int n) throws IOException {
        this.file.write(n);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public void flush() throws IOException {
        if (!this.flushFromSeek) {
            this.file.getFD().sync();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.file.write(byArray);
    }

    @Override
    public void seek(long l) throws IOException {
        this.flushFromSeek = true;
        this.flush();
        this.flushFromSeek = false;
        this.file.seek(l);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }
}

