/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal.ioutils;

import com.ibm.rcp.diff.internal.ioutils.ByteArrayFile;
import com.ibm.rcp.diff.internal.ioutils.RandomAccessOutputStream;
import java.io.IOException;

public class ByteArrayFileOutputStream
extends RandomAccessOutputStream {
    protected ByteArrayFile file;

    public ByteArrayFileOutputStream() {
        this.file = new ByteArrayFile();
    }

    public ByteArrayFileOutputStream(int n) {
        this.file = new ByteArrayFile(n);
    }

    public ByteArrayFileOutputStream(ByteArrayFile byteArrayFile) {
        this.file = byteArrayFile;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.file.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.file.write(byArray, 0, byArray.length);
    }

    @Override
    public void seek(long l) throws IOException {
        this.flush();
        this.file.seek((int)l);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    public ByteArrayFile getByteArrayFile() {
        return this.file;
    }
}

