/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal.ioutils;

import java.util.ArrayList;

public class ByteArrayFile {
    protected int maxIncrementMultiplier = 16;
    protected int incrementSize;
    private int posBlock = 0;
    private int posBlockIdx = 0;
    private int posBlockSize = 0;
    protected int pos = 0;
    protected int count = 0;
    private int bufSize = 0;
    private ArrayList<byte[]> list;

    public ByteArrayFile() {
        this(0);
    }

    public ByteArrayFile(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.incrementSize = n == 0 ? 4096 : n;
        this.list = new ArrayList(4);
        this.grow();
    }

    public ByteArrayFile(ByteArrayFile byteArrayFile) {
        this.incrementSize = byteArrayFile.incrementSize;
        this.list = byteArrayFile.list;
        this.maxIncrementMultiplier = byteArrayFile.maxIncrementMultiplier;
        this.count = byteArrayFile.count;
        this.bufSize = byteArrayFile.bufSize;
        this.pos = byteArrayFile.pos;
        this.posBlock = -1;
    }

    public int getFilePointer() {
        return this.pos;
    }

    public int length() {
        return this.count;
    }

    int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = this.pos;
        this.pos += n;
        if (this.pos >= this.count) {
            this.pos = this.count;
        }
        return this.pos - n2;
    }

    public void seek(int n) {
        this.pos = n;
    }

    private void ensureCapacity(int n) {
        if (n > this.bufSize) {
            this.grow(n - this.bufSize);
        }
    }

    private void grow() {
        this.grow(0);
    }

    private void grow(int n) {
        int n2;
        int n3 = this.list.size();
        if (n3 > this.maxIncrementMultiplier) {
            n3 = this.maxIncrementMultiplier;
        }
        if ((n2 = n / this.incrementSize + 1) > n3) {
            n3 = n2;
        }
        int n4 = this.incrementSize * n3;
        this.list.add(new byte[n4]);
        this.bufSize += n4;
    }

    public void setLength(int n) {
        this.ensureCapacity(n);
        this.count = n;
        if (this.pos > n) {
            this.pos = n;
        }
    }

    private void setBlockPos(int n) {
        if (n == this.posBlock) {
            return;
        }
        if (n < this.posBlock) {
            this.posBlock = 0;
            this.posBlockIdx = 0;
            this.posBlockSize = 0;
        } else if (n > this.count) {
            n = this.count;
        }
        int n2 = this.posBlockSize;
        while (n >= n2 && this.list.size() > this.posBlockIdx && n >= (n2 += this.list.get(this.posBlockIdx).length)) {
            ++this.posBlockIdx;
            this.posBlockSize = n2;
        }
        this.posBlock = n;
    }

    private void ensureCount(int n) {
        if (n > this.count) {
            this.ensureCapacity(n);
            this.count = n;
        }
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        this.setBlockPos(this.pos);
        int n3 = 0;
        int n4 = this.posBlockIdx;
        int n5 = this.pos - this.posBlockSize;
        this.setBlockPos(this.pos + n2);
        this.pos = this.posBlock;
        int n6 = this.posBlockIdx;
        int n7 = this.pos - this.posBlockSize;
        while (n4 <= n6 && this.list.size() > n4) {
            byte[] byArray2 = this.list.get(n4);
            int n8 = n4 == n6 ? n7 : byArray2.length;
            int n9 = n8 - n5;
            System.arraycopy(byArray2, n5, byArray, n, n9);
            n5 = 0;
            ++n4;
            n += n9;
            n3 += n9;
        }
        return n3;
    }

    public void write(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.ensureCount(this.pos + n2);
        this.setBlockPos(this.pos);
        int n3 = this.posBlockIdx;
        int n4 = this.pos - this.posBlockSize;
        this.pos += n2;
        this.setBlockPos(this.pos);
        int n5 = this.posBlockIdx;
        int n6 = this.pos - this.posBlockSize;
        while (n3 <= n5 && this.list.size() > n3) {
            byte[] byArray2 = this.list.get(n3);
            int n7 = n3 == n5 ? n6 : byArray2.length;
            int n8 = n7 - n4;
            System.arraycopy(byArray, n, byArray2, n4, n8);
            n4 = 0;
            ++n3;
            n += n8;
        }
    }

    public byte[] getByteBuffer() {
        if (this.count == 0) {
            return new byte[0];
        }
        if (this.count == this.bufSize && this.list.size() == 1) {
            return this.list.get(0);
        }
        byte[] byArray = new byte[this.count];
        int n = this.pos;
        this.pos = 0;
        this.read(byArray, 0, this.count);
        this.pos = n;
        this.list.clear();
        this.list.add(byArray);
        this.setBlockPos(0);
        this.bufSize = this.count;
        return byArray;
    }

    public void trimToSize() {
        this.getByteBuffer();
    }
}

