/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.DiffArgs;
import com.ibm.rcp.diff.internal.DiffFactory;
import com.ibm.rcp.diff.internal.DiffMessage;
import com.ibm.rcp.diff.internal.JBPatch;
import com.ibm.rcp.diff.internal.TreeFileDiff;
import com.ibm.rcp.diff.internal.Util;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFile;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileInputStream;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipFilePatch {
    public static final String VERSION_NUM = "0.1.1";
    public static final int VERSION_ID = 257;
    private static final String CLASS_NAME = ZipFilePatch.class.getSimpleName();
    private static final String NAME_BASE = CLASS_NAME.substring(0, CLASS_NAME.length() - 5) + "Diff";
    public static final String VERSION = NAME_BASE + "_" + "0.1.1";
    public static final String LIST_NAME = NAME_BASE + ".dat";
    public static final String VERSION_NAME = "version";
    public static final String CORE_DIFF_NAME = "core.diff";
    public static final String POST_DIFF_NAME = "post.diff";
    protected DiffMessage msg;
    protected DiffFactory factory;
    private byte[] versionBytesCache;
    private byte[] fileListBytesCache;
    private byte[] coreFileBytesCache;
    private byte[] postFileBytesCache;

    protected ZipFilePatch(DiffMessage diffMessage, DiffFactory diffFactory) {
        this.msg = diffMessage;
        this.factory = diffFactory;
    }

    private byte[] getDiffContents(String string, ZipInputStream zipInputStream) throws IOException {
        if (this.versionBytesCache != null && string.equals(VERSION_NAME)) {
            byte[] byArray = this.versionBytesCache;
            this.versionBytesCache = null;
            return byArray;
        }
        if (this.fileListBytesCache != null && string.equals(LIST_NAME)) {
            byte[] byArray = this.fileListBytesCache;
            this.fileListBytesCache = null;
            return byArray;
        }
        if (this.coreFileBytesCache != null && string.equals(CORE_DIFF_NAME)) {
            byte[] byArray = this.coreFileBytesCache;
            this.coreFileBytesCache = null;
            return byArray;
        }
        if (this.postFileBytesCache != null && string.equals(POST_DIFF_NAME)) {
            byte[] byArray = this.postFileBytesCache;
            this.postFileBytesCache = null;
            return byArray;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                byte[] byArray = Util.getStreamBytes(zipInputStream);
                if (zipEntry.getName().equals(string)) {
                    return byArray;
                }
                if (zipEntry.getName().equals(VERSION_NAME)) {
                    this.versionBytesCache = byArray;
                    continue;
                }
                if (zipEntry.getName().equals(LIST_NAME)) {
                    this.fileListBytesCache = byArray;
                    continue;
                }
                if (zipEntry.getName().equals(CORE_DIFF_NAME)) {
                    this.coreFileBytesCache = byArray;
                    continue;
                }
                if (!zipEntry.getName().equals(POST_DIFF_NAME)) continue;
                this.postFileBytesCache = byArray;
            }
        }
        catch (IOException iOException) {
            throw new IOException("Error reading diff file contents.", iOException);
        }
        return null;
    }

    protected CtrlData getCtrlData(ZipInputStream zipInputStream) throws IOException {
        CtrlData ctrlData = new CtrlData();
        ctrlData.fileList = new HashSet();
        byte[] byArray = this.getDiffContents(LIST_NAME, zipInputStream);
        if (byArray == null) {
            return ctrlData;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ctrlData.getCtrlData(dataInputStream);
        try {
            while (true) {
                String string = dataInputStream.readUTF();
                ctrlData.fileList.add(string);
            }
        }
        catch (EOFException eOFException) {
            return ctrlData;
        }
    }

    public void zipPatch(File file, File file2, File file3) throws IOException {
        this.msg.msgln(2, 0, "Patching zip file diff file \"" + file3.getPath() + "\" from \"" + file.getPath() + "\" to \"" + file2.getPath() + "\"...");
        this.msg.addIndent(1);
        ZipFile zipFile = new ZipFile(file);
        ZipInputStream zipInputStream = System.getProperty("java.version").startsWith("1.6") ? new ZipInputStream(new FileInputStream(file3)) : new ZipInputStream((InputStream)new FileInputStream(file3), Charset.forName("US-ASCII"));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.zipPatch(zipFile, (OutputStream)fileOutputStream, zipInputStream);
        ((OutputStream)fileOutputStream).close();
        zipInputStream.close();
        zipFile.close();
        this.msg.addIndent(-1);
        this.msg.msgln(2, 0, "zip file patch success!! target file size=" + file2.length());
    }

    public void zipPatch(ZipFile zipFile, OutputStream outputStream, InputStream inputStream) throws IOException {
        ZipInputStream zipInputStream = System.getProperty("java.version").startsWith("1.6") ? new ZipInputStream(inputStream) : new ZipInputStream(inputStream, Charset.forName("US-ASCII"));
        this.zipPatch(zipFile, outputStream, zipInputStream);
    }

    public void zipPatch(ZipFile zipFile, OutputStream outputStream, ZipInputStream zipInputStream) throws IOException {
        Object object;
        CtrlData ctrlData = this.getCtrlData(zipInputStream);
        JBPatch jBPatch = this.factory.getJBPatch(this.msg);
        byte[] byArray = Util.getFileBytes(new File(zipFile.getName()));
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        this.msg.msgln(3, 0, "orig file name=" + zipFile.getName() + ", orig file length=" + byArray.length + ", crc=" + (int)cRC32.getValue());
        if (byArray.length != ctrlData.oldFileSize) {
            throw new IOException("Invalid old zip file size: " + byArray.length + ", expected " + ctrlData.oldFileSize);
        }
        if ((int)cRC32.getValue() != ctrlData.oldFileCrc) {
            throw new IOException("Invalid old zip file CRC: " + (int)cRC32.getValue() + ", expected " + ctrlData.oldFileCrc);
        }
        ByteArrayFile byteArrayFile = new ByteArrayFile();
        ByteArrayFileOutputStream byteArrayFileOutputStream = new ByteArrayFileOutputStream(byteArrayFile);
        ZipOutputStream zipOutputStream = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(byteArrayFileOutputStream) : new ZipOutputStream((OutputStream)byteArrayFileOutputStream, Charset.forName("US-ASCII"));
        Util.uncompressZip(zipFile, zipOutputStream, null);
        zipOutputStream.finish();
        zipOutputStream.close();
        byteArrayFile.seek(0);
        cRC32 = new CRC32();
        cRC32.update(byteArrayFile.getByteBuffer());
        this.msg.msgln(3, 0, "inflated orig file length=" + byteArrayFile.length() + ", crc=" + (int)cRC32.getValue());
        if (byteArrayFile.length() != ctrlData.inflatedOldFileSize) {
            throw new IOException("Invalid old zip file size after inflation: " + byteArrayFile + ", expected " + ctrlData.inflatedOldFileSize);
        }
        if ((int)cRC32.getValue() != ctrlData.inflatedOldFileCrc) {
            throw new IOException("Invalid old zip file CRC after inflation: " + (int)cRC32.getValue() + ", expected " + ctrlData.inflatedOldFileCrc);
        }
        ByteArrayFile byteArrayFile2 = new ByteArrayFile();
        if (ctrlData.corePatchSize != 0) {
            object = this.getDiffContents(CORE_DIFF_NAME, zipInputStream);
            if (object == null) {
                throw new IOException("Unable to find core patch data.");
            }
            cRC32 = new CRC32();
            cRC32.update((byte[])object);
            this.msg.msgln(3, 0, "inflated file diff length=" + ((byte[])object).length + ", crc=" + (int)cRC32.getValue());
            if (((byte[])object).length != ctrlData.corePatchSize) {
                throw new IOException("Invalid core patch file size: " + ((byte[])object).length + ", expected " + ctrlData.corePatchSize);
            }
            if ((int)cRC32.getValue() != ctrlData.corePatchCrc) {
                throw new IOException("Invalid core patch file CRC: " + (int)cRC32.getValue() + ", expected " + ctrlData.corePatchCrc);
            }
            jBPatch.bspatch((InputStream)new ByteArrayFileInputStream(byteArrayFile), (OutputStream)new ByteArrayFileOutputStream(byteArrayFile2), (InputStream)new ByteArrayInputStream((byte[])object));
            cRC32 = new CRC32();
            cRC32.update(byteArrayFile2.getByteBuffer());
            this.msg.msgln(3, 0, "inflated target file length=" + byteArrayFile2.length() + ", crc=" + (int)cRC32.getValue());
            if (byteArrayFile2.length() != ctrlData.inflatedNewFileSize) {
                throw new IOException("Invalid inflated file size after applying core patch: " + byteArrayFile2.length() + ", expected " + ctrlData.inflatedNewFileSize);
            }
            if ((int)cRC32.getValue() != ctrlData.inflatedNewFileCrc) {
                throw new IOException("Invalid inflated patch file CRC after applying core patch: " + (int)cRC32.getValue() + ", expected " + ctrlData.inflatedNewFileCrc);
            }
            object = null;
            System.gc();
            byteArrayFile2.seek(0);
        } else {
            byteArrayFile2 = byteArrayFile;
        }
        object = new CRC32();
        DataOutputStream dataOutputStream = new DataOutputStream(new CheckedOutputStream(outputStream, (Checksum)object));
        ZipInputStream zipInputStream2 = System.getProperty("java.version").startsWith("1.6") ? new ZipInputStream(new ByteArrayFileInputStream(byteArrayFile2)) : new ZipInputStream((InputStream)new ByteArrayFileInputStream(byteArrayFile2), Charset.forName("US-ASCII"));
        if (ctrlData.postPatchSize != 0) {
            byte[] byArray2 = this.getDiffContents(POST_DIFF_NAME, zipInputStream);
            if (byArray2 == null) {
                throw new IOException("Unable to find post patch data.");
            }
            cRC32 = new CRC32();
            cRC32.update(byArray2);
            this.msg.msgln(3, 0, "post file diff length=" + byArray2.length + ", crc=" + (int)cRC32.getValue());
            if (byArray2.length != ctrlData.postPatchSize) {
                throw new IOException("Invalid post patch file size: " + byArray2.length + ", expected " + ctrlData.postPatchSize);
            }
            if ((int)cRC32.getValue() != ctrlData.postPatchCrc) {
                throw new IOException("Invalid core patch file CRC: " + (int)cRC32.getValue() + ", expected " + ctrlData.corePatchCrc);
            }
            ByteArrayFile byteArrayFile3 = new ByteArrayFile();
            ZipOutputStream zipOutputStream2 = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(new ByteArrayFileOutputStream(byteArrayFile3)) : new ZipOutputStream((OutputStream)new ByteArrayFileOutputStream(byteArrayFile3), Charset.forName("US-ASCII"));
            Util.compressZip(zipInputStream2, zipOutputStream2, ctrlData.fileList);
            zipOutputStream2.finish();
            byteArrayFile2 = null;
            byteArrayFile3.seek(0);
            cRC32 = new CRC32();
            cRC32.update(byteArrayFile3.getByteBuffer());
            this.msg.msgln(3, 0, "re-deflated target file diff length=" + byteArrayFile3.length() + ", crc=" + (int)cRC32.getValue());
            if (byteArrayFile3.length() != ctrlData.deflatedPostFileSize) {
                throw new IOException("Invalid post patch file size after deflation, " + zipFile.getName() + ", " + byteArrayFile3.length() + ", expected " + ctrlData.deflatedPostFileSize);
            }
            if ((int)cRC32.getValue() != ctrlData.deflatedPostFileCrc) {
                throw new IOException("Invalid post patch file CRC after deflation: " + (int)cRC32.getValue() + ", expected " + ctrlData.deflatedPostFileCrc);
            }
            jBPatch.bspatch((InputStream)new ByteArrayFileInputStream(byteArrayFile3), (OutputStream)dataOutputStream, (InputStream)new ByteArrayInputStream(byArray2));
            byteArrayFile3 = null;
        } else {
            ZipOutputStream zipOutputStream3 = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(dataOutputStream) : new ZipOutputStream((OutputStream)dataOutputStream, Charset.forName("US-ASCII"));
            Util.compressZip(zipInputStream2, zipOutputStream3, ctrlData.fileList);
            zipOutputStream3.finish();
        }
        this.msg.msgln(3, 0, "target file diff length=" + dataOutputStream.size() + ", crc=" + (int)object.getValue());
        if (dataOutputStream.size() != ctrlData.newFileSize) {
            throw new IOException("Invalid new file size: " + dataOutputStream.size() + ", expected " + ctrlData.newFileSize);
        }
        if ((int)object.getValue() != ctrlData.newFileCrc) {
            throw new IOException("Invalid core patch file CRC: " + (int)object.getValue() + ", expected " + ctrlData.newFileCrc);
        }
    }

    public static void main(String[] stringArray) {
        DiffArgs diffArgs = Util.getArgs(stringArray, TreeFileDiff.class.getName(), null);
        if (diffArgs == null) {
            return;
        }
        ZipFilePatch zipFilePatch = DiffFactory.getDiffFactory().getZipFilePatch(new DiffMessage(diffArgs.out, diffArgs.err, diffArgs.verboseLevel, 0));
        try {
            zipFilePatch.zipPatch(diffArgs.src.get(0), diffArgs.dst, diffArgs.diffArchive);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(diffArgs.err);
        }
    }

    protected static class CtrlData {
        static final int VERSION_ID = 257;
        static final int F_UncompressedZipFileDiff = 1;
        HashSet<String> fileList;
        int flags;
        int fileListCount;
        int oldFileSize;
        int oldFileCrc;
        int newFileSize;
        int newFileCrc;
        int inflatedOldFileSize;
        int inflatedOldFileCrc;
        int inflatedNewFileSize;
        int inflatedNewFileCrc;
        int corePatchCrc;
        int corePatchSize;
        int deflatedPostFileSize;
        int deflatedPostFileCrc;
        int postPatchSize;
        int postPatchCrc;

        protected CtrlData() {
        }

        void saveCtrlData(DataOutputStream dataOutputStream, int n) throws IOException {
            dataOutputStream.writeInt(64);
            dataOutputStream.writeInt(257);
            dataOutputStream.writeInt(this.flags);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(this.oldFileSize);
            dataOutputStream.writeInt(this.oldFileCrc);
            dataOutputStream.writeInt(this.newFileSize);
            dataOutputStream.writeInt(this.newFileCrc);
            dataOutputStream.writeInt(this.inflatedOldFileSize);
            dataOutputStream.writeInt(this.inflatedOldFileCrc);
            dataOutputStream.writeInt(this.inflatedNewFileSize);
            dataOutputStream.writeInt(this.inflatedNewFileCrc);
            dataOutputStream.writeInt(this.corePatchCrc);
            dataOutputStream.writeInt(this.corePatchSize);
            dataOutputStream.writeInt(this.deflatedPostFileSize);
            dataOutputStream.writeInt(this.deflatedPostFileCrc);
            dataOutputStream.writeInt(this.postPatchSize);
            dataOutputStream.writeInt(this.postPatchCrc);
        }

        void getCtrlData(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n < 64 || n % 4 != 0) {
                throw new IOException("Invalid CtrlData size: " + n);
            }
            int n2 = dataInputStream.readInt();
            if (n2 != 257) {
                throw new IOException("Invalid CtrlData version id: 0x" + Integer.toHexString(n2));
            }
            this.flags = dataInputStream.readInt();
            this.fileListCount = dataInputStream.readInt();
            this.oldFileSize = dataInputStream.readInt();
            this.oldFileCrc = dataInputStream.readInt();
            this.newFileSize = dataInputStream.readInt();
            this.newFileCrc = dataInputStream.readInt();
            this.inflatedOldFileSize = dataInputStream.readInt();
            this.inflatedOldFileCrc = dataInputStream.readInt();
            this.inflatedNewFileSize = dataInputStream.readInt();
            this.inflatedNewFileCrc = dataInputStream.readInt();
            this.corePatchCrc = dataInputStream.readInt();
            this.corePatchSize = dataInputStream.readInt();
            this.deflatedPostFileSize = dataInputStream.readInt();
            this.deflatedPostFileCrc = dataInputStream.readInt();
            this.postPatchSize = dataInputStream.readInt();
            this.postPatchCrc = dataInputStream.readInt();
            for (int i = 64; i < n; i += 4) {
                dataInputStream.readInt();
            }
        }
    }
}

