/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.DiffArgs;
import com.ibm.rcp.diff.internal.DiffFactory;
import com.ibm.rcp.diff.internal.DiffMessage;
import com.ibm.rcp.diff.internal.TreeFileDiff;
import com.ibm.rcp.diff.internal.Util;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFile;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileInputStream;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileOutputStream;
import com.ibm.rcp.diff.internal.ioutils.RandomAccessFileInputStream;
import com.ibm.rcp.diff.internal.ioutils.RandomAccessInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;

public class JBPatch {
    static final String VERSION = "rcp-jbdiff-0.1.1";
    static final long MAGIC_VERSION = JBPatch.byteToLong("rcpdif01");
    DiffMessage msg;

    protected JBPatch(DiffMessage diffMessage) {
        this.msg = diffMessage;
    }

    private static long byteToLong(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -1L;
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l += ((long)byArray[i] & 0xFFL) << (7 - i << 3);
        }
        return l;
    }

    protected long[] getHeader(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        long[] lArray = new long[4];
        lArray[0] = dataInputStream.readLong();
        if (lArray[0] != MAGIC_VERSION) {
            throw new IOException("Corrupt patch - bad magic number");
        }
        lArray[1] = dataInputStream.readLong();
        lArray[2] = dataInputStream.readLong();
        lArray[3] = (int)dataInputStream.readLong();
        this.msg.msgln(3, 0, "diff patch ctrlBlock size=" + lArray[1] + ", diffBlock size=" + lArray[2] + ", ebBlock size=" + lArray[3]);
        return lArray;
    }

    public void bspatch(InputStream inputStream, OutputStream outputStream, InputStream inputStream2) throws IOException {
        ByteArrayFile byteArrayFile = Util.getStreamByteArrayFile(inputStream2);
        byteArrayFile.seek(0);
        ByteArrayFileInputStream byteArrayFileInputStream = new ByteArrayFileInputStream(byteArrayFile);
        long[] lArray = this.getHeader(byteArrayFileInputStream);
        ByteArrayFileInputStream byteArrayFileInputStream2 = new ByteArrayFileInputStream(new ByteArrayFile(byteArrayFile));
        byteArrayFileInputStream2.getByteArrayFile().seek(0);
        byteArrayFileInputStream2.skip(lArray[1] + 32L);
        ByteArrayFileInputStream byteArrayFileInputStream3 = new ByteArrayFileInputStream(new ByteArrayFile(byteArrayFile));
        byteArrayFileInputStream3.getByteArrayFile().seek(0);
        byteArrayFileInputStream3.skip(lArray[2] + lArray[1] + 32L);
        byteArrayFile = Util.getStreamByteArrayFile(inputStream);
        byteArrayFile.seek(0);
        ByteArrayFileInputStream byteArrayFileInputStream4 = new ByteArrayFileInputStream(byteArrayFile);
        this.bspatch(byteArrayFileInputStream4, outputStream, lArray[3], byteArrayFileInputStream, byteArrayFileInputStream2, byteArrayFileInputStream3);
    }

    public void bspatch(File file, File file2, File file3) throws IOException {
        this.msg.msgln(2, 0, "Patching via rcp-bsdiff diff file \"" + file3.getPath() + "\" from \"" + file.getPath() + "\" to \"" + file2.getPath() + "\"...");
        this.msg.addIndent(1);
        RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(file, "r");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        this.bspatch(randomAccessFileInputStream, (OutputStream)bufferedOutputStream, file3);
        randomAccessFileInputStream.close();
        bufferedOutputStream.close();
        this.msg.addIndent(-1);
        this.msg.msgln(2, 0, "rcp-bsdiff patch success!! target file size=" + file2.length());
    }

    public void bspatch(File file, OutputStream outputStream, InputStream inputStream) throws IOException {
        ByteArrayFile byteArrayFile = Util.getStreamByteArrayFile(inputStream);
        byteArrayFile.seek(0);
        ByteArrayFileInputStream byteArrayFileInputStream = new ByteArrayFileInputStream(byteArrayFile);
        long[] lArray = this.getHeader(byteArrayFileInputStream);
        ByteArrayFileInputStream byteArrayFileInputStream2 = new ByteArrayFileInputStream(new ByteArrayFile(byteArrayFile));
        byteArrayFileInputStream2.getByteArrayFile().seek(0);
        byteArrayFileInputStream2.skip(lArray[1] + 32L);
        ByteArrayFileInputStream byteArrayFileInputStream3 = new ByteArrayFileInputStream(new ByteArrayFile(byteArrayFile));
        byteArrayFileInputStream3.getByteArrayFile().seek(0);
        byteArrayFileInputStream3.skip(lArray[2] + lArray[1] + 32L);
        RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(file, "r");
        this.bspatch(randomAccessFileInputStream, outputStream, lArray[3], byteArrayFileInputStream, byteArrayFileInputStream2, byteArrayFileInputStream3);
        ((InputStream)randomAccessFileInputStream).close();
    }

    public void bspatch(RandomAccessInputStream randomAccessInputStream, OutputStream outputStream, File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        long[] lArray = this.getHeader(bufferedInputStream);
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.skip(lArray[1] + 32L);
        FileInputStream fileInputStream2 = new FileInputStream(file);
        fileInputStream2.skip(lArray[2] + lArray[1] + 32L);
        byte[] byArray = new byte[65536];
        ByteArrayFileOutputStream byteArrayFileOutputStream = new ByteArrayFileOutputStream(randomAccessInputStream.available());
        while ((n = randomAccessInputStream.read(byArray)) != -1) {
            byteArrayFileOutputStream.write(byArray, 0, n);
        }
        ByteArrayFile byteArrayFile = byteArrayFileOutputStream.getByteArrayFile();
        byteArrayFile.seek(0);
        ByteArrayFileInputStream byteArrayFileInputStream = new ByteArrayFileInputStream(byteArrayFile);
        byArray = null;
        this.bspatch(byteArrayFileInputStream, outputStream, lArray[3], bufferedInputStream, fileInputStream, fileInputStream2);
        fileInputStream2.close();
        fileInputStream.close();
        ((InputStream)bufferedInputStream).close();
    }

    protected void bspatch(RandomAccessInputStream randomAccessInputStream, OutputStream outputStream, long l, InputStream inputStream, InputStream inputStream2, InputStream inputStream3) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(inputStream));
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream2);
        GZIPInputStream gZIPInputStream2 = new GZIPInputStream(inputStream3);
        byte[] byArray = new byte[65536];
        byte[] byArray2 = new byte[65536];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[3];
        while ((long)n3 < l) {
            int n4;
            int n5;
            int n6;
            for (n6 = 0; n6 <= 2; ++n6) {
                nArray[n6] = dataInputStream.readInt();
            }
            this.msg.msgln(5, 1, "patching ctrlBlock: diffLen=" + nArray[0] + ", ebLen=" + nArray[1] + ", seek=" + nArray[2]);
            if ((long)(n3 + nArray[0]) > l) {
                throw new IOException("Corrupt patch - ctrl0 past newsize");
            }
            n6 = nArray[0];
            while (n6 > 0) {
                int n7;
                n5 = byArray.length;
                if (n5 > n6) {
                    n5 = n6;
                }
                if ((n4 = gZIPInputStream.read(byArray, 0, n5)) == -1) {
                    throw new IOException("Corrupt patch - diffBlock eof");
                }
                int n8 = n2 + nArray[0] - n6;
                int n9 = 0;
                if (n2 < 0) {
                    System.out.println("got one");
                    n7 = 0 - n2;
                    if (n7 < n5) {
                        n5 -= n7;
                        n9 = n7;
                        n8 = 0;
                    } else {
                        n5 = 0;
                    }
                }
                if (n5 > 0) {
                    randomAccessInputStream.seek(n8);
                    n7 = randomAccessInputStream.read(byArray2, 0, n5);
                    for (int i = n9; i < n7; ++i) {
                        int n10 = i;
                        byArray[n10] = (byte)(byArray[n10] + byArray2[i]);
                    }
                } else {
                    System.out.println("skipping " + nArray[0]);
                }
                outputStream.write(byArray, 0, n4);
                n6 -= n4;
                n += n4;
            }
            n2 += nArray[0];
            if ((long)((n3 += nArray[0]) + nArray[1]) > l) {
                throw new IOException("Corrupt patch - ctrl1 past newsize");
            }
            n6 = nArray[1];
            while (n6 > 0) {
                n5 = byArray.length;
                if (n5 > n6) {
                    n5 = n6;
                }
                if ((n4 = gZIPInputStream2.read(byArray, 0, n5)) == -1) {
                    throw new IOException("Corrupt patch - extraBlock eof");
                }
                outputStream.write(byArray, 0, n4);
                n6 -= n4;
                n += n4;
            }
            n3 += nArray[1];
            n2 += nArray[2];
        }
    }

    public static void main(String[] stringArray) throws IOException {
        DiffArgs diffArgs = Util.getArgs(stringArray, TreeFileDiff.class.getName(), null);
        if (diffArgs == null) {
            return;
        }
        JBPatch jBPatch = DiffFactory.getDiffFactory().getJBPatch(new DiffMessage(diffArgs.out, diffArgs.err, diffArgs.verboseLevel, 0));
        try {
            jBPatch.bspatch(diffArgs.src.get(0), diffArgs.dst, diffArgs.diffArchive);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(diffArgs.err);
        }
    }
}

