/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp.resource;

import com.ibm.lex.lapapp.LAPConstants;
import java.util.Locale;
import java.util.Vector;

public class SupportedLanguages {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2015.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Locale CZECH = new Locale("cs", "");
    public static final Locale ENGLISH = new Locale("en", "");
    public static final Locale FRENCH = new Locale("fr", "");
    public static final Locale GERMAN = new Locale("de", "");
    public static final Locale GREEK = new Locale("el", "");
    public static final Locale INDONESIAN = new Locale("in", "");
    public static final Locale ITALIAN = new Locale("it", "");
    public static final Locale JAPANESE = new Locale("ja", "");
    public static final Locale KOREAN = new Locale("ko", "");
    public static final Locale LITHUANIAN = new Locale("lt", "");
    public static final Locale POLISH = new Locale("pl", "");
    public static final Locale PORTUGUESE = new Locale("pt", "");
    public static final Locale RUSSIAN = new Locale("ru", "");
    public static final Locale SLOVENIAN = new Locale("sl", "");
    public static final Locale SPANISH = new Locale("es", "");
    public static final Locale TURKISH = new Locale("tr", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW");
    public static final Locale DEFAULT_LANGUAGE = LAPConstants.DEFAULT_LOCALE;
    private static final Locale defaultLocale = LAPConstants.DEFAULT_LOCALE;
    private Locale[] _supportedLocales = null;
    private static Locale[] _languageSet3 = new Locale[]{CZECH, ENGLISH, FRENCH, GERMAN, ITALIAN, JAPANESE, KOREAN, POLISH, PORTUGUESE, SPANISH, SIMPLIFIED_CHINESE, TRADITIONAL_CHINESE, TURKISH};
    private static Locale[] _languageSet4 = new Locale[]{CZECH, ENGLISH, FRENCH, GERMAN, GREEK, ITALIAN, JAPANESE, KOREAN, LITHUANIAN, POLISH, PORTUGUESE, RUSSIAN, SLOVENIAN, SPANISH, SIMPLIFIED_CHINESE, TRADITIONAL_CHINESE, TURKISH};
    private static Locale[] _languageSet5 = new Locale[]{CZECH, ENGLISH, FRENCH, GERMAN, GREEK, INDONESIAN, ITALIAN, JAPANESE, KOREAN, LITHUANIAN, POLISH, PORTUGUESE, RUSSIAN, SLOVENIAN, SPANISH, SIMPLIFIED_CHINESE, TRADITIONAL_CHINESE, TURKISH};
    private static final Locale[] _dbcsLocales = new Locale[]{JAPANESE, KOREAN, SIMPLIFIED_CHINESE, TRADITIONAL_CHINESE};

    public SupportedLanguages(String string, boolean bl) {
        Locale[] localeArray = string.equals("3") ? _languageSet3 : (string.equals("4") ? _languageSet4 : (string.equals("5") ? _languageSet5 : new Locale[]{}));
        if (!bl) {
            this._supportedLocales = localeArray;
        } else {
            Vector<Locale> vector = new Vector<Locale>();
            for (int i = 0; i < localeArray.length; ++i) {
                if (SupportedLanguages.isDBCSLocale(localeArray[i])) continue;
                vector.add(localeArray[i]);
            }
            this._supportedLocales = vector.toArray(new Locale[0]);
        }
    }

    public Locale getSupportedLocale(Locale locale) {
        Locale locale2 = null;
        for (int i = 0; i < this._supportedLocales.length; ++i) {
            if (!locale.equals(this._supportedLocales[i])) continue;
            locale2 = this._supportedLocales[i];
            break;
        }
        if (locale2 == null) {
            if (locale.getCountry().equals("")) {
                return defaultLocale;
            }
            return this.getSupportedLocale(new Locale(locale.getLanguage(), ""));
        }
        return locale2;
    }

    public Locale[] getSupportedLocales() {
        return this._supportedLocales;
    }

    public static boolean isDBCSLocale(Locale locale) {
        for (int i = 0; i < _dbcsLocales.length; ++i) {
            if (!locale.equals(_dbcsLocales[i])) continue;
            return true;
        }
        return false;
    }
}

