/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.lex.lapapp.ConfirmDialog;
import com.ibm.lex.lapapp.LicenseAcceptanceProcess;
import com.ibm.lex.lapapp.resource.LAPResources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class TextPrinter
implements Runnable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private double tMargin = 0.5;
    private double lMargin = 0.5;
    private double bMargin = 0.5;
    private double rMargin = 0.5;
    private double hMargin = 0.5;
    private double spacing = 1.0;
    private String[] paragraphs;
    private Thread printThread;
    private Font font;
    protected String okButName = "OK";
    private JDialog parentFrame;
    private LicenseAcceptanceProcess model;
    private LAPResources lapResources;
    private PrintTaskDistributor controller;
    private boolean controlFontSize;
    private JButton acceptButton;
    private Font guiFont;
    private Color background;
    private Dimension screenSize;
    private Rectangle bounds;
    private ConfirmDialog dialog;

    public TextPrinter(String[] stringArray, JDialog jDialog, LicenseAcceptanceProcess licenseAcceptanceProcess, LAPResources lAPResources, boolean bl, JButton jButton, Font font, Color color, Dimension dimension, Rectangle rectangle) {
        this.paragraphs = stringArray;
        this.parentFrame = jDialog;
        this.model = licenseAcceptanceProcess;
        this.lapResources = lAPResources;
        this.controlFontSize = bl;
        this.acceptButton = jButton;
        this.guiFont = font;
        this.background = color;
        this.screenSize = dimension;
        this.bounds = rectangle;
        this.font = font;
        this.controller = new PrintTaskDistributor();
    }

    public TextPrinter(String string, JDialog jDialog, LicenseAcceptanceProcess licenseAcceptanceProcess, LAPResources lAPResources, boolean bl, JButton jButton, Font font, Color color, Dimension dimension, Rectangle rectangle) {
        this.paragraphs = new String[1];
        this.paragraphs[0] = string;
        this.parentFrame = jDialog;
        this.model = licenseAcceptanceProcess;
        this.lapResources = lAPResources;
        this.controlFontSize = bl;
        this.acceptButton = jButton;
        this.guiFont = font;
        this.background = color;
        this.screenSize = dimension;
        this.bounds = rectangle;
        this.font = font;
        this.controller = new PrintTaskDistributor();
    }

    private void onOK() {
        this.dialog.dispose();
        this.dialog = null;
    }

    public void print() {
        if (this.printThread == null || !this.printThread.isAlive()) {
            this.printThread = new Thread(this);
            try {
                this.printThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                illegalThreadStateException.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        int n;
        JFrame jFrame = new JFrame();
        if (this.font == null) {
            this.font = jFrame.getFont();
        }
        Locale locale = jFrame.getLocale();
        PrintJob printJob = jFrame.getToolkit().getPrintJob(jFrame, "Software License Agreement", null);
        if (printJob == null) {
            this.acceptButton.requestFocus();
            return;
        }
        Graphics graphics = printJob.getGraphics();
        if (graphics == null) {
            this.acceptButton.requestFocus();
            return;
        }
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n2 = fontMetrics.getHeight();
        Dimension dimension = printJob.getPageDimension();
        double d = (double)dimension.width / 8.5;
        int n3 = dimension.width - (int)((this.lMargin + this.rMargin + this.hMargin) * d);
        int n4 = dimension.height - (int)((this.tMargin + this.bMargin + this.hMargin) * d);
        int n5 = (int)((double)n4 / ((double)n2 * this.spacing));
        String[] stringArray = this.model.getLAP().breakText(n3, fontMetrics.charWidth('0'), this.paragraphs, locale);
        int n6 = stringArray.length;
        int n7 = (int)(this.lMargin * d);
        int n8 = n = (int)(this.tMargin * d);
        for (int i = 0; i < n6; ++i) {
            graphics.drawString(stringArray[i], n7, n8 += n2);
            if ((i + 1) % n5 == 0 || i == n6 - 1) {
                graphics.dispose();
                graphics = printJob.getGraphics();
                if (graphics == null) {
                    return;
                }
                graphics.setFont(this.font);
                n8 = n;
            }
            n8 += (int)((double)n2 * (this.spacing - 1.0));
        }
        graphics.dispose();
        printJob.end();
        this.acceptButton.requestFocus();
    }

    public final void setFont(Font font) {
        this.font = font;
    }

    public final void setHiddenMargin(double d) {
        this.hMargin = d;
    }

    public void setMargin(double d, double d2, double d3, double d4) {
        this.tMargin = d;
        this.lMargin = d2;
        this.bMargin = d3;
        this.rMargin = d4;
    }

    public final void setSpacing(double d) {
        this.spacing = d;
    }

    class PrintTaskDistributor
    extends KeyAdapter
    implements ActionListener {
        private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        PrintTaskDistributor() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.dispatchTo(keyEvent.getComponent().getName());
            } else if (keyEvent.getKeyCode() == 9) {
                keyEvent.getComponent().transferFocus();
                keyEvent.consume();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComponent) {
                this.dispatchTo(((JComponent)object).getName());
            }
        }

        private void dispatchTo(String string) {
            if (string.equals(TextPrinter.this.okButName)) {
                TextPrinter.this.onOK();
            }
        }
    }
}

