/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.lex.lapapp.PrintInterface;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class PageableTextConsole
implements Pageable,
Printable,
PrintInterface {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2005, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String FONTFAMILY = "sansserif";
    public static int FONTSIZE = 10;
    public static int FONTSTYLE = 0;
    public static float LINESPACEFACTOR = 1.1f;
    PageFormat format;
    PrinterJob job;
    Vector lines;
    String[] paragraphs;
    Font font;
    int linespacing;
    int linesPerPage;
    int numPages;
    int baseline = -1;
    private Locale locale;
    private double tMargin = 1.0;
    private double lMargin = 1.0;
    private double bMargin = 1.0;
    private double rMargin = 1.0;
    private double hMargin = 1.0;

    @Override
    public void print(String[] stringArray, Locale locale) throws PrinterException {
        this.paragraphs = stringArray;
        this.locale = locale;
        this.job = PrinterJob.getPrinterJob();
        this.format = this.job.defaultPage();
        this.font = new Font(FONTFAMILY, FONTSTYLE, FONTSIZE);
        this.linespacing = (int)((float)FONTSIZE * LINESPACEFACTOR);
        double d = this.format.getHeight();
        double d2 = this.format.getImageableWidth() / 8.5;
        double d3 = this.format.getImageableWidth() - this.hMargin * d2;
        this.linesPerPage = (int)Math.floor(this.format.getImageableHeight() / (double)this.linespacing);
        this.lines = this.breakText(d3, this.paragraphs, this.locale);
        this.numPages = (this.lines.size() - 1) / this.linesPerPage + 1;
        this.job.setPageable(this);
        this.job.print();
    }

    @Override
    public int getNumberOfPages() {
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        return this.format;
    }

    @Override
    public Printable getPrintable(int n) {
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n < 0 | n >= this.numPages) {
            return 1;
        }
        if (this.baseline == -1) {
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            this.baseline = fontMetrics.getAscent();
        }
        graphics.setColor(Color.white);
        graphics.fillRect((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        graphics.setFont(this.font);
        graphics.setColor(Color.black);
        int n2 = n * this.linesPerPage;
        int n3 = n2 + this.linesPerPage - 1;
        if (n3 >= this.lines.size()) {
            n3 = this.lines.size() - 1;
        }
        int n4 = (int)pageFormat.getImageableX();
        int n5 = (int)pageFormat.getImageableY() + this.baseline;
        for (int i = n2; i <= n3; ++i) {
            String string = (String)this.lines.elementAt(i);
            if (string.length() > 0) {
                graphics.drawString(string, n4, n5);
            }
            n5 += this.linespacing;
        }
        return 0;
    }

    private Vector breakText(double d, String[] stringArray, Locale locale) {
        Canvas canvas = new Canvas();
        FontMetrics fontMetrics = canvas.getFontMetrics(this.font);
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            if (string == null) {
                string = " ";
            }
            breakIterator.setText(string);
            int n = breakIterator.first();
            int n2 = breakIterator.next();
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n4 = 0;
            while (n2 != -1) {
                String string2 = string.substring(n, n2);
                n4 = fontMetrics.stringWidth(string2);
                if ((double)(n3 + n4) > d) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string2);
                    n3 = n4;
                } else {
                    stringBuffer.append(string2);
                    n3 += n4;
                }
                n = n2;
                n2 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
        }
        vector.trimToSize();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return vector;
    }
}

