/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.hursley.devtools.Commandline;
import com.ibm.hursley.devtools.InvalidCommandlineArgument;
import com.ibm.lex.lapapp.Debug;
import com.ibm.lex.lapapp.JLAP;
import com.ibm.lex.lapapp.LAPConstants;
import com.ibm.lex.lapapp.License;
import com.ibm.lex.lapapp.LicenseAcceptanceProcess;
import com.ibm.lex.lapapp.PageableTextConsole;
import com.ibm.lex.lapapp.resource.LAPResources;
import com.ibm.lex.lapapp.resource.SupportedLanguages;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class LAP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2015.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String flags = "";
    private String[] longFlags = new String[]{""};
    private String options = "tlsm";
    private String[] longOptions = new String[]{"no_export", "no_print", "win_style", "win_color", "dialog_backcolor", "dialog_size", "font_name", "font_size", "font_style", "text_only", "register", "uid", "desc", "show_exit_code", "version", "setlang", "langset"};
    public static final String STATUS_OPT = "t";
    public static final String LA_PATH_OPT = "l";
    public static final String MASTER_PATH_OPT = "m";
    public static final String STATUS_PATH_OPT = "s";
    public static final String REVALIDATE_OPT = "revalidate";
    public static final String NO_PRINT_OPT = "no_print";
    public static final String NO_EXPORT_OPT = "no_export";
    public static final String WIN_STYLE_OPT = "win_style";
    public static final String WIN_COLOR_OPT = "win_color";
    public static final String DIALOG_BACKCOLOR_OPT = "dialog_backcolor";
    public static final String DIALOG_SIZE_OPT = "dialog_size";
    public static final String FONT_NAME_OPT = "font_name";
    public static final String FONT_STYLE_OPT = "font_style";
    public static final String FONT_SIZE_OPT = "font_size";
    public static final String ASKVERSION = "version";
    public static final String SETLANG = "setlang";
    public static final String LANGSET = "langset";
    public static final String TEXT_ONLY_OPT = "text_only";
    public static final String REG_OPT = "register";
    public static final String UNIQUE_ID_OPT = "uid";
    public static final String REG_DESC_OPT = "desc";
    public static final String SHOW_EXIT_CODE_OPT = "show_exit_code";
    public String laPath;
    private String mPath;
    private String statusPath;
    private boolean noExport = false;
    private boolean noPrint = false;
    private boolean bShowExitCode = false;
    private int cmdStatus = 1;
    private String winStyle = "1";
    private String winColorString;
    private String dialogBackcolorString;
    private String dialogSizeString;
    private String fontName = "sansserif";
    private String fontStyleString;
    private String fontSizeString;
    private boolean register = false;
    private String uniqueID;
    private String regDesc;
    private boolean textOnly = false;
    private boolean noExportLA = false;
    private LicenseAcceptanceProcess licenseAcceptanceProcess;
    private String languageSet = "5";
    private SupportedLanguages supportedLangs;
    protected String logoFileName = "logo.gif";
    protected String languageButName = "language";
    protected String acceptButName = "accept";
    protected String declineButName = "decline";
    protected String printButName = "print";
    protected String yesButName = "yes";
    protected String noButName = "no";
    private String[] textLines;
    private int cliFontWidth;
    private int linesPerPage;
    private Commandline cline;
    private int ExitCode = -1;
    private Locale langFromCommandLine = null;

    public LAP() {
    }

    public LAP(String[] stringArray) {
        try {
            if (System.getProperty("debug") != null) {
                Debug.enableOutput(System.getProperty("debug_filename"));
            }
            if (Debug.outputEnabled()) {
                Debug.println("Running LAP version: 2.13.0");
                for (int i = 0; i < stringArray.length; ++i) {
                    Debug.println("  args[" + Integer.toString(i) + "] = " + stringArray[i]);
                }
                Debug.println();
                Debug.printSystemProperties();
                Debug.println();
            }
            this.parseArgs(stringArray);
            this.setExportLA(!this.noExport);
            if (this.ExitCode == -1) {
                this.doLAP();
            }
        }
        catch (Exception exception) {
            Debug.printException(exception);
            System.out.println(exception.toString());
        }
    }

    public LAP(String[] stringArray, boolean bl) {
        try {
            if (System.getProperty("debug") != null) {
                Debug.enableOutput(System.getProperty("debug_filename"));
            }
            if (Debug.outputEnabled()) {
                Debug.println("Running LAP version: 2.13.0");
                for (int i = 0; i < stringArray.length; ++i) {
                    Debug.println("  args[" + Integer.toString(i) + "] = " + stringArray[i]);
                }
                Debug.println();
                Debug.printSystemProperties();
                Debug.println();
            }
            this.parseArgs(stringArray);
            this.setExportLA(!this.noExport);
            if (bl && this.ExitCode == -1) {
                this.doLAP();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public String[] breakText(int n, int n2, String[] stringArray, Locale locale) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            if (string == null) {
                string = " ";
            }
            breakIterator.setText(string);
            int n3 = breakIterator.first();
            int n4 = breakIterator.next();
            int n5 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n6 = 0;
            while (n4 != -1) {
                String string2 = string.substring(n3, n4);
                n6 = string2.length() * n2;
                if (n5 + n6 > n) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string2);
                    n5 = n6;
                } else {
                    stringBuffer.append(string2);
                    n5 += n6;
                }
                n3 = n4;
                n4 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
        }
        vector.trimToSize();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private int confirmDecline() {
        Locale locale = this.getLicenseAcceptanceProcess().getCurrentLocale();
        String[] stringArray = new String[]{this.getLicenseAcceptanceProcess().getLAPResources().getText("clicfmmsg")};
        String[] stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale);
        int n = -1;
        while (n != Integer.MIN_VALUE && n != 1 && n != 2) {
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println(stringArray2[i]);
            }
            n = this.getInput();
        }
        return n;
    }

    private String getCLIMessage() {
        String string = this.getLicenseAcceptanceProcess().isMultiLanguage() ? (this.getLicenseAcceptanceProcess().hasNonIBMFile() ? (this.printAvailable() ? "clicontmsgnonibm" : "clicontmsgnoprintnonibm") : (this.printAvailable() ? "clicontmsg" : "clicontmsgnoprint")) : (this.getLicenseAcceptanceProcess().hasNonIBMFile() ? (this.printAvailable() ? "clicontmsgengonlynonibm" : "clicontmsgengonlynoprintnonibm") : (this.printAvailable() ? "clicontmsgengonly" : "clicontmsgengonlynoprint"));
        Debug.println("Using msgKey : " + string);
        StringBuffer stringBuffer = new StringBuffer(this.getLicenseAcceptanceProcess().getLAPResources().getText(string));
        if (this.getLicenseAcceptanceProcess().isMultiLanguage() && this.getLicenseAcceptanceProcess().getCurrentLocale().equals(SupportedLanguages.DEFAULT_LANGUAGE)) {
            this.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLicenseAcceptanceProcess().nextLocale());
            stringBuffer = stringBuffer.replace(stringBuffer.indexOf("REPLACEWITHLANG"), stringBuffer.indexOf("REPLACEWITHLANG") + "REPLACEWITHLANG".length(), this.getLicenseAcceptanceProcess().getLAPResources().getText("language"));
            this.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLicenseAcceptanceProcess().nextLocale());
        }
        return stringBuffer.toString();
    }

    protected int displayLA() {
        Locale locale = this.getLicenseAcceptanceProcess().getCurrentLocale();
        this.getLicenseAcceptanceProcess().getLAPResources().setLocale(locale);
        String[] stringArray = new String[]{this.getCLIMessage()};
        String[] stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale);
        String[] stringArray3 = this.breakText(600, this.cliFontWidth, this.getLicenseAgreement(locale), locale);
        int n = stringArray3.length;
        int n2 = 0;
        int n3 = this.linesPerPage - (stringArray2.length + 2);
        int n4 = -1;
        while (n4 != 1 && n4 != 2) {
            block12: while (n2 < n && n4 != 1 && n4 != 2) {
                int n5;
                for (n5 = n2; n5 < n2 + n3; ++n5) {
                    if (n5 >= n) continue;
                    System.out.println(stringArray3[n5]);
                }
                n4 = -1;
                while (n4 != Integer.MIN_VALUE && n4 != 1 && n4 != 2 && n4 != 99 && n4 != 3 && n4 != 4 && n4 != 5) {
                    System.out.println("");
                    for (n5 = 0; n5 < stringArray2.length; ++n5) {
                        System.out.println(stringArray2[n5]);
                    }
                    n4 = this.getInput();
                    if (n4 == 3) {
                        if (this.printAvailable()) {
                            this.doPrint();
                        }
                        n4 = -1;
                    }
                    if (n4 == 4 && !this.getLicenseAcceptanceProcess().hasNonIBMFile()) {
                        n4 = -1;
                    }
                    if (n4 != 5 || this.getLicenseAcceptanceProcess().isMultiLanguage()) continue;
                    n4 = -1;
                }
                switch (n4) {
                    case 5: {
                        this.getLicenseAcceptanceProcess().setCurrentLocale(this.getLicenseAcceptanceProcess().nextLocale());
                        locale = this.getLicenseAcceptanceProcess().getCurrentLocale();
                        stringArray[0] = this.getCLIMessage();
                        stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale);
                        stringArray3 = this.breakText(600, this.cliFontWidth, this.getLicenseAgreement(locale), locale);
                        n = stringArray3.length;
                        n2 = 0;
                        n3 = this.linesPerPage - (stringArray2.length + 2);
                        n4 = -1;
                        continue block12;
                    }
                    case 4: {
                        if (this.getLicenseAcceptanceProcess().hasNonIBMFile()) {
                            this.doNonIBMDisplay();
                        }
                    }
                    case -2147483648: {
                        if (n2 >= n) continue block12;
                        n2 += n3;
                        continue block12;
                    }
                    case 1: {
                        continue block12;
                    }
                    case 2: {
                        n4 = this.confirmDecline();
                        continue block12;
                    }
                    case 99: {
                        if (n2 == 0) {
                            stringArray3 = this.breakText(600, this.cliFontWidth, this.getLicenseAgreement(locale), locale);
                            n = stringArray3.length;
                            n2 = 0;
                            n3 = this.linesPerPage - (stringArray2.length + 1);
                            continue block12;
                        }
                        if ((n2 -= n3) >= 0) continue block12;
                        n2 = 0;
                        continue block12;
                    }
                }
            }
            if (n4 == 1 || n4 == 2) continue;
            stringArray[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText("cliaccmsg");
            String[] stringArray4 = this.breakText(600, this.cliFontWidth, stringArray, locale);
            n4 = -1;
            while (n4 != 1 && n4 != 2) {
                for (int i = 0; i < stringArray4.length; ++i) {
                    System.out.println(stringArray4[i]);
                }
                n4 = this.getInput();
            }
            switch (n4) {
                case 2: {
                    n4 = this.confirmDecline();
                    if (n4 != 0) break;
                    n2 = 0;
                    break;
                }
            }
        }
        return n4;
    }

    private void doNonIBMDisplay() {
        boolean bl = true;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String[] stringArray = this.breakText(600, this.cliFontWidth, this.getLicenseAcceptanceProcess().getNonIBMText(), Locale.ENGLISH);
        int n = stringArray.length;
        int n2 = 0;
        while (bl) {
            for (int i = 1; i < this.linesPerPage - 1; ++i) {
                if (++n2 < n) {
                    System.out.println(stringArray[n2]);
                    continue;
                }
                bl = false;
            }
            System.out.println(" ");
            System.out.println("-- More, \"q\" to quit --");
            try {
                String string = bufferedReader.readLine();
                bl = !string.equalsIgnoreCase("Q");
            }
            catch (Exception exception) {}
        }
    }

    public void doLAP() {
        this.doLAP(false);
    }

    public void doLAP(boolean bl) {
        if (this.getStatus() == 9 || this.cmdStatus == 9) {
            this.exitLAP(9);
            return;
        }
        if (!this.licenseIsValid()) {
            this.exitLAP(11);
            return;
        }
        if (this.cmdStatus == 5) {
            this.setStatus(9);
            this.exitLAP(9);
            return;
        }
        if (!this.textOnly) {
            if (bl) {
                JLAP jLAP = new JLAP(this, false);
                int n = jLAP.run();
                this.exitLAP(n);
            } else {
                JLAP jLAP = new JLAP(this);
            }
        } else {
            int n = this.doLapCommandLine();
            this.exitLAP(n);
        }
    }

    public int doLapCommandLine() {
        int n;
        Locale locale = new Locale("en", "");
        Locale locale2 = this.langFromCommandLine == null ? this.getSupportedLanguages().getSupportedLocale(Locale.getDefault()) : this.getSupportedLanguages().getSupportedLocale(this.langFromCommandLine);
        if (this.getLicenseAcceptanceProcess().getLicense().isLicenseAvailable(locale2)) {
            this.getLicenseAcceptanceProcess().setCurrentLocale(locale2);
        }
        try {
            this.cliFontWidth = Integer.parseInt(this.getLicenseAcceptanceProcess().getLAPResources().getText("assumedFontWidth"));
        }
        catch (NumberFormatException numberFormatException) {
            this.cliFontWidth = 18;
        }
        int n2 = -1;
        int n3 = 18;
        try {
            n3 = Integer.parseInt(this.getLicenseAcceptanceProcess().getLAPResources().getText("assumedFontHeight"));
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 18;
        }
        this.linesPerPage = 340 / n3;
        n2 = this.displayLA();
        switch (n2) {
            case 1: {
                n = 9;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                n = 9;
            }
        }
        this.setStatus(n);
        return n;
    }

    public void statusChanged(int n) {
        switch (n) {
            case 9: {
                this.exitLAP(9);
                break;
            }
            case 3: {
                this.exitLAP(3);
                break;
            }
            default: {
                this.exitLAP(n);
            }
        }
    }

    private void doPrint() {
        Object object;
        GenericDeclaration genericDeclaration;
        String[] stringArray;
        try {
            stringArray = PrinterJob.getPrinterJob();
            genericDeclaration = stringArray.getClass().getMethod("getPrintService", null);
            if (genericDeclaration != null && (object = ((Method)genericDeclaration).invoke(stringArray, null)) == null) {
                System.out.println(this.getLicenseAcceptanceProcess().getLAPResources().getText("printing_error_no_printers"));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = null;
        try {
            stringArray = this.getLicenseAcceptanceProcess().getLicenseAgreementPrint();
            genericDeclaration = Class.forName("com.ibm.lex.lapapp.PageableTextConsole");
            object = (PageableTextConsole)((Class)genericDeclaration).newInstance();
            object.print(stringArray, this.getLicenseAcceptanceProcess().getCurrentLocale());
        }
        catch (Exception exception) {
            Debug.printException(exception);
            System.out.println(exception.toString());
            System.out.println(this.getLicenseAcceptanceProcess().getLAPResources().getText("printErrorA"));
        }
        catch (Error error) {
            Debug.printException(error);
            System.out.println(error.toString());
            System.out.println(this.getLicenseAcceptanceProcess().getLAPResources().getText("printErrorA"));
        }
    }

    private boolean printAvailable() {
        if (this.noPrint) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.lex.lapapp.PageableTextConsole");
            return true;
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        return false;
    }

    private int getInput() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "";
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string.length() == 0) {
            return Integer.MIN_VALUE;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    private Locale getLanguage() {
        int n;
        String[] stringArray = new String[1];
        Locale locale = this.getLicenseAcceptanceProcess().getCurrentLocale();
        Locale locale2 = new Locale("en", "");
        int n2 = -1;
        String string = this.getLicenseAcceptanceProcess().getLAPResources().getText("clilangmsg");
        stringArray[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText("clilang2msg");
        String[] stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale);
        while (n2 < 1 || n2 > 13) {
            System.out.println(string);
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println(stringArray2[i]);
            }
            n2 = this.getInput();
        }
        switch (n2) {
            case 1: {
                locale2 = SupportedLanguages.CZECH;
                break;
            }
            case 2: {
                locale2 = SupportedLanguages.ENGLISH;
                break;
            }
            case 3: {
                locale2 = SupportedLanguages.FRENCH;
                break;
            }
            case 4: {
                locale2 = SupportedLanguages.GERMAN;
                break;
            }
            case 5: {
                locale2 = SupportedLanguages.ITALIAN;
                break;
            }
            case 6: {
                locale2 = SupportedLanguages.POLISH;
                break;
            }
            case 7: {
                locale2 = SupportedLanguages.PORTUGUESE;
                break;
            }
            case 8: {
                locale2 = SupportedLanguages.SPANISH;
                break;
            }
            case 9: {
                locale2 = SupportedLanguages.TURKISH;
                break;
            }
            default: {
                locale2 = SupportedLanguages.DEFAULT_LANGUAGE;
            }
        }
        this.getLicenseAcceptanceProcess().setCurrentLocale(locale2);
        this.getLicenseAcceptanceProcess().getLAPResources().setLocale(locale2);
        try {
            this.cliFontWidth = Integer.parseInt(this.getLicenseAcceptanceProcess().getLAPResources().getText("assumedFontWidth"));
        }
        catch (NumberFormatException numberFormatException) {
            this.cliFontWidth = 18;
        }
        stringArray[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText("climsg1");
        stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale2);
        for (n = 0; n < stringArray2.length; ++n) {
            System.out.println(stringArray2[n]);
        }
        stringArray[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText("climsg2");
        stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale2);
        for (n = 0; n < stringArray2.length; ++n) {
            System.out.println(stringArray2[n]);
        }
        n2 = this.getInput();
        return locale2;
    }

    private String getLanguageLabel() {
        return "View in " + this.getLicenseAcceptanceProcess().getNextLocale().getDisplayLanguage(LAPConstants.DEFAULT_LOCALE);
    }

    private LAPResources getLAPResources() {
        return this.getLicenseAcceptanceProcess().getLAPResources();
    }

    public String getLAPTitle() {
        return this.getLAPResources().getText("title");
    }

    private License getLicense() {
        return this.getLicenseAcceptanceProcess().getLicense();
    }

    public LicenseAcceptanceProcess getLicenseAcceptanceProcess() {
        if (this.licenseAcceptanceProcess == null) {
            this.licenseAcceptanceProcess = new LicenseAcceptanceProcess(this, this.laPath, this.mPath, this.statusPath, this.langFromCommandLine);
            if (this.noExportLA) {
                this.licenseAcceptanceProcess.setNoExportLA();
            }
        }
        return this.licenseAcceptanceProcess;
    }

    public String[] getLicenseAgreement(Locale locale) {
        return this.getLicenseAcceptanceProcess().getLicenseAgreement(locale);
    }

    public final String getRegDesc() {
        return this.regDesc;
    }

    public final boolean getRegister() {
        return this.register;
    }

    public int getStatus() {
        return this.getLicenseAcceptanceProcess().getStatus();
    }

    public SupportedLanguages getSupportedLanguages() {
        if (this.supportedLangs == null) {
            this.supportedLangs = new SupportedLanguages(this.languageSet, false);
        }
        return this.supportedLangs;
    }

    public final String getUniqueID() {
        return this.uniqueID;
    }

    private boolean isCmdStatusValid(int n) {
        return n == 1 || n == 5 || n == 9;
    }

    public boolean licenseIsValid() {
        return this.getLicense().licenseExists(this.getSupportedLanguages().getSupportedLocales());
    }

    public static void main(String[] stringArray) {
        LAP lAP = new LAP(stringArray);
        System.exit(lAP.ExitCode);
    }

    public static int run(String[] stringArray) {
        LAP lAP = new LAP(stringArray, false);
        int n = lAP.run();
        return n;
    }

    private int run() {
        if (this.ExitCode == -1) {
            this.doLAP(true);
        }
        return this.ExitCode;
    }

    private void parseArgs(String[] stringArray) {
        block23: {
            try {
                this.cline = new Commandline(stringArray, this.flags, this.options, this.longFlags, this.longOptions);
                if (this.cline.hasOption(ASKVERSION)) {
                    System.out.println("2.13.0");
                }
                if (!this.cline.hasOption(LA_PATH_OPT) || !this.cline.hasOption(STATUS_PATH_OPT)) {
                    this.exitLAP(17);
                    return;
                }
                this.validatePaths(this.cline);
                if (this.cline.hasOption(STATUS_OPT)) {
                    this.validateCmdStatus(this.cline.getOption(STATUS_OPT));
                }
                if (this.cline.hasOption(MASTER_PATH_OPT)) {
                    this.mPath = this.cline.getOption(MASTER_PATH_OPT);
                }
                if (this.cline.hasOption(NO_PRINT_OPT)) {
                    this.noPrint = true;
                }
                if (this.cline.hasOption(NO_EXPORT_OPT)) {
                    this.noExport = true;
                }
                if (this.cline.hasOption(WIN_STYLE_OPT)) {
                    this.winStyle = this.cline.getOption(WIN_STYLE_OPT);
                }
                if (this.cline.hasOption(WIN_COLOR_OPT)) {
                    this.winColorString = this.cline.getOption(WIN_COLOR_OPT);
                }
                if (this.cline.hasOption(DIALOG_BACKCOLOR_OPT)) {
                    this.dialogBackcolorString = this.cline.getOption(DIALOG_BACKCOLOR_OPT);
                }
                if (this.cline.hasOption(DIALOG_SIZE_OPT)) {
                    this.dialogSizeString = this.cline.getOption(DIALOG_SIZE_OPT);
                }
                if (this.cline.hasOption(FONT_NAME_OPT)) {
                    this.fontName = this.cline.getOption(FONT_NAME_OPT);
                }
                if (this.cline.hasOption(FONT_STYLE_OPT)) {
                    this.fontStyleString = this.cline.getOption(FONT_STYLE_OPT);
                }
                if (this.cline.hasOption(FONT_SIZE_OPT)) {
                    this.fontSizeString = this.cline.getOption(FONT_SIZE_OPT);
                }
                if (this.cline.hasOption(SHOW_EXIT_CODE_OPT)) {
                    this.bShowExitCode = true;
                }
                if (this.cline.hasOption(TEXT_ONLY_OPT)) {
                    this.textOnly = true;
                }
                if (this.cline.hasOption(SETLANG)) {
                    this.langFromCommandLine = new Locale(this.cline.getOption(SETLANG));
                }
                if (this.cline.hasOption(LANGSET)) {
                    this.languageSet = this.cline.getOption(LANGSET);
                    boolean bl = false;
                    String[] stringArray2 = LAPConstants.OVERRIDE_LANGUAGE_SETS;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!this.languageSet.equals(stringArray2[i])) continue;
                        bl = true;
                    }
                    if (!bl) {
                        Debug.println("Invalid language set specified");
                        this.exitLAP(18);
                    }
                }
                if (!this.cline.hasOption(REG_OPT)) break block23;
                this.register = true;
                if (!this.cline.hasOption(UNIQUE_ID_OPT)) {
                    this.exitLAP(17);
                    return;
                }
                this.uniqueID = this.cline.getOption(UNIQUE_ID_OPT);
                if (this.cline.hasOption(REG_DESC_OPT)) {
                    this.regDesc = this.cline.getOption(REG_DESC_OPT);
                    break block23;
                }
                this.exitLAP(17);
                return;
            }
            catch (InvalidCommandlineArgument invalidCommandlineArgument) {
                this.exitLAP(18);
                return;
            }
        }
    }

    public void setExportLA(boolean bl) {
        this.noExportLA = !bl;
    }

    public void setStatus(int n) {
        this.getLicenseAcceptanceProcess().setStatus(n);
    }

    private void validateCmdStatus(String string) {
        try {
            this.cmdStatus = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.exitLAP(18);
        }
        if (!this.isCmdStatusValid(this.cmdStatus)) {
            this.exitLAP(18);
        }
    }

    private void validatePaths(Commandline commandline) {
        File file;
        File file2;
        this.laPath = commandline.getOption(LA_PATH_OPT);
        this.statusPath = commandline.getOption(STATUS_PATH_OPT);
        if (commandline.hasOption(MASTER_PATH_OPT)) {
            this.mPath = commandline.getOption(MASTER_PATH_OPT);
            if (!(this.mPath.equals("") || (file2 = new File(this.mPath)).exists() || file2.mkdirs())) {
                this.mPath = null;
            }
        }
        if (this.laPath.equals("") || this.statusPath.equals("")) {
            this.exitLAP(17);
        }
        file2 = new File(this.laPath);
        File file3 = new File(this.statusPath);
        if (!file2.exists()) {
            this.exitLAP(19);
        }
        if (!file3.exists() && !file3.mkdirs()) {
            this.exitLAP(20);
        }
        if (!(file = new File(file3, "status.dat")).exists()) {
            try {
                new FileOutputStream(file.toString(), true).close();
                file.delete();
            }
            catch (IOException iOException) {
                this.exitLAP(21);
            }
        }
    }

    private void exitLAP(int n) {
        if (this.bShowExitCode) {
            System.out.println("Exited with: " + n);
        } else if (n != 3 && n != 9) {
            System.out.println("Exited with: " + n);
        }
        this.ExitCode = n;
    }

    public String getmPath() {
        return this.mPath;
    }

    public boolean getnoPrint() {
        return this.noPrint;
    }

    public boolean getnoExport() {
        return this.noExport;
    }

    public String getwinStyle() {
        return this.winStyle;
    }

    public String getwinColorString() {
        return this.winColorString;
    }

    public String getdialogBackcolorString() {
        return this.dialogBackcolorString;
    }

    public String getdialogSizeString() {
        return this.dialogSizeString;
    }

    public String getfontName() {
        return this.fontName;
    }

    public String getfontStyleString() {
        return this.fontStyleString;
    }

    public String getfontSizeString() {
        return this.fontSizeString;
    }

    public boolean getbShowExitCode() {
        return this.bShowExitCode;
    }
}

